/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.wizard.jsfaction;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.wizard.jsfaction.IMBDataModelProperties;
import com.ibm.etools.jsf.support.wizard.jsfaction.MBCreationWizardPage;
import com.ibm.etools.jsf.support.wizard.jsfaction.MBDataModelProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class MBCreationWizard
extends DataModelWizard
implements INewWizard,
IMBDataModelProperties {
    protected static final String MAIN_PG = "main";
    private boolean isFacesAction = true;

    public MBCreationWizard() {
        this.setWindowTitle(Messages.MBCreationWizard_Title);
        this.setDefaultPageImageDescriptor(JsfPlugin.getDefault().getImageDescriptor("wizban/FacesActionWizBanner"));
    }

    public MBCreationWizard(boolean isFacesAction) {
        if (isFacesAction) {
            this.setWindowTitle(Messages.MBCreationWizard_Title);
        } else {
            this.setWindowTitle(Messages.MBCreationWizard_Title2);
        }
        this.isFacesAction = isFacesAction;
        this.setDefaultPageImageDescriptor(JsfPlugin.getDefault().getImageDescriptor("wizban/FacesActionWizBanner"));
    }

    public MBCreationWizard(IDataModel model) {
        super(model);
    }

    protected IDataModelProvider getDefaultProvider() {
        return new MBDataModelProvider();
    }

    protected void doAddPages() {
        this.addPage((IWizardPage)new MBCreationWizardPage(this.getDataModel(), MAIN_PG, this.isFacesAction));
    }

    public final void init(IWorkbench workbench, IStructuredSelection aSelection) {
        this.setNeedsProgressMonitor(true);
    }

    protected boolean prePerformFinish() {
        return this.saveFiles();
    }

    private boolean saveFiles() {
        IResource beanClass = this.getResourceForBeanClass();
        IResource configFile = this.getResourceForConfigFile();
        IResource[] resources = new IResource[]{beanClass, configFile};
        ArrayList<IResource> list = this.getDirtyFiles(resources);
        if (list.size() != 0) {
            MessageBox box = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 192);
            box.setText(Messages.MBCreationWizard_SaveFiles);
            String files = list.get(0).getName().toString();
            if (list.size() > 1) {
                files = String.valueOf(files) + ", " + list.get(1).getName().toString();
                box.setMessage(NLS.bind((String)Messages.MBCreationWizard_Prompt1, (Object)files));
            } else {
                box.setMessage(NLS.bind((String)Messages.MBCreationWizard_Prompt2, (Object)files));
            }
            if (box.open() != 64) {
                return false;
            }
            IResource[] res = new IResource[list.size()];
            int i = 0;
            while (i < list.size()) {
                res[i] = list.get(i);
                ++i;
            }
            SaveEditorJob job = new SaveEditorJob(res);
            job.schedule();
        }
        return true;
    }

    private IResource getResourceForBeanClass() {
        IVirtualComponent comp = (IVirtualComponent)this.getDataModel().getProperty("IMBDataModelProerties.COMPONENT");
        IProject prj = comp.getProject();
        IJavaProject jp = JavaCore.create((IProject)prj);
        String className = this.getDataModel().getStringProperty("IMBDataModelProperties.BEAN_CLASS");
        IType t = null;
        try {
            t = jp.findType(className);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (t == null || t.equals("")) {
            return null;
        }
        IPath path = t.getPath();
        IResource beanClassFile = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        return beanClassFile;
    }

    private IResource getResourceForConfigFile() {
        IVirtualComponent comp = (IVirtualComponent)this.getDataModel().getProperty("IMBDataModelProerties.COMPONENT");
        String configFile = "";
        Object cf = this.getDataModel().getProperty("IMBDataModelProperties.CONFIG_FILE");
        if (cf instanceof DataModelPropertyDescriptor) {
            configFile = ((DataModelPropertyDescriptor)cf).toString();
        } else if (cf instanceof String) {
            configFile = (String)cf;
        }
        FacesConfigArtifactEdit fc = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)comp.getProject(), (String)configFile);
        fc.getDeploymentDescriptorResource();
        IFile file = fc.getFile();
        fc.dispose();
        return file;
    }

    private ArrayList<IResource> getDirtyFiles(IResource[] resourceRoots) {
        final IResource[] finalResources = resourceRoots;
        final ArrayList<IResource> dirtyFiles = new ArrayList<IResource>();
        if (resourceRoots.length == 0) {
            return dirtyFiles;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchWindow window = windows[i];
                    IWorkbenchPage[] pages = window.getPages();
                    int j = 0;
                    while (j < pages.length) {
                        IWorkbenchPage page = pages[j];
                        IEditorPart[] dirty = page.getDirtyEditors();
                        int k = 0;
                        while (k < dirty.length) {
                            IEditorPart part = dirty[k];
                            IFile file = ResourceUtil.getFile((IEditorInput)part.getEditorInput());
                            if (file != null) {
                                int l = 0;
                                while (l < finalResources.length) {
                                    IResource resource = finalResources[l];
                                    if (resource == null) break;
                                    if (resource.getFullPath().isPrefixOf(file.getFullPath())) {
                                        dirtyFiles.add(resource);
                                        break;
                                    }
                                    ++l;
                                }
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        return dirtyFiles;
    }

    private static final class SaveEditorJob
    extends UIJob {
        private final IResource[] resources;

        private SaveEditorJob(IResource[] res) {
            super("Save Dirty Editors");
            this.resources = res;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IDE.saveAllEditors((IResource[])this.resources, (boolean)false);
            return Status.OK_STATUS;
        }
    }
}

