/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.wizard;

import com.ibm.etools.common.frameworks.internal.datamodel.ComposedOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.jsf.designtime.DesignTimeUtil;
import com.ibm.etools.jsf.facesconfig.util.JSFFacesConfigUtil;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.wizard.JsfBaseFacetRuntimeChangedDelegate;
import com.ibm.etools.jsf.internal.wizard.ResourceUpdateDialog;
import com.ibm.etools.jsf.internal.wizard.UserDefinedLibraryWizardOperation;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.support.wizard.JsfWizardOperationBase;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.webproject.features.taglibs.internal.util.JSTLFacetUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.osgi.framework.Bundle;

public class WizardUtil {
    public static final String RESOURCE_UPDATE_CHECK_PROPERTY = "jsf_update_check";
    public static final String JSF_BASE_FACET_ID = "jsf.base";
    public static final String JSF_IBM_FACET_ID = "jsf.ibm";
    public static final String WTP_JSF_FACET_ID = "jst.jsf";
    private static boolean rememberResourceUpdateSetting = false;
    private static int lastResourceUpdateResult = 0;

    private WizardUtil() {
    }

    public static boolean verifyTaglibResources(String taglibUri) {
        IProject project = JsfProjectUtil.getProject();
        return WizardUtil.verifyTaglibResources(taglibUri, project);
    }

    public static boolean verifyTaglibResources(String taglibUri, IProject project) {
        if (taglibUri != null) {
            JsfWizardOperationBase wizardOp = WizardUtil.getWizardOperation(ExtensionRegistry.getRegistry().getWizardId(taglibUri), project);
            if (wizardOp == null && LibraryManager.getInstance().isLibraryDefined(taglibUri)) {
                wizardOp = new UserDefinedLibraryWizardOperation(taglibUri);
            }
            if (wizardOp == null) {
                return true;
            }
            if (wizardOp.isAlreadyRun(project)) {
                JsfWizardOperationBase[] dependentOps = WizardUtil.getDependentWizardOperations(wizardOp, project);
                int i = 0;
                while (i < dependentOps.length) {
                    if (!dependentOps[i].isAlreadyRun(project)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private static final void markFeatures(List<JsfWizardOperationBase> migratableOps, IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        int i = 0;
        while (i < migratableOps.size()) {
            JsfWizardOperationBase wizOp = migratableOps.get(i);
            String featureId = wizOp.getWizardId();
            String version = wizOp.getRuntimeVersion();
            component.setMetaProperty(featureId, version);
            ++i;
        }
    }

    public static WTPOperation buildWizardOperation(String taglibUri, IProject project) {
        JsfWizardOperationBase wizardOp = WizardUtil.getWizardOperation(ExtensionRegistry.getRegistry().getWizardId(taglibUri), project);
        if (wizardOp == null && LibraryManager.getInstance().isLibraryDefined(taglibUri)) {
            wizardOp = new UserDefinedLibraryWizardOperation(taglibUri);
        }
        if (wizardOp != null) {
            wizardOp.setTargetProject(project);
            return WizardUtil.chainDependentOperations(wizardOp, project);
        }
        return null;
    }

    public static WTPOperation chainDependentOperations(WTPOperation localOp, IProject project) {
        JsfWizardOperationBase[] dependentOps = WizardUtil.getDependentWizardOperations(localOp, project);
        int numOps = dependentOps.length;
        ComposedOperation composedOp = new ComposedOperation();
        int i = 0;
        while (i < numOps) {
            JsfWizardOperationBase newOp = dependentOps[i];
            if (!newOp.isAlreadyRun(project)) {
                newOp.setTargetProject(project);
                composedOp.addRunnable((WTPOperation)newOp);
            }
            ++i;
        }
        composedOp.addRunnable(localOp);
        return composedOp;
    }

    /*
     * Exception decompiling
     */
    public static JsfWizardOperationBase getWizardOperation(String wizardId, IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static JsfWizardOperationBase getWizardOperation(String wizardId, IProject project, IDataModel dataModel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static JsfWizardOperationBase[] getDependentWizardOperations(WTPOperation operation, IProject project) {
        ArrayList<JsfWizardOperationBase> list = new ArrayList<JsfWizardOperationBase>();
        if (operation instanceof UserDefinedLibraryWizardOperation) {
            String taglibUri = ((JsfWizardOperationBase)operation).taglibUri;
            LibraryDefinitionType library = LibraryManager.getInstance().getLibraryDefinitionModel(taglibUri);
            if (library.getLibraryConfig() != null) {
                EList dependencies = library.getLibraryConfig().getTaglibDependencies().getTaglibUri();
                int i = 0;
                while (i < dependencies.size()) {
                    String dependency = (String)dependencies.get(i);
                    String wizardId = ExtensionRegistry.getRegistry().getWizardId(dependency);
                    if (wizardId != null) {
                        JsfWizardOperationBase wiz = WizardUtil.getWizardOperation(wizardId, project);
                        if (wiz != null) {
                            list.add(wiz);
                        }
                    } else {
                        list.add(new UserDefinedLibraryWizardOperation(dependency));
                    }
                    ++i;
                }
            }
        } else {
            String[] wizardIds = ExtensionRegistry.getRegistry().getWizardOperationDependencies(operation.getClass());
            int i = 0;
            while (i < wizardIds.length) {
                JsfWizardOperationBase wiz = WizardUtil.getWizardOperation(wizardIds[i], project);
                if (wiz != null) {
                    list.add(wiz);
                }
                ++i;
            }
        }
        return list.toArray(new JsfWizardOperationBase[0]);
    }

    protected static List<JsfWizardOperationBase> getAllOperations(IProject project) {
        ArrayList<JsfWizardOperationBase> allOps = new ArrayList<JsfWizardOperationBase>();
        String[] allIds = ExtensionRegistry.getRegistry().getAllWizardIds();
        int i = 0;
        while (i < allIds.length) {
            JsfWizardOperationBase op = WizardUtil.getWizardOperation(allIds[i], project);
            if (op != null) {
                allOps.add(op);
            }
            ++i;
        }
        return allOps;
    }

    public static List<JsfWizardOperationBase> getMigratableOperations(IProject project) {
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<JsfWizardOperationBase> migratableOps = new ArrayList<JsfWizardOperationBase>();
        List<JsfWizardOperationBase> allOps = WizardUtil.getAllOperations(project);
        Iterator<JsfWizardOperationBase> iter = allOps.iterator();
        JsfWizardOperationBase op = null;
        while (iter.hasNext()) {
            op = iter.next();
            if (!op.mayNeedMigration(project, true)) continue;
            migratableOps.add(op);
        }
        String[] userTaglibs = LibraryManager.getInstance().getLibraryTaglibUris();
        int i = 0;
        while (i < userTaglibs.length) {
            UserDefinedLibraryWizardOperation userOp = new UserDefinedLibraryWizardOperation(userTaglibs[i]);
            if (userOp.mayNeedMigration(project, true)) {
                migratableOps.add(userOp);
            }
            ++i;
        }
        return migratableOps;
    }

    public static void checkWtpJsfFacet(IProject project) {
        try {
            try {
                IProjectFacet wtpFacet;
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (ProjectFacetsManager.isProjectFacetDefined((String)WTP_JSF_FACET_ID) && !facetedProject.hasProjectFacet(wtpFacet = ProjectFacetsManager.getProjectFacet((String)WTP_JSF_FACET_ID))) {
                    Debug.trace("[wiz] adding WTP-JSF facet in project: " + project.getName(), "wizard");
                    HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
                    IProjectFacetVersion facetVersion = wtpFacet.getVersion("1.1");
                    if (facetVersion != null) {
                        actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, null));
                    }
                    IRuntime oldRuntime = facetedProject.getPrimaryRuntime();
                    Set oldRuntimes = facetedProject.getTargetedRuntimes();
                    JsfBaseFacetRuntimeChangedDelegate.suspend();
                    facetedProject.modify(actions, (IProgressMonitor)new NullProgressMonitor());
                    if (oldRuntimes != null) {
                        facetedProject.setTargetedRuntimes(oldRuntimes, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (oldRuntime != null) {
                        facetedProject.setPrimaryRuntime(oldRuntime, (IProgressMonitor)new NullProgressMonitor());
                    }
                    Debug.trace("[wiz] installing DT Resolvers in project: " + project.getName(), "wizard");
                    DesignTimeUtil.setupDTResolversForProject(project);
                }
            }
            catch (Throwable throwable) {
                JsfBaseFacetRuntimeChangedDelegate.resume();
            }
        }
        finally {
            JsfBaseFacetRuntimeChangedDelegate.resume();
        }
    }

    public static void checkAndUpdate(IProject project) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (rememberResourceUpdateSetting && lastResourceUpdateResult == 11) {
            return;
        }
        if (!JsfProjectUtil.isJsfProject((IProject)project)) {
            return;
        }
        QualifiedName qn = new QualifiedName(project.getName(), RESOURCE_UPDATE_CHECK_PROPERTY);
        try {
            if (project.getSessionProperty(qn) != null) {
                return;
            }
        }
        catch (CoreException coreException) {}
        List<JsfWizardOperationBase> migratableOps = WizardUtil.getMigratableOperations(project);
        if (migratableOps.size() > 0) {
            WizardUtil.createResourceUpdateMarker(project);
        }
        try {
            project.setSessionProperty(qn, new Object());
        }
        catch (CoreException coreException) {}
    }

    public static void createResourceUpdateMarker(IProject project) {
        try {
            IMarker marker;
            IMarker[] markers = project.findMarkers("com.ibm.etools.jsf.resourceUpdateMarker", false, 0);
            if (markers.length == 0 && (marker = project.createMarker("com.ibm.etools.jsf.resourceUpdateMarker")).exists()) {
                marker.setAttribute("message", (Object)Messages.WizardUtil_MigrationMarkerMessage);
                marker.setAttribute("severity", 2);
                marker.setAttribute("location", (Object)project.getName());
                marker.setAttribute("projectName", (Object)project.getName());
                Debug.trace("[wiz] resource update marker was created for project '" + project.getName() + "'", "wizard");
            }
        }
        catch (CoreException coreException) {}
    }

    public static void launchResourceUpdateDialog(final IProject project) {
        final List<JsfWizardOperationBase> migratableOps = WizardUtil.getMigratableOperations(project);
        if (migratableOps.size() == 0) {
            Debug.trace("[wiz] resource update was triggered but nothing to update in " + project.getName(), "wizard");
            return;
        }
        Debug.trace("[wiz] resource update trigger in project: " + project.getName(), "wizard");
        if (ErrorDialog.AUTOMATED_MODE || SafeRunnable.getIgnoreErrors()) {
            Debug.trace("[wiz] resource update was deferred -- running an automated test", "wizard");
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    int result = 0;
                    if (rememberResourceUpdateSetting) {
                        result = lastResourceUpdateResult;
                    } else {
                        ResourceUpdateDialog dialog = new ResourceUpdateDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        dialog.setProjectName(project.getName());
                        dialog.setOperationsList(migratableOps);
                        result = dialog.open();
                        if (dialog.getRememberChoice()) {
                            rememberResourceUpdateSetting = true;
                            lastResourceUpdateResult = result;
                        }
                    }
                    switch (result) {
                        case 10: {
                            Debug.trace("[wiz] performing resource update", "wizard");
                            int numOps = migratableOps.size();
                            ComposedOperation composedOp = new ComposedOperation();
                            int i = 0;
                            while (i < numOps) {
                                JsfWizardOperationBase newOp = (JsfWizardOperationBase)((Object)migratableOps.get(i));
                                newOp.setTargetProject(project);
                                composedOp.addRunnable((WTPOperation)newOp);
                                ++i;
                            }
                            try {
                                ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                                monitorDialog.create();
                                composedOp.run(monitorDialog.getProgressMonitor());
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {}
                            break;
                        }
                        case 11: {
                            Debug.trace("[wiz] resource update was deferred", "wizard");
                            break;
                        }
                        case 12: {
                            Debug.trace("[wiz] resource update rejected - marking project features", "wizard");
                            WizardUtil.markFeatures(migratableOps, project);
                        }
                    }
                }
            });
            try {
                IMarker marker;
                IMarker[] markers = project.findMarkers("com.ibm.etools.jsf.resourceUpdateMarker", false, 0);
                if (markers.length > 0 && (marker = markers[0]).exists()) {
                    marker.delete();
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public static int compareVersions(String existing, String target) {
        StringTokenizer existingTokenizer = new StringTokenizer(existing, ".");
        String[] existingSegments = new String[4];
        int count = 0;
        while (existingTokenizer.hasMoreTokens()) {
            existingSegments[count++] = existingTokenizer.nextToken();
        }
        int i = count;
        while (i < 4) {
            existingSegments[i] = "0";
            ++i;
        }
        StringTokenizer targetTokenizer = new StringTokenizer(target, ".");
        String[] targetSegments = new String[4];
        count = 0;
        while (targetTokenizer.hasMoreTokens()) {
            targetSegments[count++] = targetTokenizer.nextToken();
        }
        int i2 = count;
        while (i2 < 4) {
            targetSegments[i2] = "0";
            ++i2;
        }
        try {
            int result = Integer.parseInt(targetSegments[0]) - Integer.parseInt(existingSegments[0]);
            if (result != 0) {
                return result;
            }
            result = Integer.parseInt(targetSegments[1]) - Integer.parseInt(existingSegments[1]);
            if (result != 0) {
                return result;
            }
            result = Integer.parseInt(targetSegments[2]) - Integer.parseInt(existingSegments[2]);
            if (result != 0) {
                return result;
            }
            return targetSegments[3].compareTo(existingSegments[3]);
        }
        catch (NumberFormatException numberFormatException) {
            return target.compareTo(existing);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void installJsfFacets(IProject project, String taglibUri) throws IllegalStateException {
        IFacetedProject facetedProject;
        NullProgressMonitor monitor = new NullProgressMonitor();
        boolean extendedFacetNeedsInstall = false;
        String wizardId = ExtensionRegistry.getRegistry().getWizardId(taglibUri);
        if ("jsf.extended".equals(wizardId)) {
            extendedFacetNeedsInstall = true;
        } else if (wizardId != null) {
            String[] wizardIds = ExtensionRegistry.getRegistry().getWizardOperationDependencies(wizardId);
            int i = 0;
            while (i < wizardIds.length) {
                if ("jsf.extended".equals(wizardIds[i])) {
                    extendedFacetNeedsInstall = true;
                    break;
                }
                ++i;
            }
        } else {
            LibraryDefinitionType library = LibraryManager.getInstance().getLibraryDefinitionModel(taglibUri);
            if (library.getLibraryConfig() != null && library.getLibraryConfig().getTaglibDependencies().getTaglibUri().contains((Object)"http://www.ibm.com/jsf/html_extended")) {
                extendedFacetNeedsInstall = true;
            }
        }
        if (extendedFacetNeedsInstall) {
            try {
                IProjectFacet jstlFacet;
                IProjectFacetVersion jstlFacetVersion;
                IProjectFacetVersion wtpJsfFacetVersion;
                IProjectFacet wtpJsfFacet;
                facetedProject = ProjectFacetsManager.create((IProject)project);
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)JSF_IBM_FACET_ID);
                IProjectFacetVersion facetVersion = facet.getVersion("7.0");
                if (facetedProject.hasProjectFacet(facetVersion)) return;
                HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
                String webFacetVersionString = null;
                IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
                IProjectFacetVersion webFacetVersion = facetedProject.getProjectFacetVersion(webFacet);
                if (webFacetVersion != null) {
                    webFacetVersionString = webFacetVersion.getVersionString();
                }
                if (!facetedProject.hasProjectFacet(wtpJsfFacet = ProjectFacetsManager.getProjectFacet((String)WTP_JSF_FACET_ID)) && (wtpJsfFacetVersion = "2.5".equals(webFacetVersionString) ? wtpJsfFacet.getVersion("1.2") : wtpJsfFacet.getVersion("1.1")) != null) {
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, wtpJsfFacetVersion, null));
                }
                if ((jstlFacetVersion = (jstlFacet = ProjectFacetsManager.getProjectFacet((String)"web.jstl")).getVersion(JSTLFacetUtil.getDefaultJSTLVersion((IProject)project))) != null && !facetedProject.hasProjectFacet(jstlFacet)) {
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, jstlFacetVersion, null));
                }
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, null));
                facet = ProjectFacetsManager.getProjectFacet((String)JSF_BASE_FACET_ID);
                facetVersion = facet.getVersion("7.0");
                if (facetVersion != null && !facetedProject.hasProjectFacet(facetVersion)) {
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, null));
                }
                facetedProject.modify(actions, (IProgressMonitor)monitor);
                return;
            }
            catch (CoreException ce) {
                Throwable cause = ce.getStatus().getException();
                if (!(cause instanceof IllegalStateException)) return;
                throw (IllegalStateException)cause;
            }
        }
        try {
            IProjectFacet jstlFacet;
            IProjectFacetVersion jstlFacetVersion;
            IProjectFacetVersion wtpJsfFacetVersion;
            IProjectFacet wtpJsfFacet;
            facetedProject = ProjectFacetsManager.create((IProject)project);
            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)JSF_BASE_FACET_ID);
            IProjectFacetVersion facetVersion = facet.getVersion("7.0");
            if (facetedProject.hasProjectFacet(facetVersion)) return;
            HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
            String webFacetVersionString = null;
            IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
            IProjectFacetVersion webFacetVersion = facetedProject.getProjectFacetVersion(webFacet);
            if (webFacetVersion != null) {
                webFacetVersionString = webFacetVersion.getVersionString();
            }
            if (!facetedProject.hasProjectFacet(wtpJsfFacet = ProjectFacetsManager.getProjectFacet((String)WTP_JSF_FACET_ID)) && (wtpJsfFacetVersion = "2.5".equals(webFacetVersionString) ? wtpJsfFacet.getVersion("1.2") : wtpJsfFacet.getVersion("1.1")) != null) {
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, wtpJsfFacetVersion, null));
            }
            if ((jstlFacetVersion = (jstlFacet = ProjectFacetsManager.getProjectFacet((String)"web.jstl")).getVersion(JSTLFacetUtil.getDefaultJSTLVersion((IProject)project))) != null && !facetedProject.hasProjectFacet(jstlFacet)) {
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, jstlFacetVersion, null));
            }
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, null));
            facetedProject.modify(actions, (IProgressMonitor)monitor);
            return;
        }
        catch (CoreException ce) {
            Throwable cause = ce.getStatus().getException();
            if (!(cause instanceof IllegalStateException)) return;
            throw (IllegalStateException)cause;
        }
    }

    public static boolean hasJSFFacet(IProject project, String facetId, String versionName) {
        IProjectFacet facet;
        IFacetedProject facetedProject;
        block10: {
            block9: {
                if (project == null) {
                    return false;
                }
                try {
                    facetedProject = ProjectFacetsManager.create((IProject)project);
                    if (facetedProject != null) break block9;
                    return false;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            facet = null;
            if (JSF_IBM_FACET_ID.equals(facetId)) {
                facet = ProjectFacetsManager.getProjectFacet((String)JSF_IBM_FACET_ID);
            } else if (JSF_BASE_FACET_ID.equals(facetId)) {
                facet = ProjectFacetsManager.getProjectFacet((String)JSF_BASE_FACET_ID);
            }
            if (facet != null) break block10;
            return false;
        }
        if (versionName == null) {
            return facetedProject.hasProjectFacet(facet);
        }
        IProjectFacetVersion facetVersion = facet.getVersion(versionName);
        return facetedProject.hasProjectFacet(facetVersion);
    }

    public static void checkAndAddJSFFacets(IProject project) {
        block15: {
            if (JsfProjectUtil.isJsfProject((IProject)project)) {
                return;
            }
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IContainer webContent = component.getRootFolder().getUnderlyingFolder();
            IResource facesConfigFile = webContent.findMember("/WEB-INF/faces-config.xml");
            if (!(facesConfigFile != null && facesConfigFile.exists() || JSFFacesConfigUtil.getFacesConfigContextParamValue((IProject)project) != null)) {
                return;
            }
            component.setMetaProperty(JSF_BASE_FACET_ID, "0.0.0");
            component.setMetaProperty("jsf.ri", "0.0.0");
            boolean installExtendedFacet = false;
            JsfWizardOperationBase op = WizardUtil.getWizardOperation("jsf.extended", project);
            if (op != null) {
                String sourceDir = null;
                try {
                    sourceDir = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.etools.jsf.jwl.resources"), (IPath)new Path("/runtime/icu4j_3_4_1.jar"), null)).getPath().toString();
                    op.removeWizardDirectoryMapping(sourceDir);
                    sourceDir = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.etools.jsf.jwl.resources"), (IPath)new Path("/resources"), null)).getPath().toString();
                    op.removeWizardDirectoryMapping(sourceDir);
                }
                catch (IOException iOException) {}
                if (op.isAlreadyRun(project)) {
                    installExtendedFacet = true;
                }
            }
            try {
                IProjectFacet facet;
                IProjectFacetVersion facetVersion;
                IProjectFacet jstlFacet;
                IProjectFacetVersion jstlFacetVersion;
                HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                IProjectFacet wtpJsfFacet = ProjectFacetsManager.getProjectFacet((String)WTP_JSF_FACET_ID);
                if (wtpJsfFacet != null) {
                    IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
                    String webVersion = null;
                    Set facets = facetedProject.getProjectFacets();
                    Iterator facetsIter = facets.iterator();
                    String wtpJsfVersion = "1.1";
                    while (facetsIter.hasNext()) {
                        IProjectFacetVersion version = (IProjectFacetVersion)facetsIter.next();
                        if (version.getProjectFacet() != webFacet || !"2.5".equals(webVersion = version.getVersionString())) continue;
                        wtpJsfVersion = "1.2";
                    }
                    IProjectFacetVersion wtpJsfFacetVersion = wtpJsfFacet.getVersion(wtpJsfVersion);
                    if (wtpJsfFacetVersion != null && !facetedProject.hasProjectFacet(wtpJsfFacet)) {
                        actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, wtpJsfFacetVersion, null));
                    }
                }
                if ((jstlFacetVersion = (jstlFacet = ProjectFacetsManager.getProjectFacet((String)"web.jstl")).getVersion(JSTLFacetUtil.getDefaultJSTLVersion((IProject)project))) != null && !facetedProject.hasProjectFacet(jstlFacet)) {
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, jstlFacetVersion, null));
                }
                if (!facetedProject.hasProjectFacet(facetVersion = (facet = ProjectFacetsManager.getProjectFacet((String)JSF_BASE_FACET_ID)).getVersion("7.0"))) {
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, null));
                }
                if (installExtendedFacet && !facetedProject.hasProjectFacet(facetVersion = (facet = ProjectFacetsManager.getProjectFacet((String)JSF_IBM_FACET_ID)).getVersion("7.0"))) {
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, null));
                }
                if (actions.size() > 0) {
                    facetedProject.modify(actions, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException ce) {
                Throwable cause = ce.getStatus().getException();
                if (!(cause instanceof IllegalStateException)) break block15;
                throw (IllegalStateException)cause;
            }
        }
    }

    public static void addTaglibResources(IProject project, String taglibUri) {
        if (!WizardUtil.verifyTaglibResources(taglibUri, project)) {
            WTPOperation op = WizardUtil.buildWizardOperation(taglibUri, project);
            if (op == null) {
                return;
            }
            try {
                op.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            WizardUtil.installJsfFacets(project, taglibUri);
        }
    }

    public static String[] getInstalledTaglibs(IProject project) {
        if (!JsfProjectUtil.isJsfProject((IProject)project)) {
            return new String[0];
        }
        ArrayList<String> installedUris = new ArrayList<String>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            Properties metaProps = component.getMetaProperties();
            String[] wizIds = ExtensionRegistry.getRegistry().getAllWizardIds();
            int i = 0;
            while (i < wizIds.length) {
                String version;
                if (metaProps.containsKey(wizIds[i]) && (version = metaProps.getProperty(wizIds[i])) != null && !"".equals(version)) {
                    installedUris.add(ExtensionRegistry.getRegistry().getTaglibUriForWizardId(wizIds[i]));
                }
                ++i;
            }
            String[] libUris = LibraryManager.getInstance().getLibraryTaglibUris();
            int i2 = 0;
            while (i2 < libUris.length) {
                String version;
                if (metaProps.containsKey(libUris[i2]) && (version = metaProps.getProperty(libUris[i2])) != null && !"".equals(version)) {
                    installedUris.add(libUris[i2]);
                }
                ++i2;
            }
        }
        return installedUris.toArray(new String[0]);
    }
}

