/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.dialogs.AbstractTableEditor;
import com.ibm.etools.webedit.dialogs.insert.IPartContainer;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ValidatorAttributeEditor
extends AbstractTableEditor {
    private String NAME = Messages.ValidatorEditDialog_Name;
    private String VALUE = Messages.ValidatorEditDialog_Value;
    private String PROPERTIES = Messages.ValidatorEditDialog_Attributes;
    private boolean m_bIsReadOnly = false;
    private boolean m_bDisableButton = false;

    public ValidatorAttributeEditor(IPartContainer olc) {
        super(olc);
    }

    @Override
    public Composite createArea(Composite parent) {
        int[] cWidths = new int[]{this.convertHorizontalDLUsToPixels(100), this.convertVerticalDLUsToPixels(130)};
        String[] cTitles = new String[]{this.NAME, this.VALUE};
        this.opEditName = Messages.ValidatorEditDialog_EditName;
        this.opEditValue = Messages.ValidatorEditDialog_EditValue;
        this.opDelete = Messages.ValidatorEditDialog_Remove;
        this.opNew = Messages.ValidatorEditDialog_Add;
        this.listTitle = this.PROPERTIES;
        this.columnWidths = cWidths;
        this.columnTitles = cTitles;
        Composite composite = super.createArea(parent, true, false, false, false);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        return composite;
    }

    @Override
    protected CellEditor getCellEditor(int columnToEdit) {
        CellEditor editorToEdit;
        if (this.m_bIsReadOnly) {
            return null;
        }
        if (this.editors == null) {
            this.editors = new CellEditor[this.editorsNum];
        }
        if ((editorToEdit = this.editors[columnToEdit]) != null) {
            return editorToEdit;
        }
        switch (columnToEdit) {
            case 0: 
            case 1: {
                editorToEdit = new TextCellEditor((Composite)this.dataTable);
            }
        }
        this.editors[columnToEdit] = editorToEdit;
        return editorToEdit;
    }

    public String getAttributes() {
        StringBuffer strbuf = new StringBuffer();
        TableItem[] items = this.dataTable.getItems();
        boolean first = true;
        int i = 0;
        while (i < items.length) {
            if (items[i].getText(0) != null && !items[i].getText(0).equals("")) {
                if (first) {
                    first = false;
                } else {
                    strbuf.append(";");
                }
                strbuf.append(items[i].getText(0));
                strbuf.append("=\"");
                strbuf.append(items[i].getText(1));
                strbuf.append("\"");
            }
            ++i;
        }
        return strbuf.toString();
    }

    void setReadOnly(boolean bIsReadOnly) {
        this.m_bIsReadOnly = bIsReadOnly;
    }

    @Override
    protected void enableButtons() {
        if (this.m_bIsReadOnly) {
            this.newButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            if (this.m_bDisableButton) {
                this.newButton.setEnabled(false);
            } else {
                this.newButton.setEnabled(true);
            }
            super.enableButtons();
            if (this.m_bDisableButton) {
                this.deleteButton.setEnabled(false);
            }
        }
    }

    public void setEnabled(boolean bEnabled) {
        this.m_bIsReadOnly = !bEnabled;
        this.enableButtons();
    }

    public void setDisableButton(boolean b) {
        this.m_bDisableButton = b;
    }

    public String[] getAttrNames() {
        TableItem[] items = this.dataTable.getItems();
        int nLen = items.length;
        int i = 0;
        while (i < items.length) {
            if (items[i].getText(0) == null || items[i].getText(0).equals("")) {
                --nLen;
            }
            ++i;
        }
        String[] strs = new String[nLen];
        int i2 = 0;
        int j = 0;
        while (i2 < items.length) {
            if (items[i2].getText(0) != null && !items[i2].getText(0).equals("")) {
                strs[j++] = items[i2].getText(0);
            }
            ++i2;
        }
        return strs;
    }

    public String[] getAttrValues() {
        TableItem[] items = this.dataTable.getItems();
        String[] strs = new String[items.length];
        int i = 0;
        while (i < items.length) {
            strs[i] = items[i].getText(1);
            ++i;
        }
        return strs;
    }

    public void initTable(String sAttributes, String[] allAttributes) {
        this.dataTable.removeAll();
        if (allAttributes != null) {
            Arrays.sort(allAttributes);
            int i = 0;
            while (i < allAttributes.length) {
                TableItem item = new TableItem(this.dataTable, 0);
                item.setText(0, allAttributes[i]);
                ++i;
            }
            if (sAttributes != null && !sAttributes.equals("")) {
                StringTokenizer t = new StringTokenizer(sAttributes, ";");
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    int equalIndex = token.indexOf(61);
                    int firstIndex = token.indexOf(34);
                    int lastIndex = token.lastIndexOf(34);
                    if (equalIndex == -1 || firstIndex == -1 || lastIndex == -1 || firstIndex > lastIndex - 1) continue;
                    TableItem item = this.dataTable.getItem(this.findItemInTable(token.substring(0, equalIndex), this.dataTable));
                    item.setText(1, token.substring(firstIndex + 1, lastIndex));
                }
            }
        }
    }

    private int findItemInTable(String itemText, Table dataTable) {
        int ret = -1;
        TableItem[] items = dataTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText(0).equals(itemText)) {
                return i;
            }
            ++i;
        }
        return ret;
    }

    public void initTable(String sAttributes) {
        this.dataTable.removeAll();
        if (sAttributes != null && !sAttributes.equals("")) {
            StringTokenizer t = new StringTokenizer(sAttributes, ";");
            while (t.hasMoreTokens()) {
                String token = t.nextToken();
                int equalIndex = token.indexOf(61);
                int firstIndex = token.indexOf(34);
                int lastIndex = token.lastIndexOf(34);
                if (equalIndex == -1 || firstIndex == -1 || lastIndex == -1 || firstIndex > lastIndex - 1) continue;
                TableItem item = new TableItem(this.dataTable, 0);
                item.setText(0, token.substring(0, equalIndex));
                item.setText(1, token.substring(firstIndex + 1, lastIndex));
            }
        }
    }
}

