/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import java.util.Arrays;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectTimezoneDialog
extends Dialog {
    private final int VERTICAL_MARGIN = 7;
    private final int VERTICAL_SPACING = 4;
    private final int HORIZONTAL_MARGIN = 7;
    private final int HORIZONTAL_SPACING = 4;
    private String m_sTimezone;
    private Text timezoneText;
    private List timezoneList;

    public SelectTimezoneDialog(Shell parentShell, String sTimezone) {
        super(parentShell);
        this.m_sTimezone = sTimezone;
    }

    private Composite createBaseComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        int numBaseCols = 2;
        Composite composite = this.createBaseComposite(parent, numBaseCols, false);
        Label lbl = new Label(composite, 0);
        lbl.setText(Messages.Select_Timezone_Available_2);
        lbl.setLayoutData((Object)new GridData(2));
        this.timezoneList = new List(composite, 2564);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertVerticalDLUsToPixels(240);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(160);
        this.timezoneList.setLayoutData((Object)gridData);
        Object[] availableTimezones = TimeZone.getAvailableIDs();
        Arrays.sort(availableTimezones);
        this.timezoneList.setItems((String[])availableTimezones);
        this.timezoneList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                SelectTimezoneDialog.this.m_sTimezone = SelectTimezoneDialog.this.timezoneList.getSelection()[0];
                SelectTimezoneDialog.this.timezoneText.setText(SelectTimezoneDialog.this.m_sTimezone);
                SelectTimezoneDialog.this.okPressed();
            }

            public void mouseDown(MouseEvent e) {
                SelectTimezoneDialog.this.m_sTimezone = SelectTimezoneDialog.this.timezoneList.getSelection()[0];
                SelectTimezoneDialog.this.timezoneText.setText(SelectTimezoneDialog.this.m_sTimezone);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = numBaseCols - 1;
        Label label = new Label(composite, 0);
        label.setText(Messages.Select_Timezone_Timezone_3);
        this.timezoneText = new Text(composite, 2048);
        this.timezoneText.setLayoutData((Object)gridData);
        this.timezoneText.setText(this.m_sTimezone);
        String[] strs = new String[]{this.m_sTimezone};
        this.timezoneList.setSelection(strs);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.Select_Timezone_Title_1);
    }

    protected void okPressed() {
        this.m_sTimezone = this.timezoneText.getText();
        super.okPressed();
    }

    public String getTimezone() {
        return this.m_sTimezone;
    }
}

