/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.dialogs.IPatternSampleArea;
import com.ibm.icu.text.SimpleDateFormat;
import java.text.Bidi;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PatternSampleAreaDateTimeWidget
implements IPatternSampleArea {
    private String pattern;
    private Label sample;
    private boolean dateOnly;

    public PatternSampleAreaDateTimeWidget(boolean dateOnly) {
        this.dateOnly = dateOnly;
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.modifyLabels();
    }

    @Override
    public Composite createArea(Composite parent) {
        Group sampleGroup = new Group(parent, 4);
        sampleGroup.setText(Messages._UI_PatternSampleAreaDateTimeWidget_0);
        GridLayout sampleLayout = new GridLayout(1, false);
        sampleGroup.setLayout((Layout)sampleLayout);
        sampleGroup.setLayoutData((Object)new GridData(1808));
        String test = this.formatSample("yyyy");
        int style = Bidi.requiresBidi(test.toCharArray(), 0, test.length()) ? 0x4000000 : 0;
        this.sample = new Label((Composite)sampleGroup, style);
        this.sample.setLayoutData((Object)new GridData(768));
        return sampleGroup;
    }

    private void modifyLabels() {
        if (this.pattern == null) {
            if (this.sample != null && !this.sample.isDisposed()) {
                this.sample.setText("");
            }
            return;
        }
        if (this.sample != null) {
            try {
                String formattedSample = this.formatSampleRow(this.pattern, false);
                if (Bidi.requiresBidi(formattedSample.toCharArray(), 0, formattedSample.length())) {
                    formattedSample = String.valueOf('\u200e') + formattedSample.replaceAll("/", "\u200e/") + '\u200e';
                }
                this.sample.setText(formattedSample);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.sample.setText("");
            }
        }
    }

    @Override
    public String formatSample(String pattern) throws IllegalArgumentException {
        return this.formatSampleRow(pattern, true);
    }

    public String formatSampleRow(String pattern, boolean validateDate) throws IllegalArgumentException {
        if (validateDate) {
            // empty if block
        }
        Date sampleDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(sampleDate);
    }
}

