/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.JsfAccessibleAdapter;
import com.ibm.etools.jsf.support.dialogs.IPatternArea;
import com.ibm.etools.jsf.support.dialogs.PatternBuilderDialog;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class PatternAreaPercentageWidget
implements IPatternArea {
    private final PatternBuilderDialog dlg;
    protected Composite number = null;
    private Spinner decimalPlaces = null;
    private final String areaName;

    public PatternAreaPercentageWidget(PatternBuilderDialog dlg, String name) {
        this.dlg = dlg;
        this.areaName = name;
    }

    @Override
    public String getAreaName() {
        return this.areaName;
    }

    @Override
    public Composite createArea(Composite parent) {
        if (this.number != null || parent == null) {
            return this.number;
        }
        this.number = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        this.number.setLayout((Layout)gl);
        this.number.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAreaFields(this.number);
        return this.number;
    }

    @Override
    public Control getControl() {
        return this.number;
    }

    protected void createAreaFields(Composite number) {
        Label label = new Label(number, 0);
        label.setText(Messages._UI_PatternAreaPercentageWidget_0);
        label.setLayoutData((Object)new GridData(768));
        this.decimalPlaces = new Spinner(number, 2048);
        this.decimalPlaces.setLayoutData((Object)new GridData(768));
        this.decimalPlaces.setMinimum(0);
        this.decimalPlaces.setSelection(2);
        this.decimalPlaces.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PatternAreaPercentageWidget.this.updatePattern();
            }
        });
        this.decimalPlaces.getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(Messages._UI_PatternAreaPercentageWidget_0));
    }

    protected PatternBuilderDialog getParentDialog() {
        return this.dlg;
    }

    @Override
    public void updatePattern() {
        StringBuffer pattern = new StringBuffer("0");
        int decPlace = this.getDecimalPlace();
        if (decPlace > 0) {
            pattern.append(".");
            while (decPlace > 0) {
                pattern.append("0");
                --decPlace;
            }
        }
        pattern.append("%");
        this.getParentDialog().setPatternVal(pattern.toString());
    }

    protected int getDecimalPlace() {
        return this.decimalPlaces.getSelection();
    }

    protected GridData createHSpan(int span) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        return gd;
    }
}

