/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.dialogs.PatternAreaPercentageWidget;
import com.ibm.etools.jsf.support.dialogs.PatternBuilderDialog;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

public class PatternAreaNumberWidget
extends PatternAreaPercentageWidget {
    private List negNumbers = null;
    private Button thousandsSep = null;

    public PatternAreaNumberWidget(PatternBuilderDialog dlg, String name) {
        super(dlg, name);
    }

    @Override
    protected void createAreaFields(Composite number) {
        super.createAreaFields(number);
        this.thousandsSep = new Button(number, 32);
        this.thousandsSep.setText(Messages._UI_PatternAreaNumberWidget_0);
        this.thousandsSep.setLayoutData((Object)this.createHSpan(2));
        this.thousandsSep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PatternAreaNumberWidget.this.updatePattern();
            }
        });
        Label l = new Label(number, 0);
        l.setText(Messages._UI_PatternAreaNumberWidget_1);
        l.setLayoutData((Object)this.createHSpan(2));
        this.negNumbers = new List(number, 2052);
        this.negNumbers.setLayoutData((Object)this.createHSpan(2));
        this.negNumbers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PatternAreaNumberWidget.this.updatePattern();
            }
        });
        this.updatePattern();
    }

    @Override
    public void updatePattern() {
        this.getParentDialog().setPatternVal(this.generatePattern(this.negNumbers.getSelectionIndex()));
        NumberFormat format = DecimalFormat.getNumberInstance();
        double negNumSample = -1234.56;
        int selection = this.negNumbers.getSelectionIndex();
        this.negNumbers.removeAll();
        int i = 0;
        while (i < 2) {
            ((DecimalFormat)format).applyPattern(this.generatePattern(i));
            this.negNumbers.add(format.format(negNumSample));
            ++i;
        }
        if (selection >= 0) {
            this.negNumbers.setSelection(selection);
        }
    }

    private String generatePattern(int negNumberIndex) {
        StringBuffer pattern = new StringBuffer(this.thousandsSep.getSelection() ? "#,##0" : "0");
        int decPlace = this.getDecimalPlace();
        if (decPlace > 0) {
            pattern.append(".");
            while (decPlace > 0) {
                pattern.append("0");
                --decPlace;
            }
        }
        if (negNumberIndex > 0) {
            String basePattern = pattern.toString();
            pattern.append(";");
            pattern.append("(");
            pattern.append(basePattern);
            pattern.append(")");
        }
        return pattern.toString();
    }

    public void addMouseListener(MouseListener listener) {
        this.negNumbers.addMouseListener(listener);
    }
}

