/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.dialogs.PatternAreaPercentageWidget;
import com.ibm.etools.jsf.support.dialogs.PatternBuilderDialog;
import java.text.Bidi;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class PatternAreaAccountingWidget
extends PatternAreaPercentageWidget {
    private Combo symbol;
    private List rawSymbols = new ArrayList();

    public PatternAreaAccountingWidget(PatternBuilderDialog dlg, String name) {
        super(dlg, name);
    }

    @Override
    protected void createAreaFields(Composite number) {
        String zero;
        String currency;
        Object format;
        super.createAreaFields(number);
        Label label = new Label(number, 0);
        label.setText(Messages._UI_PatternAreaAccountingWidget_0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.symbol = new Combo(number, 2052);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.symbol.setLayoutData((Object)data);
        this.symbol.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PatternAreaAccountingWidget.this.updatePattern();
            }
        });
        ArrayList symbols = new ArrayList();
        HashMap localesMap = new HashMap();
        Locale[] locales = com.ibm.icu.text.DecimalFormat.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            format = (com.ibm.icu.text.DecimalFormat)com.ibm.icu.text.DecimalFormat.getCurrencyInstance((Locale)locales[i]);
            currency = format.format(0L);
            format.applyPattern("#");
            zero = format.format(0L);
            this.addCurrency(currency, zero, symbols, localesMap, locales[i]);
            ++i;
        }
        locales = DecimalFormat.getAvailableLocales();
        i = 0;
        while (i < locales.length) {
            format = (DecimalFormat)DecimalFormat.getCurrencyInstance(locales[i]);
            currency = ((NumberFormat)format).format(0L);
            ((DecimalFormat)format).applyPattern("#");
            zero = ((NumberFormat)format).format(0L);
            this.addCurrency(currency, zero, symbols, localesMap, locales[i]);
            ++i;
        }
        Iterator it = symbols.iterator();
        Collections.sort(symbols, new Comparator(){

            public int compare(Object o1, Object o2) {
                String src = o1.toString().trim();
                String dst = o2.toString().trim();
                return src.compareTo(dst);
            }
        });
        while (it.hasNext()) {
            String currency2;
            String rawCurrency = currency2 = it.next().toString();
            boolean top = (currency2 = currency2.substring(0, currency2.length() - 1)).equals("$");
            if (top) {
                this.rawSymbols.add(0, rawCurrency);
            } else {
                this.rawSymbols.add(rawCurrency);
            }
            StringBuffer buf = new StringBuffer(currency2.trim());
            buf.append(" (");
            List localeNames = (List)localesMap.get(rawCurrency);
            Collections.sort(localeNames);
            Iterator lit = localeNames.iterator();
            while (lit.hasNext()) {
                buf.append(lit.next());
                if (!lit.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(")");
            String dir = "";
            if ("win32".equals(SWT.getPlatform())) {
                String string = dir = (this.symbol.getStyle() & 0x8000000) != 0 ? "\u200e" : "\u200f";
            }
            if (top) {
                this.symbol.add(String.valueOf(dir) + buf.toString() + dir, 0);
                continue;
            }
            this.symbol.add(String.valueOf(dir) + buf.toString() + dir);
        }
        this.symbol.setVisibleItemCount(this.symbol.getItemCount() / 5);
    }

    private void addCurrency(String currency, String zero, List symbols, Map localesMap, Locale locale) {
        List countries;
        if (currency.indexOf("\ufffd") >= 0) {
            return;
        }
        if (!"win32".equals(SWT.getPlatform())) {
            if ("IN".equals(locale.getCountry())) {
                return;
            }
            if (Bidi.requiresBidi(currency.toCharArray(), 0, currency.length())) {
                return;
            }
        }
        boolean left = true;
        if (currency.startsWith(zero)) {
            currency = currency.substring(currency.lastIndexOf(zero) + zero.length());
            left = false;
        }
        if (currency.endsWith(zero)) {
            currency = currency.substring(0, currency.indexOf(zero));
        }
        if (!symbols.contains(currency = String.valueOf(currency) + (left ? (char)'L' : 'R'))) {
            String currencyPreSpace = " " + currency;
            String currencyPostSpace = String.valueOf(currency.substring(0, currency.length() - 1)) + " " + (left ? (char)'L' : 'R');
            String currencyTrimmed = String.valueOf(currency.substring(0, currency.length() - 1).trim()) + (left ? (char)'L' : 'R');
            if (symbols.contains(currencyPreSpace)) {
                currency = currencyPreSpace;
            } else if (symbols.contains(currencyPostSpace)) {
                currency = currencyPostSpace;
            } else if (symbols.contains(currencyTrimmed)) {
                currency = currencyTrimmed;
            } else {
                symbols.add(currency);
            }
        }
        if (localesMap.get(currency) == null) {
            localesMap.put(currency, new ArrayList());
        }
        if (!(countries = (List)localesMap.get(currency)).contains(locale.getDisplayCountry())) {
            countries.add(locale.getDisplayCountry());
        }
    }

    @Override
    public void updatePattern() {
        StringBuffer pattern = new StringBuffer();
        pattern.append("#,##0");
        int decPlace = this.getDecimalPlace();
        if (decPlace > 0) {
            pattern.append(".");
            while (decPlace > 0) {
                pattern.append("0");
                --decPlace;
            }
        }
        if (this.getSymbol() != null && this.getSymbol().length() > 0) {
            String symbol = "'" + this.getSymbol() + "'";
            if (this.isSymbolLeft()) {
                pattern.insert(0, symbol);
            } else {
                pattern.append(symbol);
            }
        }
        this.getParentDialog().setPatternVal(pattern.toString());
    }

    protected String getSymbol() {
        if (this.symbol.getSelectionIndex() >= 0) {
            String currency = this.rawSymbols.get(this.symbol.getSelectionIndex()).toString();
            return currency.substring(0, currency.length() - 1);
        }
        String text = this.symbol.getText();
        if ("win32".equals(SWT.getPlatform())) {
            return text != null && text.length() > 2 ? text.substring(1, text.length() - 1) : text;
        }
        return text;
    }

    protected boolean isSymbolLeft() {
        if (this.symbol.getSelectionIndex() >= 0) {
            String currency = this.rawSymbols.get(this.symbol.getSelectionIndex()).toString();
            return currency.charAt(currency.length() - 1) == 'L';
        }
        return true;
    }
}

