/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.MaskConverterProperties;
import com.ibm.etools.jsf.support.PatternBeanManager;
import com.ibm.etools.jsf.support.dialogs.DialogUtil;
import com.ibm.etools.jsf.support.dialogs.IPatternBuilderConstants;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ConfigureCustomConverterDialog
extends TrayDialog {
    private String titleText = Messages.ConfigureCustomConverterDialog_Configure_Mask_Converter_2;
    private MaskConverterProperties converter = null;
    Table customRegExesTable = null;
    TableColumn customRegExSymbolsColumn = null;
    TableColumn customRegExPatternsColumn = null;
    String[] maskConverterNames = new String[]{Messages.ConfigureCustomConverterDialog_Configure_charRegEx1_Marker_3, Messages.ConfigureCustomConverterDialog_Configure_charRegEx2_Marker_4, Messages.ConfigureCustomConverterDialog_Configure_charRegEx3_Marker_5, Messages.ConfigureCustomConverterDialog_Configure_charRegEx4_Marker_6};
    String[] maskConverterValues = new String[]{"[0-9]", "[a-zA-Z]", "", ""};
    Combo customPattern = null;
    Text converterNameText;
    TableEditor editor;
    Text descriptionText;
    Button okButton;
    private boolean isNameEditable = true;
    Listener tableEditListener = new Listener(){

        public void handleEvent(Event event) {
            Point pt = new Point(event.x, event.y);
            final TableItem item = ConfigureCustomConverterDialog.this.customRegExesTable.getItem(pt);
            if (item == null) {
                return;
            }
            final Text text = new Text((Composite)ConfigureCustomConverterDialog.this.customRegExesTable, 0);
            Listener textListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 16: {
                            item.setText(1, text.getText());
                            text.dispose();
                            break;
                        }
                        case 31: {
                            switch (e.detail) {
                                case 4: {
                                    item.setText(1, text.getText());
                                    ConfigureCustomConverterDialog.this.updateOkButton();
                                }
                                case 2: {
                                    text.dispose();
                                    e.doit = false;
                                }
                            }
                        }
                    }
                }
            };
            text.addListener(16, textListener);
            text.addListener(31, textListener);
            ConfigureCustomConverterDialog.this.editor.setEditor((Control)text, item, 1);
            text.setText(item.getText(1));
            text.selectAll();
            text.setFocus();
        }
    };

    public ConfigureCustomConverterDialog(Shell parent) {
        super(parent);
    }

    public ConfigureCustomConverterDialog(Shell parent, boolean isNameEditable) {
        super(parent);
        this.isNameEditable = isNameEditable;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.titleText != null) {
            newShell.setText(this.titleText);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite thisDialog = (Composite)super.createDialogArea(parent);
        thisDialog.setLayout(this.createLayout(2, 5, 7, 3, 7));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.minimumWidth = DialogUtil.getTextLenInPix(parent, this.titleText) + 100;
        thisDialog.setLayoutData((Object)gridData);
        CLabel converterNameLabel = new CLabel(thisDialog, 0);
        converterNameLabel.setText(Messages.ConfigureCustomConverterDialog_Configure_Converter_Name_Label_8);
        this.converterNameText = new Text(thisDialog, this.isNameEditable ? 2048 : 2056);
        GridData converterNameTextGridData = new GridData(272);
        converterNameTextGridData.horizontalSpan = 3;
        converterNameTextGridData.grabExcessVerticalSpace = true;
        this.converterNameText.setLayoutData((Object)converterNameTextGridData);
        converterNameTextGridData.widthHint = 220;
        this.converterNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureCustomConverterDialog.this.updateOkButton();
            }
        });
        CLabel descriptionLabel = new CLabel(thisDialog, 0);
        descriptionLabel.setText(Messages.ConfigureCustomConverterDialog_Configure_Description_Label_7);
        GridData descriptionLabelGridData = new GridData(1808);
        descriptionLabelGridData.horizontalSpan = 3;
        descriptionLabelGridData.grabExcessVerticalSpace = true;
        descriptionLabel.setLayoutData((Object)descriptionLabelGridData);
        descriptionLabelGridData.verticalIndent = 4;
        this.descriptionText = new Text(thisDialog, 2882);
        GridData descriptionTextGridData = new GridData(272);
        descriptionTextGridData.horizontalSpan = 3;
        descriptionTextGridData.grabExcessVerticalSpace = true;
        this.descriptionText.setLayoutData((Object)descriptionTextGridData);
        descriptionTextGridData.heightHint = 50;
        descriptionTextGridData.widthHint = 220;
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureCustomConverterDialog.this.updateOkButton();
            }
        });
        CLabel patternsLabel = new CLabel(thisDialog, 0);
        patternsLabel.setText(Messages.ConfigureCustomConverterDialog_Configure_Pattern_Label_9);
        GridData patternsTextGridData = new GridData(1808);
        patternsTextGridData.horizontalSpan = 3;
        patternsTextGridData.grabExcessVerticalSpace = true;
        patternsLabel.setLayoutData((Object)patternsTextGridData);
        patternsTextGridData.widthHint = 220;
        patternsTextGridData.verticalIndent = 4;
        String[] defaultMaskPatterns = IPatternBuilderConstants.MASK_DEFAULT_PATTERNS;
        this.customPattern = new Combo(thisDialog, 2052);
        this.customPattern.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < defaultMaskPatterns.length) {
            this.customPattern.add(defaultMaskPatterns[i]);
            ++i;
        }
        this.customPattern.setVisibleItemCount(Math.max(defaultMaskPatterns.length / 2, 4));
        this.customPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureCustomConverterDialog.this.updateOkButton();
            }
        });
        CLabel regExLabel = new CLabel(thisDialog, 64);
        regExLabel.setText(Messages.ConfigureCustomConverterDialog_Configure_RegEx_Label_10);
        GridData regExTextGridData = new GridData(1808);
        regExTextGridData.horizontalSpan = 3;
        regExTextGridData.grabExcessVerticalSpace = true;
        regExLabel.setLayoutData((Object)regExTextGridData);
        patternsTextGridData.widthHint = 220;
        regExTextGridData.verticalIndent = 4;
        this.customRegExesTable = new Table(thisDialog, 1116162);
        this.customRegExesTable.setLinesVisible(true);
        GridData tableGridDataRegEx = new GridData(770);
        this.customRegExesTable.setHeaderVisible(true);
        this.customRegExesTable.setLinesVisible(true);
        this.customRegExesTable.setLayoutData((Object)tableGridDataRegEx);
        this.customRegExSymbolsColumn = new TableColumn(this.customRegExesTable, 0x800000);
        this.customRegExSymbolsColumn.setText(Messages.ConfigureCustomConverterDialog_Configure_Name_Column_Label_10);
        this.customRegExSymbolsColumn.setWidth(120);
        this.customRegExPatternsColumn = new TableColumn(this.customRegExesTable, 0x800000);
        this.customRegExPatternsColumn.setText(Messages.ConfigureCustomConverterDialog_Configure_Value_Column_Label_11);
        this.customRegExPatternsColumn.setWidth(200);
        int i2 = 0;
        while (i2 < this.maskConverterValues.length) {
            TableItem ti = new TableItem(this.customRegExesTable, 0);
            ti.setText(new String[]{this.maskConverterNames[i2], this.maskConverterValues[i2]});
            ++i2;
        }
        tableGridDataRegEx.heightHint = 15 * this.maskConverterValues.length;
        this.editor = new TableEditor(this.customRegExesTable);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.customRegExesTable.addListener(3, this.tableEditListener);
        this.preLoadInformation();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)thisDialog, "com.ibm.etools.jsf.CustomConverterDlg");
        return thisDialog;
    }

    protected Layout createLayout(int numCols, int vBorder, int hBorder, int vSpacing, int hSpacing) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numCols;
        gridLayout.marginHeight = vBorder;
        gridLayout.marginWidth = hBorder;
        gridLayout.verticalSpacing = vSpacing;
        gridLayout.horizontalSpacing = hSpacing;
        gridLayout.makeColumnsEqualWidth = false;
        return gridLayout;
    }

    public void setTitleText(String string) {
        this.titleText = string;
    }

    protected void okPressed() {
        MaskConverterProperties properties;
        PatternBeanManager beanManager = new PatternBeanManager(JsfProjectUtil.getCurrentPageResource());
        TableItem[] items = this.customRegExesTable.getItems();
        String patternName = this.converterNameText.getText();
        String char1RegEx = items[0].getText(1);
        String char2RegEx = items[1].getText(1);
        String char3RegEx = items[2].getText(1);
        String char4RegEx = items[3].getText(1);
        this.converter = properties = new MaskConverterProperties(patternName, this.customPattern.getText(), char1RegEx, char2RegEx, char3RegEx, char4RegEx, this.descriptionText.getText());
        beanManager.saveToFacesConfig(2, properties);
        super.okPressed();
    }

    public MaskConverterProperties getConverter() {
        return this.converter;
    }

    public void setConverter(MaskConverterProperties converter) {
        this.converter = converter;
    }

    private void preLoadInformation() {
        if (this.converter == null) {
            return;
        }
        this.converterNameText.setText(this.converter.getMaskName());
        if (this.converter.getDescription() != null) {
            this.descriptionText.setText(this.converter.getDescription());
        }
        this.customPattern.setText(this.converter.getMaskPattern());
        this.customRegExesTable.removeAll();
        TableItem ti = new TableItem(this.customRegExesTable, 0);
        ti.setText(new String[]{this.maskConverterNames[0], this.converter.getChar1RegEx()});
        ti = new TableItem(this.customRegExesTable, 0);
        ti.setText(new String[]{this.maskConverterNames[1], this.converter.getChar2RegEx()});
        ti = new TableItem(this.customRegExesTable, 0);
        ti.setText(new String[]{this.maskConverterNames[2], this.converter.getChar3RegEx()});
        ti = new TableItem(this.customRegExesTable, 0);
        ti.setText(new String[]{this.maskConverterNames[3], this.converter.getChar4RegEx()});
    }

    private void updateOkButton() {
        this.okButton = super.getButton(0);
        String patternText = this.customPattern.getText();
        String converterName = this.converterNameText.getText();
        if (this.okButton != null && !patternText.equalsIgnoreCase("") && !converterName.equals("")) {
            this.okButton.setEnabled(true);
        } else if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button ret = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            ret.setEnabled(false);
        }
        return ret;
    }
}

