/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.support.dialogs.InsertDlgTableEditAction;
import com.ibm.etools.webedit.dialogs.insert.IInsertDlgTableEditActionTarget;
import com.ibm.etools.webedit.dialogs.insert.IPartContainer;
import com.ibm.etools.webedit.utils.ComboDataType;
import com.ibm.etools.webedit.utils.HTML40AttrValueMap;
import com.ibm.etools.webedit.utils.IInsertElement;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractTableEditor
implements IInsertDlgTableEditActionTarget,
ICellEditorListener {
    private static final String ATABLEEDITOR_CONTEXT_MENU_ID = "AbstractTableEditor";
    protected static final String IE_DATA = "InsertElementData";
    protected static final String IE_KEYCLASS = "KeyClassData";
    protected static final String IE_VALUECLASS = "ValueClassData";
    protected Table dataTable;
    protected Button newButton;
    protected Button deleteButton;
    protected Button upperButton = null;
    protected Button lowerButton = null;
    private boolean bUpDown = true;
    protected Iterator initialData = null;
    protected boolean multiple = false;
    protected boolean multipleSelected = false;
    protected TableItem prevCheckedItem = null;
    protected TableItem prevSelectedItem = null;
    protected CellEditor[] editors = null;
    private IPartContainer olc;
    private TableEditor tableEditor = null;
    private CellEditor cellEditor = null;
    protected Hashtable<String, InsertDlgTableEditAction> fActions = new Hashtable();
    protected boolean styleCheck = false;
    protected boolean enableDel = false;
    protected boolean enableUp = false;
    protected boolean enableDown = false;
    protected boolean enableSelected = false;
    protected boolean itemChecked = false;
    protected boolean itemSelectedChecked = false;
    protected int editorsNum = 3;
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            AbstractTableEditor.this.disableCellEditor();
        }
    };
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                AbstractTableEditor.this.applyEditorValue();
                AbstractTableEditor.this.handleTabNext(e);
            } else if (e.detail == 8) {
                AbstractTableEditor.this.applyEditorValue();
                AbstractTableEditor.this.handleTabPrevious(e);
            }
        }
    };
    int fColumnNumber;
    private TableItem fTableItem;
    protected String opEditName;
    protected String opEditValue = "";
    protected String opSetSelected = "";
    protected String opMoveUp;
    protected String opMoveDown;
    protected String opDelete;
    protected String opNew;
    protected String listTitle;
    protected SelectedType selectedData = new SelectedType();
    protected int[] columnWidths = null;
    protected String[] columnTitles = null;

    protected AbstractTableEditor(IPartContainer olc) {
        this(olc, null);
    }

    protected AbstractTableEditor(IPartContainer olc, Iterator initialData) {
        this.olc = olc;
        this.initialData = initialData;
    }

    private void activateCellEditor(TableItem item, int columnToEdit) {
        if (columnToEdit < 0 || columnToEdit >= this.editorsNum) {
            return;
        }
        this.cellEditor = this.getCellEditor(columnToEdit);
        if (this.cellEditor == null) {
            return;
        }
        this.cellEditor.setValue((Object)item.getText(columnToEdit));
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.cellEditor = null;
            return;
        }
        this.dataTable.showSelection();
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.tableEditor.horizontalAlignment = layout.horizontalAlignment;
        this.tableEditor.grabHorizontal = layout.grabHorizontal;
        this.tableEditor.minimumWidth = item.getBounds((int)columnToEdit).width;
        this.tableEditor.setEditor(control, item, columnToEdit);
        this.cellEditor.setFocus();
        this.cellEditor.addListener((ICellEditorListener)this);
        this.cellEditor.getControl().addFocusListener(this.focusListener);
        this.cellEditor.getControl().addTraverseListener(this.traverseListener);
    }

    public void applyEditorValue() {
        int columnToEdit = this.tableEditor.getColumn();
        if (columnToEdit < 0 || this.cellEditor == null) {
            return;
        }
        TableItem ti = this.tableEditor.getItem();
        if (ti != null) {
            String oldText;
            boolean modified;
            String newText = (String)this.cellEditor.getValue();
            boolean bl = modified = newText != (oldText = ti.getText(columnToEdit)) || oldText == null || !newText.equals(oldText);
            if (modified) {
                ti.setText(columnToEdit, newText);
                if (columnToEdit == 2 && !this.multipleSelected) {
                    this.avoidMultipleSelected(ti);
                }
            }
        }
        this.deactivateCellEditor();
    }

    private void avoidMultipleCheck(TableItem ti) {
        if (ti.getChecked()) {
            if (this.prevCheckedItem != null && !this.prevCheckedItem.equals(ti)) {
                this.prevCheckedItem.setChecked(false);
            }
            this.prevCheckedItem = ti;
        }
    }

    private void avoidMultipleSelected(TableItem ti) {
        if (this.isSelected(ti)) {
            if (this.prevSelectedItem != null && !this.prevSelectedItem.equals(ti)) {
                this.setSelected(this.prevSelectedItem, false);
            }
            this.prevSelectedItem = ti;
        }
    }

    public void cancelEditor() {
        this.deactivateCellEditor();
    }

    protected int convertHorizontalDLUsToPixels(int dlus) {
        return this.olc.horizontalDLUsToPixels(dlus);
    }

    protected int convertVerticalDLUsToPixels(int dlus) {
        return this.olc.verticalDLUsToPixels(dlus);
    }

    protected InsertDlgTableEditAction createAction(String key, int id) {
        InsertDlgTableEditAction action = new InsertDlgTableEditAction(key, id);
        action.setTarget(this);
        return action;
    }

    public Composite createArea(Composite parent) {
        return this.createArea(parent, true, false);
    }

    public Composite createArea(Composite parent, boolean showHeader, boolean check) {
        return this.createArea(parent, showHeader, check, true, true);
    }

    public Composite createArea(Composite parent, boolean showHeader, boolean check, boolean bHorizontal, boolean bUpDown) {
        this.styleCheck = check;
        this.bUpDown = bUpDown;
        int numColumns = bHorizontal ? 1 : 2;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(this.listTitle);
        GridData gridData = new GridData();
        gridData.horizontalSpan = numColumns;
        label.setLayoutData((Object)gridData);
        int style = 68096;
        if (check) {
            style |= 0x20;
        }
        this.dataTable = new Table(composite, style);
        this.dataTable.setHeaderVisible(showHeader);
        this.dataTable.setLinesVisible(true);
        int i = 0;
        while (i < this.columnWidths.length) {
            TableColumn tableColumn = new TableColumn(this.dataTable, 0);
            tableColumn.setWidth(this.columnWidths[i]);
            if (i < this.columnTitles.length) {
                tableColumn.setText(this.columnTitles[i]);
            }
            ++i;
        }
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels(48);
        gridData.horizontalAlignment = 4;
        this.dataTable.setLayoutData((Object)gridData);
        this.initTable();
        this.dataTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTableEditor.this.listItemSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractTableEditor.this.listDefalutSelected(e);
            }
        });
        this.dataTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                AbstractTableEditor.this.handleMouseDown(event);
            }

            public void mouseDoubleClick(MouseEvent event) {
            }
        });
        this.tableEditor = new TableEditor(this.dataTable);
        MenuManager manager = new MenuManager(ATABLEEDITOR_CONTEXT_MENU_ID, ATABLEEDITOR_CONTEXT_MENU_ID);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractTableEditor.this.internalMenuAboutToShow(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.dataTable);
        this.dataTable.setMenu(menu);
        Composite buttonsGroup = this.createButtonsGroup(composite, bHorizontal, bUpDown);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 1;
        buttonsGroup.setLayoutData((Object)gridData);
        this.enableButtons();
        return composite;
    }

    protected Composite createButtonsGroup(Composite parent, boolean bHorizontal, boolean bUpDown) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = this.olc.verticalDLUsToPixels(4);
        layout.horizontalSpacing = this.olc.horizontalDLUsToPixels(4);
        layout.numColumns = bHorizontal ? (bUpDown ? 4 : 2) : 1;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        this.newButton = new Button(composite, 8);
        this.newButton.setText(this.opNew);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.newButton.setLayoutData((Object)gridData);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTableEditor.this.newPressed();
            }
        });
        this.deleteButton = new Button(composite, 8);
        this.deleteButton.setText(this.opDelete);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.deleteButton.setLayoutData((Object)gridData);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTableEditor.this.deletePressed();
            }
        });
        if (bUpDown) {
            this.upperButton = new Button(composite, 8);
            this.upperButton.setText(this.opMoveUp);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            this.upperButton.setLayoutData((Object)gridData);
            this.upperButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTableEditor.this.upPressed();
                }
            });
            this.lowerButton = new Button(composite, 8);
            this.lowerButton.setText(this.opMoveDown);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            this.lowerButton.setLayoutData((Object)gridData);
            this.lowerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTableEditor.this.downPressed();
                }
            });
        }
        return composite;
    }

    protected Composite createSortButtonsGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = this.olc.horizontalDLUsToPixels(4);
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        this.upperButton = new Button(composite, 132);
        this.upperButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTableEditor.this.upPressed();
            }
        });
        this.lowerButton = new Button(composite, 1028);
        this.lowerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTableEditor.this.downPressed();
            }
        });
        return composite;
    }

    private void deactivateCellEditor() {
        this.tableEditor.setEditor(null, null, this.tableEditor.getColumn());
        if (this.cellEditor != null) {
            this.cellEditor.removeListener((ICellEditorListener)this);
            this.cellEditor.getControl().removeFocusListener(this.focusListener);
            this.cellEditor.getControl().removeTraverseListener(this.traverseListener);
            this.cellEditor.deactivate();
            this.cellEditor = null;
        }
    }

    protected void deletePressed() {
        this.doDelete();
    }

    private void disableCellEditor() {
        if (this.cellEditor != null) {
            this.applyEditorValue();
            this.deactivateCellEditor();
        }
    }

    public void doCheck() {
        this.disableCellEditor();
        TableItem[] items = this.dataTable.getSelection();
        if (items.length == 1) {
            items[0].setChecked(!items[0].getChecked());
            if (!this.multiple) {
                this.avoidMultipleCheck(items[0]);
            }
        }
    }

    public void doDelete() {
        this.disableCellEditor();
        int[] sels = this.dataTable.getSelectionIndices();
        int i = 0;
        while (i < sels.length) {
            if (this.dataTable.getItem(sels[i]).equals(this.prevCheckedItem)) {
                this.prevCheckedItem = null;
            }
            if (this.dataTable.getItem(sels[i]).equals(this.prevSelectedItem)) {
                this.prevSelectedItem = null;
            }
            ++i;
        }
        this.dataTable.remove(sels);
        if (this.dataTable.getItemCount() > 0) {
            if (sels[0] - 1 < 0) {
                this.dataTable.select(0);
            } else if (sels[0] - 1 >= this.dataTable.getItemCount()) {
                this.dataTable.select(this.dataTable.getItemCount() - 1);
            } else {
                this.dataTable.select(sels[0] - 1);
            }
        }
        this.enableButtons();
    }

    public void doEditName() {
        this.disableCellEditor();
        TableItem[] items = this.dataTable.getSelection();
        if (items.length == 1) {
            TableItem tableItem = items[0];
            this.fColumnNumber = 0;
            this.activateCellEditor(tableItem, 0);
        }
    }

    public void doEditValue() {
        this.disableCellEditor();
        TableItem[] items = this.dataTable.getSelection();
        if (items.length == 1) {
            TableItem tableItem = items[0];
            this.fColumnNumber = 1;
            this.activateCellEditor(tableItem, 1);
        }
    }

    public void doMoveDown() {
        this.disableCellEditor();
        int[] sels = this.dataTable.getSelectionIndices();
        if (sels.length != 1) {
            return;
        }
        if (sels[0] >= this.dataTable.getItemCount() - 1) {
            return;
        }
        this.swap(sels[0], sels[0] + 1);
        this.dataTable.setSelection(sels[0] + 1);
        this.enableButtons();
    }

    public void doMoveUp() {
        this.disableCellEditor();
        int[] sels = this.dataTable.getSelectionIndices();
        if (sels.length != 1) {
            return;
        }
        if (sels[0] < 1) {
            return;
        }
        this.swap(sels[0] - 1, sels[0]);
        this.dataTable.setSelection(sels[0] - 1);
        this.enableButtons();
    }

    public void doNew() {
        this.disableCellEditor();
        this.dataTable.deselectAll();
        TableItem ti = new TableItem(this.dataTable, 0);
        if (!this.enableSelected) {
            ti.setText(new String[]{"", ""});
        } else {
            ti.setText(new String[]{"", "", this.selectedData.getDisplayString("selected.notspecified")});
        }
        TableItem[] tis = new TableItem[]{ti};
        this.dataTable.setSelection(tis);
        this.enableButtons();
        this.fColumnNumber = 0;
        this.activateCellEditor(ti, 0);
    }

    protected void downPressed() {
        this.doMoveDown();
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
    }

    protected void enableButtons() {
        this.setCanExecute();
        this.deleteButton.setEnabled(this.enableDel);
        if (this.upperButton != null) {
            this.upperButton.setEnabled(this.enableUp);
        }
        if (this.lowerButton != null) {
            this.lowerButton.setEnabled(this.enableDown);
        }
    }

    protected CellEditor getCellEditor(int columnToEdit) {
        Object editorToEdit;
        if (this.editors == null) {
            this.editors = new CellEditor[this.editorsNum];
        }
        if ((editorToEdit = this.editors[columnToEdit]) != null) {
            return editorToEdit;
        }
        switch (columnToEdit) {
            case 0: {
                editorToEdit = new TextCellEditor((Composite)this.dataTable);
                break;
            }
            case 1: {
                editorToEdit = new TextCellEditor((Composite)this.dataTable);
                break;
            }
            case 2: {
                Object[] o = this.selectedData.getDisplayStringList().toArray();
                String[] s = new String[o.length];
                int i = 0;
                while (i < o.length) {
                    s[i] = (String)o[i];
                    ++i;
                }
                editorToEdit = new ComboBoxCellEditor((Composite)this.dataTable, s){

                    protected Object doGetValue() {
                        CCombo comboBox = (CCombo)this.getControl();
                        int index = comboBox.getSelectionIndex();
                        if (index == -1) {
                            return comboBox.getText();
                        }
                        return comboBox.getItem(index);
                    }

                    protected void doSetValue(Object value) {
                        if (value instanceof String) {
                            CCombo comboBox = (CCombo)this.getControl();
                            int index = comboBox.indexOf(value.toString());
                            String v = value.toString();
                            if (index < 0 && v.length() > 0) {
                                comboBox.setText(v);
                            } else {
                                super.doSetValue((Object)new Integer(index));
                            }
                        } else {
                            super.doSetValue(value);
                        }
                    }

                    protected Control createControl(Composite parent) {
                        CCombo comboBox = (CCombo)super.createControl(parent);
                        return comboBox;
                    }
                };
            }
        }
        this.editors[columnToEdit] = editorToEdit;
        return editorToEdit;
    }

    protected Shell getShell() {
        return this.olc.getShell();
    }

    private void handleMouseDown(MouseEvent event) {
        this.disableCellEditor();
        if (event.button != 1) {
            return;
        }
        TableItem[] items = this.dataTable.getSelection();
        if (items.length == 1) {
            TableItem tableItem = items[0];
            int columns = this.dataTable.getColumnCount();
            int i = 0;
            while (i < columns) {
                Rectangle bounds = tableItem.getBounds(i);
                if (bounds.contains(event.x, event.y)) {
                    this.fColumnNumber = i;
                    this.activateCellEditor(tableItem, i);
                    return;
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void initTable() {
        if (this.initialData != null) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            ie = (IInsertElement)this.initialData.next();
            stringLine = new String[]{ie.getAttribute("name"), ie.getAttribute("value")};
            ti = new TableItem(this.dataTable, 0);
            ti.setText(stringLine);
            ti.setData("InsertElementData", ie.getData());
lbl8:
            // 2 sources

            ** while (this.initialData.hasNext())
        }
lbl9:
        // 1 sources

    }

    protected void internalMenuAboutToShow(IMenuManager mgr) {
        this.setCanExecute();
        InsertDlgTableEditAction action = null;
        InsertDlgTableEditAction obj = this.fActions.get(this.opEditName);
        if (obj == null) {
            action = this.createAction(this.opEditName, 1);
            this.fActions.put(this.opEditName, action);
        } else {
            action = obj;
        }
        action.setEnabled(this.enableDel);
        mgr.add((IAction)action);
        obj = this.fActions.get(this.opEditValue);
        if (obj == null) {
            action = this.createAction(this.opEditValue, 2);
            this.fActions.put(this.opEditValue, action);
        } else {
            action = obj;
        }
        action.setEnabled(this.enableDel);
        mgr.add((IAction)action);
        if (this.enableSelected) {
            String menuText = this.opSetSelected;
            obj = this.fActions.get(menuText);
            if (obj == null) {
                action = this.createAction(menuText, 8);
                this.fActions.put(menuText, action);
            } else {
                action = obj;
            }
            action.setEnabled(this.enableDel);
            mgr.add((IAction)action);
        }
        if (this.bUpDown) {
            obj = this.fActions.get(this.opMoveUp);
            if (obj == null) {
                action = this.createAction(this.opMoveUp, 3);
                this.fActions.put(this.opMoveUp, action);
            } else {
                action = obj;
            }
            action.setEnabled(this.enableUp);
            mgr.add((IAction)action);
            obj = this.fActions.get(this.opMoveDown);
            if (obj == null) {
                action = this.createAction(this.opMoveDown, 4);
                this.fActions.put(this.opMoveDown, action);
            } else {
                action = obj;
            }
            action.setEnabled(this.enableDown);
            mgr.add((IAction)action);
        }
        if ((obj = this.fActions.get(this.opDelete)) == null) {
            action = this.createAction(this.opDelete, 5);
            this.fActions.put(this.opDelete, action);
        } else {
            action = obj;
        }
        action.setEnabled(this.enableDel);
        mgr.add((IAction)action);
        obj = this.fActions.get(this.opNew);
        if (obj == null) {
            action = this.createAction(this.opNew, 6);
            this.fActions.put(this.opNew, action);
        } else {
            action = obj;
        }
        mgr.add((IAction)action);
    }

    public void listDefalutSelected(SelectionEvent e) {
    }

    protected void listItemSelected(SelectionEvent e) {
        if (!this.multiple && e.item instanceof TableItem) {
            TableItem ti = (TableItem)e.item;
            this.avoidMultipleCheck(ti);
        }
        this.enableButtons();
    }

    protected void newPressed() {
        this.doNew();
    }

    protected void setCanExecute() {
        int[] sels = this.dataTable.getSelectionIndices();
        if (sels.length == 1) {
            this.enableDel = true;
            this.enableUp = sels[0] != 0;
            this.enableDown = sels[0] != this.dataTable.getItemCount() - 1;
            this.itemChecked = this.dataTable.getItem(sels[0]).getChecked();
            this.itemSelectedChecked = this.enableSelected ? this.isSelected(this.dataTable.getItem(sels[0])) : false;
        } else {
            this.enableDel = false;
            this.enableUp = false;
            this.enableDown = false;
        }
    }

    public void setMultipleCheck(boolean multiple) {
        this.multiple = multiple;
        if (!multiple) {
            boolean found1st = false;
            TableItem[] ti = this.dataTable.getItems();
            int i = 0;
            while (i < ti.length) {
                if (ti[i].getChecked()) {
                    if (found1st) {
                        ti[i].setChecked(false);
                    } else {
                        found1st = true;
                        this.prevCheckedItem = ti[i];
                    }
                }
                ++i;
            }
        } else {
            this.prevCheckedItem = null;
        }
    }

    public void setMultipleChoice(boolean multiple) {
        this.multipleSelected = multiple;
        if (!this.multipleSelected) {
            boolean found1st = false;
            TableItem[] ti = this.dataTable.getItems();
            int i = 0;
            while (i < ti.length) {
                if (this.isSelected(ti[i])) {
                    if (found1st) {
                        this.setSelected(ti[i], false);
                    } else {
                        found1st = true;
                        this.prevSelectedItem = ti[i];
                    }
                }
                ++i;
            }
        } else {
            this.prevSelectedItem = null;
        }
    }

    protected void swap(int n1, int n2) {
        TableItem ti1 = this.dataTable.getItem(n1);
        TableItem ti2 = this.dataTable.getItem(n2);
        int sel = 0;
        if (!this.multiple && this.prevSelectedItem != null) {
            if (this.prevSelectedItem.equals(ti1)) {
                sel = 1;
                this.prevSelectedItem = null;
            } else if (this.prevSelectedItem.equals(ti2)) {
                sel = 2;
                this.prevSelectedItem = null;
            }
        }
        String[] values1 = new String[this.editorsNum];
        int i = 0;
        while (i < this.editorsNum) {
            values1[i] = ti1.getText(i);
            ++i;
        }
        boolean checked1 = ti1.getChecked();
        if (!this.multiple && checked1 && this.prevCheckedItem != null && this.prevCheckedItem.equals(ti1)) {
            this.prevCheckedItem = null;
        }
        Object data1 = ti1.getData(IE_DATA);
        ti1.dispose();
        String[] values2 = new String[this.editorsNum];
        int i2 = 0;
        while (i2 < this.editorsNum) {
            values2[i2] = ti2.getText(i2);
            ++i2;
        }
        boolean checked2 = ti2.getChecked();
        if (!this.multiple && checked2 && this.prevCheckedItem != null && this.prevCheckedItem.equals(ti2)) {
            this.prevCheckedItem = null;
        }
        Object data2 = ti2.getData(IE_DATA);
        ti2.dispose();
        ti1 = new TableItem(this.dataTable, 0, n1);
        ti1.setText(values2);
        ti1.setChecked(checked2);
        if (!this.multiple && checked2) {
            this.prevCheckedItem = ti1;
        }
        if (sel == 2) {
            this.prevSelectedItem = ti1;
        }
        ti1.setData(IE_DATA, data2);
        ti2 = new TableItem(this.dataTable, 0, n2);
        ti2.setText(values1);
        ti2.setChecked(checked1);
        ti2.setData(IE_DATA, data1);
        if (!this.multiple && checked1) {
            this.prevCheckedItem = ti2;
        }
        if (sel == 1) {
            this.prevSelectedItem = ti2;
        }
    }

    protected void upPressed() {
        this.doMoveUp();
    }

    public void doEditSelected() {
        this.disableCellEditor();
        TableItem[] items = this.dataTable.getSelection();
        if (items.length == 1) {
            TableItem tableItem = items[0];
            this.fColumnNumber = 2;
            this.activateCellEditor(tableItem, 2);
        }
    }

    public void setMultipleSelected(boolean multiple) {
        this.multipleSelected = multiple;
        if (!this.multipleSelected) {
            boolean found1st = false;
            TableItem[] ti = this.dataTable.getItems();
            int i = 0;
            while (i < ti.length) {
                if (this.isSelected(ti[i])) {
                    if (found1st) {
                        this.setSelected(ti[i], false);
                    } else {
                        found1st = true;
                        this.prevSelectedItem = ti[i];
                    }
                }
                ++i;
            }
        } else {
            this.prevSelectedItem = null;
        }
    }

    private boolean isSelected(TableItem ti) {
        String str = ti.getText(2);
        return this.selectedData.isTrue(str);
    }

    private void setSelected(TableItem ti, boolean set) {
        String str = set ? "selected.specified" : "selected.notspecified";
        str = this.selectedData.getDisplayString(str);
        ti.setText(2, str);
    }

    private void handleTabNext(TraverseEvent e) {
        if (this.editors != null) {
            int start;
            int i = start = this.fColumnNumber + 1 < this.dataTable.getColumnCount() ? this.fColumnNumber + 1 : 0;
            while (i <= this.editors.length) {
                TableItem[] items;
                if (this.getCellEditor(i) != null && (items = this.dataTable.getSelection()).length == 1) {
                    this.fColumnNumber = i;
                    this.fTableItem = items[0];
                    e.doit = false;
                    break;
                }
                ++i;
            }
            if (!e.doit) {
                this.startActivationThread();
            }
        }
    }

    private void handleTabPrevious(TraverseEvent e) {
        if (this.editors != null) {
            int start;
            int i = start = this.fColumnNumber - 1 >= 0 ? this.fColumnNumber - 1 : this.dataTable.getColumnCount() - 1;
            while (i >= 0) {
                TableItem[] items;
                if (this.getCellEditor(i) != null && (items = this.dataTable.getSelection()).length == 1) {
                    this.fColumnNumber = i;
                    this.fTableItem = items[0];
                    e.doit = false;
                    break;
                }
                --i;
            }
            if (!e.doit) {
                this.startActivationThread();
            }
        }
    }

    private void startActivationThread() {
        new Thread(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTableEditor.this.activateCellEditor(AbstractTableEditor.this.fTableItem, (this).AbstractTableEditor.this.fColumnNumber);
                    }
                });
            }
        }.start();
    }

    public void doOK() {
        this.disableCellEditor();
    }

    public TableEditor getTableEditor() {
        return this.tableEditor;
    }

    public CellEditor getCellEditor() {
        return this.cellEditor;
    }

    class SelectedType
    extends ComboDataType {
        SelectedType() {
        }

        protected void initData() {
            super.initTable(2);
            this.add(HTML40AttrValueMap.getDisplayString((String)"selected.specified"), "selected.specified");
            this.add(HTML40AttrValueMap.getDisplayString((String)"selected.notspecified"), "selected.notspecified");
        }

        boolean isTrue(String displayString) {
            String v = this.getValueString(displayString);
            return v != null && v.equals("selected.specified");
        }
    }
}

