/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support;

import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.webedit.common.attrview.data.TableNodeListData;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.common.utils.StyleContainerProvider;
import com.ibm.etools.webedit.css.actions.CssHtmlActionManager;
import com.ibm.etools.webedit.css.dialogs.properties.StylePropertiesDialog;
import com.ibm.etools.webedit.css.edit.util.DocumentCssTraverser;
import com.ibm.etools.webedit.css.nls.ResourceHandler;
import com.ibm.etools.webedit.css.styleoutline.CaretRuleContentProvider;
import com.ibm.etools.webedit.editor.internal.attrview.style.StyleContentManager;
import com.ibm.etools.webedit.editor.internal.page.IPageDesigner;
import com.ibm.etools.webedit.editparts.HTMLGraphicalViewer;
import com.ibm.etools.webedit.editparts.style.DocumentStyleSheetList;
import com.ibm.etools.webedit.editparts.style.GraphicalDocumentCSS;
import com.ibm.etools.webedit.editparts.style.GraphicalStyleSheetList;
import com.ibm.etools.webedit.editparts.style.LinkStyleStore;
import com.ibm.etools.webedit.utils.DocumentUtil;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.internal.util.CSSStyleDeclarationFactory;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.css.core.internal.util.declaration.ICSS2Properties;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ElementCSSInlineStyle;

public class StyleItemUtil {
    private static String getAttributeValue(Node node, String attrName) {
        return TableNodeListData.getAttributeValue((Node)node, (String)attrName);
    }

    public static String getCSSFileName(ICSSNode node, Node ele, HTMLEditDomain domain) {
        if (node instanceof ICSSStyleRule) {
            ICSSStyleSheet sheet;
            String href = "this page";
            if ((node = node.getOwnerDocument()) instanceof ICSSStyleSheet && (sheet = (ICSSStyleSheet)node).getHref() != null) {
                NodeList nodeList;
                href = ((ICSSStyleSheet)node).getHref();
                Node linkNode = StyleItemUtil.getCSSLinkNode(sheet, domain);
                if (linkNode == null && ele instanceof IDOMNode && (nodeList = DocumentCssTraverser.getCleanedNodeList((NodeList)sheet.getOwnerNodes((Document)((IDOMNode)ele).getModel().getDocument()))) != null && nodeList.getLength() > 0) {
                    linkNode = nodeList.item(0);
                }
                if (linkNode != null) {
                    href = StyleItemUtil.getAttributeValue(linkNode, "href");
                }
            }
            return href;
        }
        if (node instanceof CSSStyleDeclaration) {
            ICSSNode parent = node.getParentNode();
            if (parent == null) {
                return "this tag";
            }
            return StyleItemUtil.getCSSFileName(parent, ele, domain);
        }
        return null;
    }

    private static Node getCSSLinkNode(ICSSStyleSheet sheet, HTMLEditDomain domain) {
        GraphicalDocumentCSS docCss;
        DocumentStyleSheetList list;
        GraphicalViewer viewer;
        if (sheet == null || domain == null) {
            return null;
        }
        if (domain.getActivePageType() == 0 && (viewer = ((IPageDesigner)domain).getDesignPage().getActiveViewer()) instanceof HTMLGraphicalViewer && (list = (docCss = ((HTMLGraphicalViewer)viewer).getDocumentCSS()).getDocumentStyleSheets()) instanceof GraphicalStyleSheetList) {
            int i = 0;
            while (i < list.getLength()) {
                if (sheet == list.item(i)) {
                    LinkStyleStore store = ((GraphicalStyleSheetList)list).getRawOwner(i);
                    return store.getElement();
                }
                ++i;
            }
        }
        return null;
    }

    public static StyleContainerProvider getStyleContainerProvider(AVEditorContextProvider provider) {
        IStructuredContentProvider contentProvider = StyleItemUtil.getStyleContentProvider(provider);
        if (contentProvider instanceof CaretRuleContentProvider) {
            return ((CaretRuleContentProvider)contentProvider).getStyleContainerProvider();
        }
        return null;
    }

    public static IStructuredContentProvider getStyleContentProvider(AVEditorContextProvider provider) {
        if (provider instanceof StyleContentManager) {
            return ((StyleContentManager)provider).getStyleContentProvider();
        }
        return null;
    }

    public static String openStylePropertiesDialog(Shell shell, DocumentUtil docUtil, NodeList nodeList, StyleContainerProvider containerProvider) {
        if (docUtil == null) {
            return null;
        }
        CSSPropertyContext context = null;
        boolean unique = true;
        CSSStyleDeclaration decl = null;
        String nodeName = null;
        int nodeLen = nodeList != null ? nodeList.getLength() : 0;
        int nodeIndex = 0;
        while (nodeIndex < nodeLen) {
            Node node = nodeList.item(nodeIndex);
            while (node != null) {
                if (node.getNodeType() == 1) break;
                node = node.getParentNode();
            }
            if (node != null) {
                decl = ((ElementCSSInlineStyle)((Object)node)).getStyle();
                if (decl instanceof ICSSStyleDeclaration) {
                    if (context == null) {
                        context = new CSSPropertyContext((ICSSStyleDeclaration)decl);
                    } else {
                        unique = false;
                        break;
                    }
                }
                if (nodeName == null) {
                    nodeName = node.getNodeName();
                } else if (!nodeName.equalsIgnoreCase(node.getNodeName())) {
                    nodeName = "";
                }
            }
            ++nodeIndex;
        }
        if (!unique || context == null) {
            context = new CSSPropertyContext();
        }
        HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
        CssHtmlActionManager m = new CssHtmlActionManager(containerProvider, actionTarget);
        m.setModel((IStructuredModel)docUtil.getModel());
        IPath containerPath = m.getBasePath();
        StylePropertiesDialog dialog = new StylePropertiesDialog(shell, (ICSS2Properties)context, containerPath);
        if (unique && nodeName != null && nodeName.length() > 0) {
            dialog.setSubTitle(MessageFormat.format(ResourceHandler.Selector_StyleAttributeFor, nodeName));
        } else {
            dialog.setSubTitle(ResourceHandler.Selector_StyleAttribute);
        }
        if (dialog.open() == 0) {
            CSSPropertyContext properties = (CSSPropertyContext)dialog.getPropertiesContext();
            ICSSStyleDeclaration newDecl = CSSStyleDeclarationFactory.getInstance().createStyleDeclaration();
            properties.applyFull(newDecl);
            String cssText = newDecl.getCssText();
            return cssText != null ? cssText : "";
        }
        return null;
    }
}

