/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support;

import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigSchemeUtil;
import com.ibm.etools.jsf.facesconfig.util.JSFFacesConfigUtil;
import com.ibm.etools.jsf.support.MaskConverterProperties;
import com.ibm.etools.jsf.support.dialogs.IPatternBuilderConstants;
import com.ibm.etools.jsf.util.IFacesConfigResourceCollection;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfFacesConfigUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.pagedatamodel.wizards.Util;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.KeyType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedPropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntryType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class PatternBeanManager
implements IPatternBuilderConstants {
    private final IResource resource;
    private boolean loaded;
    private boolean customConvertersLoaded = false;
    public static final int CUSTOM_STRING_CONVERTER = 0;
    public static final int CUSTOM_NUMBER_CONVERTER = 1;
    public static final int CUSTOM_DATETIME_CONVERTER = 2;
    public static final int CUSTOM_MASK_CONVERTER = 3;
    private HashMap<String, String[]> numberPatterns = new HashMap();
    private HashMap<String, String[]> dateTimePatterns = new HashMap();
    private HashMap<String, String[]> dateOnlyPatterns = new HashMap();
    private HashMap<String, String[]> maskPatterns = new HashMap();
    private HashMap editableCustomConverters;
    private static HashMap<String, String> customConvertersClassesMap = new HashMap();
    private static char[] TIME_PTRN_CHARS = new char[]{'a', 'A', 'h', 'H', 'k', 'K', 'm', 's', 'S', 'z', 'Z', 'v'};

    public PatternBeanManager(IResource resource) {
        this.resource = resource;
    }

    public Map<String, String[]> getDateTimePatterns() {
        if (!this.loaded) {
            this.loadFacesConfig();
        }
        return this.dateTimePatterns;
    }

    public Map<String, String[]> getDateOnlyPatterns() {
        if (!this.loaded) {
            this.loadFacesConfig();
        }
        return this.dateOnlyPatterns;
    }

    public Map<String, String[]> getMaskPatterns() {
        if (!this.loaded) {
            this.loadFacesConfig();
        }
        return this.maskPatterns;
    }

    public Map<String, String[]> getNumberPatterns() {
        if (!this.loaded) {
            this.loadFacesConfig();
        }
        return this.numberPatterns;
    }

    public HashMap getEditableCustomConverters() {
        if (!this.customConvertersLoaded) {
            this.loadCustomConverters();
        }
        return this.editableCustomConverters;
    }

    private void loadCustomConverters() {
        if (this.resource == null) {
            return;
        }
        this.customConvertersLoaded = true;
        HashMap<String, MaskConverterProperties> tempMap = new HashMap<String, MaskConverterProperties>();
        IProject project = this.resource.getProject();
        String otherFacesXmlPath = FacesConfigSchemeUtil.getFacesConfigPathByScheme((String)"other", (IResource)this.resource);
        FacesConfigArtifactEdit edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)otherFacesXmlPath);
        IJavaProject javaProj = JavaCore.create((IProject)project);
        try {
            try {
                if (edit.getFacesConfig() != null) {
                    EList converters = edit.getFacesConfig().getConverter();
                    int i = 0;
                    while (i < converters.size()) {
                        ConverterType conv;
                        String classString;
                        IType type;
                        MaskConverterProperties prop = null;
                        if (converters.get(i) != null && (type = javaProj.findType(classString = (conv = (ConverterType)converters.get(i)).getConverterClass() != null ? conv.getConverterClass().getTextContent() : null)) != null && !(type instanceof BinaryType)) {
                            ICompilationUnit cu = type.getCompilationUnit();
                            IType[] types = cu.getAllTypes();
                            IField[] fields = types[0].getFields();
                            HashMap<String, String> map = new HashMap<String, String>();
                            int j = 0;
                            while (j < fields.length) {
                                if (fields[j].exists()) {
                                    String key = fields[j].getElementName();
                                    String value = (String)fields[j].getConstant();
                                    map.put(key, value);
                                }
                                ++j;
                            }
                            prop = new MaskConverterProperties(map);
                            prop.setMaskName(conv.getConverterId() != null ? conv.getConverterId().getTextContent() : null);
                            if (conv.getDescription() != null && conv.getDescription().size() > 0) {
                                prop.setDescription((DescriptionType)conv.getDescription().get(0) != null ? ((DescriptionType)conv.getDescription().get(0)).getTextContent() : null);
                            }
                            if (conv.getConverterId() != null) {
                                tempMap.put(conv.getConverterId().getTextContent(), prop);
                            }
                        }
                        ++i;
                    }
                    this.editableCustomConverters = tempMap;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private void loadFacesConfig() {
        if (this.resource == null) {
            return;
        }
        this.loaded = true;
        IFacesConfigResourceCollection collection = JsfFacesConfigUtil.getResourceCollection((IProject)this.resource.getProject());
        if (collection == null) {
            return;
        }
        FacesConfigType[] staticConfigs = collection.getModels(3);
        FacesConfigArtifactEdit edit = null;
        try {
            FacesConfigType[] allConfigs;
            edit = FacesConfigSchemeUtil.getFacesConfigArtifactEditManagedBeanForRead((IResource)this.resource);
            if (edit != null) {
                allConfigs = new FacesConfigType[staticConfigs.length + 1];
                System.arraycopy(staticConfigs, 0, allConfigs, 0, staticConfigs.length);
                allConfigs[staticConfigs.length] = edit.getFacesConfig();
            } else {
                allConfigs = staticConfigs;
            }
            int config_index = 0;
            while (config_index < allConfigs.length) {
                if (allConfigs[config_index] != null) {
                    EList beans = allConfigs[config_index].getManagedBean();
                    int i = 0;
                    while (i < beans.size()) {
                        String sName;
                        ManagedBeanType managedBean = (ManagedBeanType)beans.get(i);
                        String string = sName = managedBean.getManagedBeanName() != null ? managedBean.getManagedBeanName().getTextContent() : null;
                        if (sName != null && !sName.equals("") && sName.endsWith("_converter_patterns")) {
                            EList properties = managedBean.getManagedProperty();
                            int j = 0;
                            while (j < properties.size()) {
                                String value;
                                String key;
                                MapEntryType mapEntry;
                                int z;
                                EList entries;
                                MapEntriesType map;
                                String name;
                                ManagedPropertyType property = (ManagedPropertyType)properties.get(j);
                                String string2 = name = property.getPropertyName() != null ? property.getPropertyName().getTextContent() : null;
                                if ("numberPatterns".equals(name)) {
                                    map = property.getMapEntries();
                                    entries = map.getMapEntry();
                                    z = 0;
                                    while (z < entries.size()) {
                                        mapEntry = (MapEntryType)entries.get(z);
                                        key = mapEntry.getKey() != null ? mapEntry.getKey().getTextContent() : null;
                                        String string3 = value = mapEntry.getValue() != null ? mapEntry.getValue().getTextContent() : null;
                                        if (key != null && key.length() > 0 && value != null) {
                                            this.numberPatterns.put(key, new String[]{value, sName});
                                        }
                                        ++z;
                                    }
                                } else if ("dateTimePatterns".equals(name)) {
                                    map = property.getMapEntries();
                                    entries = map.getMapEntry();
                                    z = 0;
                                    while (z < entries.size()) {
                                        mapEntry = (MapEntryType)entries.get(z);
                                        key = mapEntry.getKey() != null ? mapEntry.getKey().getTextContent() : null;
                                        String string4 = value = mapEntry.getValue() != null ? mapEntry.getValue().getTextContent() : null;
                                        if (key != null && key.length() > 0 && value != null) {
                                            this.dateTimePatterns.put(key, new String[]{value, sName});
                                            if (PatternBeanManager.findTimePatternChar(value) == null) {
                                                this.dateOnlyPatterns.put(key, new String[]{value, sName});
                                            }
                                        }
                                        ++z;
                                    }
                                } else if ("maskPatterns".equals(name)) {
                                    map = property.getMapEntries();
                                    entries = map.getMapEntry();
                                    z = 0;
                                    while (z < entries.size()) {
                                        mapEntry = (MapEntryType)entries.get(z);
                                        key = mapEntry.getKey() != null ? mapEntry.getKey().getTextContent() : null;
                                        String string5 = value = mapEntry.getValue() != null ? mapEntry.getValue().getTextContent() : null;
                                        if (key != null && key.length() > 0 && value != null) {
                                            this.maskPatterns.put(key, new String[]{value, sName});
                                        }
                                        ++z;
                                    }
                                }
                                ++j;
                            }
                            break;
                        }
                        ++i;
                    }
                }
                ++config_index;
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void saveToFacesConfig(int callerType, MaskConverterProperties prop) {
        block16: {
            if (this.resource == null) {
                return;
            }
            IProject project = this.resource.getProject();
            final MaskConverterProperties properties = prop;
            String maskName = properties.getMaskName();
            String fileName = PatternBeanManager.createConverterFileName(maskName);
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            String otherFacesXmlPath = FacesConfigSchemeUtil.getFacesConfigPathByScheme((String)"other", (IResource)this.resource);
            FacesConfigArtifactEdit edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)otherFacesXmlPath);
            try {
                try {
                    if (edit.getFacesConfig() != null) {
                        EList converters = edit.getFacesConfig().getConverter();
                        boolean alreadyThere = false;
                        int i = 0;
                        while (i < converters.size()) {
                            ConverterType conv;
                            if (converters.get(i) != null && (conv = (ConverterType)converters.get(i)).getConverterId() != null && conv.getConverterId().getTextContent().compareTo(properties.getMaskName()) == 0) {
                                DescriptionType desc = facesConfigFactory.createDescriptionType();
                                desc.setTextContent(prop.getDescription());
                                conv.getDescription().clear();
                                conv.getDescription().add((Object)desc);
                                alreadyThere = true;
                            }
                            ++i;
                        }
                        if (!alreadyThere) {
                            ConverterType converter = facesConfigFactory.createConverterType();
                            DescriptionType desc = facesConfigFactory.createDescriptionType();
                            desc.setTextContent(prop.getDescription());
                            converter.getDescription().clear();
                            converter.getDescription().add((Object)desc);
                            ConverterClassType clazz = facesConfigFactory.createConverterClassType();
                            clazz.setTextContent("pagecode." + fileName);
                            converter.setConverterClass(clazz);
                            ConverterIdType id = facesConfigFactory.createConverterIdType();
                            id.setTextContent(properties.getMaskName());
                            converter.setConverterId(id);
                            converters.add((Object)converter);
                        }
                        final FacesConfigArtifactEdit finalEdit = edit;
                        final IProject proj = project;
                        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) {
                                PatternBeanManager.createConverterType(proj, "pagecode", properties, monitor);
                                finalEdit.save(monitor);
                            }
                        };
                        try {
                            op.run((IProgressMonitor)new NullProgressMonitor());
                            Util.ensureBuildComplete((IProject)project, (boolean)true);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (edit != null) {
                        edit.dispose();
                        edit = null;
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (edit != null) {
                    edit.dispose();
                    edit = null;
                }
                throw throwable;
            }
            if (edit != null) {
                edit.dispose();
                edit = null;
            }
        }
        this.loadCustomConverters();
    }

    public void saveToFacesConfig(int callerType, String patternName, String patternValue) {
        block21: {
            if (patternName == null || this.resource == null) {
                return;
            }
            FacesConfigArtifactEdit edit = null;
            try {
                edit = FacesConfigSchemeUtil.getFacesConfigArtifactEditManagedBeanForWrite((IResource)this.resource);
                if (edit.getFacesConfig() == null || patternValue == null || patternName == null) break block21;
                EList beans = edit.getFacesConfig().getManagedBean();
                String type = null;
                type = callerType == 1 || callerType == 3 ? "dateTimePatterns" : (callerType == 2 ? "maskPatterns" : "numberPatterns");
                boolean foundPatterns = false;
                FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
                FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
                String packageName = "pagecode";
                String typeName = "ProjectConstants";
                int i = 0;
                while (i < beans.size()) {
                    String sName;
                    ManagedBeanType managedBean = (ManagedBeanType)beans.get(i);
                    String string = sName = managedBean.getManagedBeanName() != null ? managedBean.getManagedBeanName().getTextContent() : null;
                    if (sName != null && !sName.equals("") && sName.endsWith("_converter_patterns")) {
                        foundPatterns = true;
                        String beanClass = managedBean.getManagedBeanClass() != null ? managedBean.getManagedBeanClass().getTextContent() : null;
                        int typeSep = beanClass.lastIndexOf(".");
                        if (typeSep > 0) {
                            packageName = beanClass.substring(0, typeSep);
                            typeName = beanClass.substring(typeSep + 1, beanClass.length());
                        } else {
                            packageName = "";
                            typeName = beanClass;
                        }
                        EList properties = managedBean.getManagedProperty();
                        boolean foundType = false;
                        int j = 0;
                        while (j < properties.size()) {
                            String name;
                            ManagedPropertyType property = (ManagedPropertyType)properties.get(j);
                            String string2 = name = property.getPropertyName() != null ? property.getPropertyName().getTextContent() : null;
                            if (name != null && type.equals(name)) {
                                foundType = true;
                                MapEntriesType map = property.getMapEntries();
                                PatternBeanManager.addMapEntries(property, map, facesConfigFactory, patternName, patternValue);
                                break;
                            }
                            ++j;
                        }
                        if (!foundType) {
                            ManagedPropertyType newProperty = facesConfigFactory.createManagedPropertyType();
                            PropertyNameType name = facesConfigFactory.createPropertyNameType();
                            name.setTextContent(type);
                            newProperty.setPropertyName(name);
                            MapEntriesType map = facesConfigFactory.createMapEntriesType();
                            PatternBeanManager.addMapEntries(newProperty, map, facesConfigFactory, patternName, patternValue);
                            if (properties == null) break;
                            properties.add((Object)newProperty);
                            break;
                        }
                    }
                    ++i;
                }
                final IProject project = this.resource.getProject();
                if (!foundPatterns) {
                    ManagedBeanType bean = facesConfigFactory.createManagedBeanType();
                    ManagedBeanNameType name = facesConfigFactory.createManagedBeanNameType();
                    name.setTextContent("custom_converter_patterns");
                    bean.setManagedBeanName(name);
                    ManagedBeanScopeType scope = facesConfigFactory.createManagedBeanScopeType();
                    scope.setTextContent("request");
                    bean.setManagedBeanScope(scope);
                    if (PatternBeanManager.findType(project, packageName, typeName) != null) {
                        int i2 = 1;
                        while (true) {
                            String newTypeName;
                            if (PatternBeanManager.findType(project, packageName, newTypeName = String.valueOf(typeName) + "_" + i2) == null) {
                                typeName = newTypeName;
                                break;
                            }
                            ++i2;
                        }
                    }
                    ManagedBeanClassType clazz = facesConfigFactory.createManagedBeanClassType();
                    clazz.setTextContent(String.valueOf(packageName) + "." + typeName);
                    bean.setManagedBeanClass(clazz);
                    if (beans != null) {
                        beans.add((Object)bean);
                    }
                    ManagedPropertyType newProperty = facesConfigFactory.createManagedPropertyType();
                    PropertyNameType name2 = facesConfigFactory.createPropertyNameType();
                    name2.setTextContent(type);
                    newProperty.setPropertyName(name2);
                    EList properties = bean.getManagedProperty();
                    if (properties != null) {
                        properties.add((Object)newProperty);
                    }
                    MapEntriesType map = facesConfigFactory.createMapEntriesType();
                    PatternBeanManager.addMapEntries(newProperty, map, facesConfigFactory, patternName, patternValue);
                }
                final FacesConfigArtifactEdit facesToSave = edit;
                final String packageNameF = packageName;
                final String typenameF = typeName;
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) {
                        PatternBeanManager.createType(project, packageNameF, typenameF, monitor);
                        facesToSave.save(monitor);
                    }
                };
                try {
                    op.run((IProgressMonitor)new NullProgressMonitor());
                    Util.ensureBuildComplete((IProject)project, (boolean)true);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                this.loadFacesConfig();
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                    edit = null;
                }
            }
        }
    }

    private static IType findType(IProject project, String packageName, String typeName) {
        IJavaProject javaProj = JavaCore.create((IProject)project);
        try {
            IType type = javaProj.findType(packageName, typeName);
            return type;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static void createType(IProject project, String packageName, String typeName, IProgressMonitor monitor) {
        IJavaProject javaProj = JavaCore.create((IProject)project);
        try {
            IType type = javaProj.findType(packageName, typeName);
            if (type == null) {
                IPackageFragmentRoot[] roots = javaProj.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IPackageFragment fragment;
                    if (!roots[i].isArchive() && !roots[i].isExternal() && (fragment = roots[i].getPackageFragment(packageName)) != null) {
                        String contents = JsfProjectUtil.isJava5Project((IProject)project) ? PatternBeanManager.readTemplateFile("com/ibm/etools/jsf/support/dialogs/ProjectConstants_java5.template") : PatternBeanManager.readTemplateFile("com/ibm/etools/jsf/support/dialogs/ProjectConstants.template");
                        contents = PatternBeanManager.replace(contents, "${ProjectConstantsPackage}", packageName);
                        contents = PatternBeanManager.replace(contents, "${ProjectConstantsType}", typeName);
                        ICompilationUnit cu = fragment.createCompilationUnit(String.valueOf(typeName) + ".java", contents, false, monitor);
                        cu.save(monitor, true);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private static final String replace(String input, String replace, String replaceWith) {
        int i;
        char[] working = input.toCharArray();
        StringBuffer sb = new StringBuffer();
        int startindex = input.indexOf(replace);
        if (startindex < 0) {
            return input;
        }
        int currindex = 0;
        while (startindex > -1) {
            i = currindex;
            while (i < startindex) {
                sb.append(working[i]);
                ++i;
            }
            currindex = startindex;
            sb.append(replaceWith);
            startindex = input.indexOf(replace, currindex += replace.length());
        }
        i = currindex;
        while (i < working.length) {
            sb.append(working[i]);
            ++i;
        }
        return sb.toString();
    }

    private static String readTemplateFile(String file) {
        StringBuffer typeTemplate = new StringBuffer();
        InputStream is = PatternBeanManager.class.getClassLoader().getResourceAsStream(file);
        if (is != null) {
            byte[] buffer = new byte[1024];
            int read = 0;
            try {
                while ((read = is.read(buffer, 0, 1024)) >= 0) {
                    typeTemplate.append(new String(buffer, 0, read));
                }
            }
            catch (IOException iOException) {}
        }
        return typeTemplate.toString();
    }

    private static void addMapEntries(ManagedPropertyType property, MapEntriesType map, FacesConfigFactory facesConfigFactory, String patternName, String patternValue) {
        EList entries = map.getMapEntry();
        if (entries == null || entries.size() == 0) {
            map = facesConfigFactory.createMapEntriesType();
            property.setMapEntries(map);
            entries = map.getMapEntry();
        }
        boolean found = false;
        int i = 0;
        while (i < entries.size()) {
            String currValue;
            MapEntryType currElement = (MapEntryType)entries.get(i);
            String currKey = currElement.getKey() != null ? currElement.getKey().getTextContent() : null;
            String string = currValue = currElement.getValue() != null ? currElement.getValue().getTextContent() : null;
            if (currKey.equals(patternName) && !currValue.equals(patternValue)) {
                ValueType pattern = facesConfigFactory.createValueType();
                pattern.setTextContent(patternValue);
                currElement.setValue(pattern);
                found = true;
            }
            ++i;
        }
        if (!found) {
            MapEntryType newElement = facesConfigFactory.createMapEntryType();
            KeyType key = facesConfigFactory.createKeyType();
            key.setTextContent(patternName);
            newElement.setKey(key);
            ValueType value = facesConfigFactory.createValueType();
            value.setTextContent(patternValue);
            newElement.setValue(value);
            entries.add((Object)newElement);
        }
    }

    public String generateAttrValue(int callerType, String patternName) {
        String[] value = null;
        String pattern = null;
        if (callerType == 1 || callerType == 3) {
            value = this.getDateTimePatterns().get(patternName);
            pattern = "dateTimePatterns";
        } else if (callerType == 2) {
            value = this.getMaskPatterns().get(patternName);
            pattern = "maskPatterns";
        } else {
            value = this.getNumberPatterns().get(patternName);
            pattern = "numberPatterns";
        }
        StringBuffer attrVal = new StringBuffer("#{");
        attrVal.append(value[1]);
        attrVal.append(".");
        attrVal.append(pattern);
        attrVal.append(".");
        attrVal.append(patternName);
        attrVal.append("}");
        return attrVal.toString();
    }

    public static Character findTimePatternChar(String pattern) {
        int len = pattern.length();
        int i = 0;
        while (i < len) {
            char patternChar = pattern.charAt(i);
            if (patternChar == '\'') {
                int nextQuote = pattern.indexOf(39, i + 1);
                if (nextQuote < 0) break;
                i = nextQuote;
            } else {
                int j = 0;
                while (j < TIME_PTRN_CHARS.length) {
                    if (patternChar == TIME_PTRN_CHARS[j]) {
                        return new Character(patternChar);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private static void createConverterType(IProject project, String packageName, MaskConverterProperties properties, IProgressMonitor monitor) {
        String maskName = properties.getMaskName();
        String fileName = PatternBeanManager.createConverterFileName(maskName);
        HashMap<String, String> map = new HashMap<String, String>();
        IJavaProject javaProj = JavaCore.create((IProject)project);
        String mask = properties.getMaskPattern();
        map.put("mask", properties.getMaskPattern());
        map.put("char1RegEx", properties.getChar1RegEx());
        map.put("char2RegEx", properties.getChar2RegEx());
        map.put("char3RegEx", properties.getChar3RegEx());
        map.put("char4RegEx", properties.getChar4RegEx());
        try {
            IType type = javaProj.findType(packageName, fileName);
            IPackageFragmentRoot[] roots = javaProj.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragment fragment;
                if (!roots[i].isArchive() && !roots[i].isExternal() && (fragment = roots[i].getPackageFragment(packageName)) != null) {
                    if (type != null) {
                        ICompilationUnit cu = type.getCompilationUnit();
                        IType[] types = cu.getAllTypes();
                        IField[] fields = types[0].getFields();
                        int j = 0;
                        while (j < fields.length) {
                            if (fields[j].exists()) {
                                String fieldName = fields[j].getElementName();
                                String constant = fields[j].getConstant().toString();
                                Object obj = map.get(fieldName);
                                if (obj != null && !((String)map.get(fieldName)).equals("\"" + constant + "\"")) {
                                    String newField = "private static final String " + fieldName + " = \"" + (String)map.get(fieldName) + "\" ;";
                                    types[0].createField(newField, null, true, monitor);
                                    fields[j].delete(true, monitor);
                                }
                            }
                            ++j;
                        }
                        type.getCompilationUnit().save(monitor, true);
                    } else {
                        String contents = PatternBeanManager.readTemplateFile("com/ibm/etools/jsf/support/dialogs/ProjectMaskConverter.template");
                        contents = PatternBeanManager.replace(contents, "${char1RegEx}", properties.getChar1RegEx());
                        contents = PatternBeanManager.replace(contents, "${char2RegEx}", properties.getChar2RegEx());
                        contents = PatternBeanManager.replace(contents, "${char3RegEx}", properties.getChar3RegEx());
                        contents = PatternBeanManager.replace(contents, "${char4RegEx}", properties.getChar4RegEx());
                        contents = PatternBeanManager.replace(contents, "${mask}", mask);
                        contents = PatternBeanManager.replace(contents, "${ConverterName}", fileName);
                        ICompilationUnit unit = fragment.createCompilationUnit(String.valueOf(fileName) + ".java", contents, true, monitor);
                        unit.save(monitor, true);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static String createConverterFileName(String maskName) {
        String fileName = JavaCodeUtil.capitalizeFirst((String)maskName);
        fileName = JavaCodeUtil.legalizeJavaIdentifier((String)fileName);
        fileName = String.valueOf(fileName) + "Converter";
        return fileName;
    }

    public static int getConverterTypeFromConverterClass(String converterClass) {
        IResource resource = JsfProjectUtil.getCurrentPageResource();
        if (resource == null) {
            return 0;
        }
        IProject project = resource.getProject();
        if (JsfComponentUtil.isSuperclass((String)converterClass, (String)"com.ibm.faces.converter.MaskConverter", (IProject)project)) {
            return 3;
        }
        if (JsfComponentUtil.isSuperclass((String)converterClass, (String)"com.ibm.faces.converter.NumberConverterEx", (IProject)project)) {
            return 1;
        }
        if (JsfComponentUtil.isSuperclass((String)converterClass, (String)"com.ibm.faces.converter.NumberConverterExICU", (IProject)project)) {
            return 1;
        }
        if (JsfComponentUtil.isSuperclass((String)converterClass, (String)"com.ibm.faces.converter.DateTimeConverterEx", (IProject)project)) {
            return 2;
        }
        if (JsfComponentUtil.isSuperclass((String)converterClass, (String)"com.ibm.faces.converter.DateTimeConverterExICU", (IProject)project)) {
            return 2;
        }
        return 0;
    }

    public static int getConverterTypeFromConverterId(String converterId, IProject project) {
        HashMap<String, String> map = PatternBeanManager.getCustomConvertersClassesMap(project);
        String obj = map.get(converterId);
        if (obj == null) {
            return 0;
        }
        return PatternBeanManager.getConverterTypeFromConverterClass(obj);
    }

    public static int getConverterTypeFromClassName(String converterClass, IProject project) {
        if (project == null) {
            IResource resource = JsfProjectUtil.getCurrentPageResource();
            if (resource == null) {
                return 0;
            }
            project = resource.getProject();
        }
        if (JsfComponentUtil.isSuperclass((String)converterClass, (String)"com.ibm.faces.converter.MaskConverter", (IProject)project)) {
            return 3;
        }
        if (JsfComponentUtil.isSuperclass((String)converterClass, (String)"com.ibm.faces.converter.NumberConverterEx", (IProject)project)) {
            return 1;
        }
        if (JsfComponentUtil.isSuperclass((String)converterClass, (String)"com.ibm.faces.converter.NumberConverterExICU", (IProject)project)) {
            return 1;
        }
        if (JsfComponentUtil.isSuperclass((String)converterClass, (String)"com.ibm.faces.converter.DateTimeConverterEx", (IProject)project)) {
            return 2;
        }
        if (JsfComponentUtil.isSuperclass((String)converterClass, (String)"com.ibm.faces.converter.DateTimeConverterExICU", (IProject)project)) {
            return 2;
        }
        return 0;
    }

    public static String getCustomConverterPatternFromConverterId(String converterId) {
        String otherFacesXmlPath;
        IProject project;
        FacesConfigArtifactEdit edit;
        IResource resource = JsfProjectUtil.getCurrentPageResource();
        if (resource != null && (edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)(project = resource.getProject()), (String)(otherFacesXmlPath = FacesConfigSchemeUtil.getFacesConfigPathByScheme((String)"other", (IResource)resource)))).getFacesConfig() != null) {
            EList converters = edit.getFacesConfig().getConverter();
            int i = 0;
            while (i < converters.size()) {
                ConverterType conv;
                if (converters.get(i) != null && (conv = (ConverterType)converters.get(i)).getConverterId() != null && conv.getConverterId().getTextContent().compareTo(converterId) == 0) {
                    String classString = conv.getConverterClass() != null ? conv.getConverterClass().getTextContent() : null;
                    return PatternBeanManager.getConverterPatternFromClassName(classString);
                }
                ++i;
            }
        }
        return "";
    }

    public static String getConverterPatternFromClassName(String classString) {
        IResource resource = JsfProjectUtil.getCurrentPageResource();
        if (resource != null) {
            IProject project = resource.getProject();
            IJavaProject javaProj = JavaCore.create((IProject)project);
            try {
                IType type = javaProj.findType(classString);
                if (type != null) {
                    ICompilationUnit cu = type.getCompilationUnit();
                    IType[] types = cu.getAllTypes();
                    IField[] fields = types[0].getFields();
                    int j = 0;
                    while (j < fields.length) {
                        if (fields[j].getElementName().equals("mask")) {
                            return fields[j].getConstant().toString();
                        }
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static List<String> getAllConverterNames(IProject project) {
        LinkedList<String> list = new LinkedList<String>();
        list.addAll(PatternBeanManager.getConfigFileConverterNames(project));
        list.addAll(PatternBeanManager.getJarConverterNames(project));
        return list;
    }

    public static List<String> getConfigFileConverterNames(IProject project) {
        LinkedList<String> list = new LinkedList<String>();
        LinkedList<String> convertersToIgnore = new LinkedList<String>();
        convertersToIgnore.add("Mask");
        convertersToIgnore.add("javax.faces.Number");
        convertersToIgnore.add("javax.faces.DateTime");
        convertersToIgnore.add("com.ibm.faces.DateTime");
        convertersToIgnore.add("com.ibm.faces.Number");
        IFacesConfigResourceCollection collection = JsfFacesConfigUtil.getResourceCollection((IProject)project);
        FacesConfigType[] models = collection.getModels(2);
        int i = 0;
        while (i < models.length) {
            EObjectContainmentEList converters = (EObjectContainmentEList)models[i].getConverter();
            if (converters != null) {
                int j = 0;
                while (j < converters.size()) {
                    String convId;
                    ConverterType conv = (ConverterType)converters.get(j);
                    String string = convId = conv.getConverterId() != null ? conv.getConverterId().getTextContent() : null;
                    if (convId != null && !convertersToIgnore.contains(convId)) {
                        list.add(convId);
                        customConvertersClassesMap.put(convId, conv.getConverterClass().getTextContent());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list;
    }

    public static List<String> getJarConverterNames(IProject project) {
        LinkedList<String> list = new LinkedList<String>();
        String[] configFiles = JSFFacesConfigUtil.getFacesConfigPaths((IProject)project);
        int i = 0;
        while (i < configFiles.length) {
            block13: {
                FacesConfigArtifactEdit edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)configFiles[i]);
                try {
                    try {
                        if (edit != null && edit.getFacesConfig() != null) {
                            EList converters = edit.getFacesConfig().getConverter();
                            int j = 0;
                            while (j < converters.size()) {
                                ConverterType conv = (ConverterType)converters.get(j);
                                if (conv != null) {
                                    String convId;
                                    String string = convId = conv.getConverterId() != null ? conv.getConverterId().getTextContent() : null;
                                    if (convId != null) {
                                        list.add(convId);
                                        customConvertersClassesMap.put(convId, conv.getConverterClass().getTextContent());
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (edit != null) {
                            edit.dispose();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (edit != null) {
                        edit.dispose();
                    }
                    throw throwable;
                }
                if (edit != null) {
                    edit.dispose();
                }
            }
            ++i;
        }
        return list;
    }

    public static LinkedList<String> getConverterAttributes(IProject project, String converterId) {
        LinkedList<String> ret = new LinkedList<String>();
        IFacesConfigResourceCollection collection = JsfFacesConfigUtil.getResourceCollection((IProject)project);
        FacesConfigType[] models = collection.getModels(3);
        int i = 0;
        while (i < models.length) {
            EObjectContainmentEList converters = (EObjectContainmentEList)models[i].getConverter();
            if (converters != null) {
                int j = 0;
                while (j < converters.size()) {
                    String currConvId;
                    ConverterType conv = (ConverterType)converters.get(j);
                    String string = currConvId = conv.getConverterId() != null ? conv.getConverterId().getTextContent() : null;
                    if (currConvId != null && currConvId.equalsIgnoreCase(converterId) && conv.getAttribute() != null && conv.getAttribute().size() > 0) {
                        EList attributeList = conv.getAttribute();
                        for (AttributeType currType : attributeList) {
                            if (currType.getAttributeName() == null) continue;
                            ret.add(currType.getAttributeName().getTextContent());
                        }
                        return ret;
                    }
                    ++j;
                }
            }
            ++i;
        }
        String[] configFiles = JSFFacesConfigUtil.getFacesConfigPaths((IProject)project);
        int i2 = 0;
        while (i2 < configFiles.length) {
            FacesConfigArtifactEdit edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)configFiles[i2]);
            try {
                if (edit != null && edit.getFacesConfig() != null) {
                    EList converters = edit.getFacesConfig().getConverter();
                    int j = 0;
                    while (j < converters.size()) {
                        ConverterType conv = (ConverterType)converters.get(j);
                        if (conv != null) {
                            String convId;
                            String string = convId = conv.getConverterId() != null ? conv.getConverterId().getTextContent() : null;
                            if (convId != null && convId.equalsIgnoreCase(converterId)) {
                                EList attributeList = conv.getAttribute();
                                for (AttributeType currType : attributeList) {
                                    if (currType.getAttributeName() == null) continue;
                                    ret.add(currType.getAttributeName().getTextContent());
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
            ++i2;
        }
        return ret;
    }

    public static LinkedList<String> getValidatorAttributes(IProject project, String validatorId) {
        LinkedList<String> ret = new LinkedList<String>();
        IFacesConfigResourceCollection collection = JsfFacesConfigUtil.getResourceCollection((IProject)project);
        FacesConfigType[] models = collection.getModels(3);
        int i = 0;
        while (i < models.length) {
            EObjectContainmentEList validatorsList = (EObjectContainmentEList)models[i].getValidator();
            if (validatorsList != null) {
                int j = 0;
                while (j < validatorsList.size()) {
                    String currValidatorId;
                    ValidatorType currValidator = (ValidatorType)validatorsList.get(j);
                    String string = currValidatorId = currValidator.getValidatorId() != null ? currValidator.getValidatorId().getTextContent() : null;
                    if (currValidatorId != null && currValidatorId.equalsIgnoreCase(validatorId) && currValidator.getAttribute() != null && currValidator.getAttribute().size() > 0) {
                        EList attributeList = currValidator.getAttribute();
                        for (AttributeType currType : attributeList) {
                            if (currType.getAttributeName() == null) continue;
                            ret.add(currType.getAttributeName().getTextContent());
                        }
                        return ret;
                    }
                    ++j;
                }
            }
            ++i;
        }
        String[] configFiles = JSFFacesConfigUtil.getFacesConfigPaths((IProject)project);
        int i2 = 0;
        while (i2 < configFiles.length) {
            FacesConfigArtifactEdit edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)configFiles[i2]);
            try {
                if (edit != null && edit.getFacesConfig() != null) {
                    EList validatorsList = edit.getFacesConfig().getValidator();
                    int j = 0;
                    while (j < validatorsList.size()) {
                        ValidatorType conv = (ValidatorType)validatorsList.get(j);
                        if (conv != null) {
                            String convId;
                            String string = convId = conv.getValidatorId() != null ? conv.getValidatorId().getTextContent() : null;
                            if (convId != null && convId.equalsIgnoreCase(validatorId)) {
                                EList attributeList = conv.getAttribute();
                                for (AttributeType currType : attributeList) {
                                    if (currType.getAttributeName() == null) continue;
                                    ret.add(currType.getAttributeName().getTextContent());
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
            ++i2;
        }
        return ret;
    }

    public static HashMap<String, String> getCustomConvertersClassesMap(IProject project) {
        PatternBeanManager.getAllConverterNames(project);
        return customConvertersClassesMap;
    }
}

