/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.registry;

import com.ibm.etools.jsf.events.api.IFacesJavaScriptModelBuilder;
import com.ibm.etools.jsf.support.Debug;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public final class JSEventBuilderDefinition
implements Comparable {
    private IConfigurationElement element;
    private int priority;
    private String className;

    public JSEventBuilderDefinition(IConfigurationElement element) throws IllegalArgumentException {
        this.element = element;
        if (element.getName().equals("jsEventBuilder")) {
            String priorityStr = element.getAttribute("priority");
            if (priorityStr == null) {
                throw new IllegalArgumentException("[reg] Priority attribute is mandatory for JS Faces event builders - contribution ignored.");
            }
            this.priority = Integer.parseInt(priorityStr);
            this.className = element.getAttribute("class");
            if (this.className == null || this.className.length() == 0) {
                throw new IllegalArgumentException("[reg] ClassName attribute is mandatory for JS Faces event builders - contribution ignored.");
            }
        }
    }

    public IFacesJavaScriptModelBuilder createInstance() {
        IFacesJavaScriptModelBuilder builder = null;
        if (this.element != null && this.className != null) {
            try {
                builder = (IFacesJavaScriptModelBuilder)this.element.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                Debug.trace("[reg] Problem instantiating class: " + this.className, "registry");
            }
        }
        return builder;
    }

    public int compareTo(Object o) {
        if (o instanceof JSEventBuilderDefinition) {
            JSEventBuilderDefinition other = (JSEventBuilderDefinition)o;
            if (this.priority < other.priority) {
                return -1;
            }
            if (this.priority == other.priority) {
                return 0;
            }
            return 1;
        }
        return -1;
    }
}

