/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.preferences;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StylesheetPropertyPage
extends PropertyPage
implements SelectionListener {
    private IProject project;
    private Table table;
    private TableEditor editor;
    private Button addButton;
    private Button deleteButton;

    protected Control createContents(Composite parent) {
        this.project = this.getProject();
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        page.setLayout((Layout)layout);
        GridData data = new GridData(768);
        page.setLayoutData((Object)data);
        Label label = new Label(page, 0);
        label.setText(Messages.Stylesheet_PreLabel);
        Composite tableArea = new Composite(page, 0);
        GridLayout tableLayout = new GridLayout();
        tableLayout.marginHeight = 0;
        tableLayout.marginWidth = 0;
        tableLayout.numColumns = 2;
        tableArea.setLayout((Layout)tableLayout);
        GridData gridData = new GridData(770);
        gridData.heightHint = 80;
        tableArea.setLayoutData((Object)gridData);
        this.table = new Table(tableArea, 2052);
        this.table.setLinesVisible(true);
        this.initializeDialogUnits((Control)this.table);
        this.table.setLayoutData((Object)gridData);
        new TableColumn(this.table, 0);
        this.fillTable();
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = StylesheetPropertyPage.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                Text newEditor = new Text((Composite)StylesheetPropertyPage.this.table, 0);
                newEditor.setText(item.getText());
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text text = (Text)StylesheetPropertyPage.this.editor.getEditor();
                        StylesheetPropertyPage.this.editor.getItem().setText(text.getText());
                    }
                });
                newEditor.selectAll();
                newEditor.setFocus();
                StylesheetPropertyPage.this.editor.setEditor((Control)newEditor, item, 0);
            }
        });
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle currentBounds = StylesheetPropertyPage.this.table.getBounds();
                StylesheetPropertyPage.this.table.setBounds(currentBounds.x, currentBounds.y, currentBounds.width, StylesheetPropertyPage.this.table.getItemHeight() * 5 + StylesheetPropertyPage.this.table.getBorderWidth() * 2);
                StylesheetPropertyPage.this.table.getColumn(0).setWidth(((StylesheetPropertyPage)StylesheetPropertyPage.this).table.getClientArea().width);
            }
        });
        Composite buttonComposite = new Composite(tableArea, 0);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(34));
        this.addButtons(buttonComposite);
        Label bottomLabel = new Label(page, 64);
        bottomLabel.setText(Messages.Stylesheet_PostLabel);
        GridData labelData = new GridData();
        labelData.widthHint = 400;
        bottomLabel.setLayoutData((Object)labelData);
        return page;
    }

    protected void addButtons(Composite parent) {
        GridData data = new GridData();
        this.addButton = new Button(parent, 8);
        this.addButton.setText(Messages.Stylesheet_Add);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.addButton.setLayoutData((Object)data);
        this.deleteButton = new Button(parent, 8);
        this.deleteButton.setText(Messages.Stylesheet_Remove);
        this.deleteButton.addSelectionListener((SelectionListener)this);
        this.deleteButton.setLayoutData((Object)data);
    }

    public boolean performOk() {
        TableItem[] items = this.table.getItems();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            buffer.append(items[i].getText().trim());
            if (i < items.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        String sheetsString = buffer.toString();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
        if (sheetsString.equals(JsfPlugin.getDefault().getPreferenceStore().getString("jsf.standard.stylesheets"))) {
            component.getMetaProperties().remove("jsf.standard.stylesheets");
        } else {
            component.setMetaProperty("jsf.standard.stylesheets", sheetsString);
        }
        return super.performOk();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        int selection;
        if (e.getSource() == this.addButton) {
            TableItem newItem = new TableItem(this.table, 0);
            newItem.setText(Messages.Stylesheet_NewStylesheet);
        }
        if (e.getSource() == this.deleteButton && (selection = this.table.getSelectionIndex()) > -1) {
            Control oldEditor = this.editor.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
            this.table.remove(selection);
        }
    }

    private void fillTable() {
        String[] sheets = JsfCommandUtil.getStandardStylesheets(this.project);
        int i = 0;
        while (i < sheets.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(sheets[i]);
            ++i;
        }
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        return null;
    }

    protected void performDefaults() {
        super.performDefaults();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
        Properties props = component.getMetaProperties();
        props.setProperty("jsf.standard.stylesheets", JsfPlugin.getDefault().getPreferenceStore().getString("jsf.standard.stylesheets"));
        component.setMetaProperties(props);
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        this.table.removeAll();
        this.fillTable();
    }
}

