/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.commands;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class ReparentNodeCommand
extends EditRangeCommand {
    private Node nodeToReparent;
    private List<Node> targetAncestors = new ArrayList<Node>();

    public ReparentNodeCommand(Node nodeToReparent) {
        super(Messages.commands_tag_insert_1);
        this.nodeToReparent = nodeToReparent;
    }

    protected void doExecute() {
        Node targetNode = null;
        Range range = this.getRange();
        if (range == null) {
            return;
        }
        targetNode = range.getEndContainer();
        Node parentNode = targetNode;
        while (parentNode != null) {
            this.targetAncestors.add(parentNode);
            parentNode = parentNode.getParentNode();
        }
        this.doReparenting();
    }

    protected void doReparenting() {
        IDOMDocument document = (IDOMDocument)this.getDocument();
        boolean isDesignTimeTemplate = TemplateTypeUtil.isInstance((IStructuredModel)document.getModel());
        Node commonAncestor = this.findCommonAncestor();
        if (commonAncestor == null) {
            return;
        }
        Node oldParent = this.nodeToReparent.getParentNode();
        this.doMove(oldParent, commonAncestor);
        if (isDesignTimeTemplate) {
            JsfCommandUtil.fixReadOnlyState(document);
        }
        JsfCommandUtil.fixTaglibLocations(this.nodeToReparent);
        JsfCommandUtil.fixPageDirectiveLocation(this.nodeToReparent);
    }

    protected Node findCommonAncestor() {
        if (this.targetAncestors.contains(this.nodeToReparent)) {
            return null;
        }
        IDOMNode cursorNode = (IDOMNode)this.nodeToReparent.getParentNode();
        while (cursorNode != null) {
            if (this.targetAncestors.contains(cursorNode) && cursorNode.isChildEditable()) {
                return cursorNode;
            }
            cursorNode = (IDOMNode)cursorNode.getParentNode();
        }
        return null;
    }

    protected void doMove(Node oldParent, Node commonAncestor) {
        JsfCommandUtil.doMove(this.nodeToReparent, oldParent, commonAncestor);
    }

    protected Node getNodeToReparent() {
        return this.nodeToReparent;
    }

    protected List getTargetAncestors() {
        return this.targetAncestors;
    }
}

