/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.commands;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class InsertAsParentCommand
extends EditRangeCommand {
    private NodeFactory factory;
    private Node nodeToEnclose;
    private boolean setRange = true;
    private Node firstEnclosedNode;
    private int enclosedNodeCount;

    public InsertAsParentCommand(NodeFactory factory, Node nodeToEnclose) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
        this.nodeToEnclose = nodeToEnclose;
    }

    public InsertAsParentCommand(NodeFactory factory, Node nodeToEnclose, boolean setRange) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
        this.nodeToEnclose = nodeToEnclose;
        this.setRange = setRange;
    }

    public InsertAsParentCommand(NodeFactory factory, Range rangeToEnclose, boolean setRange) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
        this.setRange = setRange;
        if (rangeToEnclose != null) {
            Node container = rangeToEnclose.getStartContainer();
            Node child = container.getFirstChild();
            int count = rangeToEnclose.getStartOffset();
            while (count > 0 && child != null) {
                child = child.getNextSibling();
                --count;
            }
            this.firstEnclosedNode = child;
            this.enclosedNodeCount = rangeToEnclose.getEndOffset() - rangeToEnclose.getStartOffset();
        }
    }

    public InsertAsParentCommand(NodeFactory factory, boolean setRange) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
        this.setRange = setRange;
    }

    protected void doExecute() {
        IDOMDocument document = (IDOMDocument)this.getDocument();
        boolean isDesignTimeTemplate = TemplateTypeUtil.isInstance((IStructuredModel)document.getModel());
        Range textTargetRange = ((DocumentRange)document).createRange();
        Node newNode = this.factory.createNode((Document)document, textTargetRange);
        if (newNode == null) {
            return;
        }
        if (this.nodeToEnclose != null) {
            Node oldParent = this.nodeToEnclose.getParentNode();
            if (oldParent == null) {
                return;
            }
            oldParent.replaceChild(newNode, this.nodeToEnclose);
            newNode.appendChild(this.nodeToEnclose);
        } else if (this.firstEnclosedNode != null) {
            Node node = this.firstEnclosedNode;
            Node nextNode = node.getNextSibling();
            Node oldParent = node.getParentNode();
            oldParent.replaceChild(newNode, node);
            newNode.appendChild(node);
            int count = 0;
            while (count < this.enclosedNodeCount) {
                node = nextNode;
                nextNode = node.getNextSibling();
                newNode.appendChild(node);
                ++count;
            }
            newNode.appendChild(nextNode);
        } else {
            Range r = this.getRange();
            Node nodeToEnclose = JsfCommandUtil.getTargetNode(r);
            Node oldParent = nodeToEnclose.getParentNode();
            if (oldParent == null) {
                return;
            }
            oldParent.replaceChild(newNode, nodeToEnclose);
            newNode.appendChild(nodeToEnclose);
        }
        JsfCommandUtil.cleanupNodeAttributes(newNode);
        if (isDesignTimeTemplate) {
            JsfCommandUtil.fixReadOnlyState(document);
        }
        if (this.setRange) {
            Range newRange = ((DocumentRange)document).createRange();
            newRange.setStart(newNode, 0);
            newRange.setEnd(newNode, 0);
            this.setRange(newRange);
        }
    }

    public HTMLCommand.Condition getFreeLayoutSupport() {
        return FLM_ADD_CELL;
    }
}

