/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.commands;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class EncloseChildrenCommand
extends EditRangeCommand {
    private NodeFactory factory;
    private Node target;
    private String[] targetTagNames;

    public EncloseChildrenCommand(NodeFactory factory, Node target) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
        this.target = target;
    }

    public EncloseChildrenCommand(NodeFactory factory, String[] fullTagNames) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
        this.targetTagNames = fullTagNames;
    }

    protected void doExecute() {
        if (this.targetTagNames != null) {
            this.target = this.findTarget();
        }
        if (this.target == null || this.factory == null) {
            return;
        }
        IDOMDocument document = (IDOMDocument)JsfCommandUtil.getDocument(this.target);
        boolean isDesignTimeTemplate = TemplateTypeUtil.isInstance((IStructuredModel)document.getModel());
        Range textTargetRange = ((DocumentRange)document).createRange();
        Node newNode = this.factory.createNode((Document)document, textTargetRange);
        if (newNode == null) {
            return;
        }
        Node child = this.target.getFirstChild();
        int childCount = 0;
        int rangeOffset = -1;
        while (child != null) {
            ++childCount;
            Node nextChild = child.getNextSibling();
            this.target.removeChild(child);
            newNode.appendChild(child);
            child = nextChild;
        }
        this.target.appendChild(newNode);
        JsfCommandUtil.cleanupNodeAttributes(newNode);
        if (isDesignTimeTemplate) {
            JsfCommandUtil.fixReadOnlyState(document);
        }
        JsfCommandUtil.fixPortletTagLocations(newNode);
        JsfCommandUtil.fixLinkNodes(newNode);
        JsfCommandUtil.fixTaglibLocations(newNode);
        JsfCommandUtil.fixPageCodeComment(newNode);
        JsfCommandUtil.fixPageDirectiveLocation(newNode);
        JsfCommandUtil.fixDoctypeLocation(newNode);
        JsfCommandUtil.fixJspRootLocation((Document)document);
        Node trueTarget = this.getRange().getEndContainer();
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)this.target);
        if (trueTarget == this.target || query.isFragment((Document)document) && trueTarget != document && trueTarget.getParentNode() == null) {
            Range newRange = ((DocumentRange)document).createRange();
            if (rangeOffset == -1) {
                rangeOffset = this.getRange().getStartOffset();
            }
            newRange.setStart(newNode, rangeOffset);
            newRange.setEnd(newNode, rangeOffset);
            this.setRange(newRange);
        }
    }

    private Node findTarget() {
        Node targetNode = JsfCommandUtil.getTargetNode(this.getRange());
        while (targetNode != null) {
            String nodeName = targetNode.getNodeName();
            int i = 0;
            while (i < this.targetTagNames.length) {
                if (this.targetTagNames[i].equals(nodeName)) {
                    return targetNode;
                }
                ++i;
            }
            targetNode = targetNode.getParentNode();
        }
        return null;
    }
}

