/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.commands;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.support.FindNodeUtil;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class EditNodeAttributesCommand
extends EditRangeCommand {
    private String _nodeToEdit;
    private String _attrName;
    private String _attrValue;
    private Map _attrKeyValue = new HashMap();
    private Node _targetNode = null;

    public EditNodeAttributesCommand(String nodeToEdit, Map attrKeyValue) {
        super(Messages.EditNodeAttributesCommand_edit_attribute_1);
        this._nodeToEdit = nodeToEdit;
        if (!attrKeyValue.isEmpty()) {
            this._attrKeyValue.putAll(attrKeyValue);
        } else {
            this._attrKeyValue = null;
        }
        this._attrName = null;
        this._attrValue = null;
    }

    public EditNodeAttributesCommand(String nodeToEdit, String attrName, String attrValue) {
        this(nodeToEdit, attrName, attrValue, false);
    }

    public EditNodeAttributesCommand(String nodeToEdit, String attrName, String attrValue, boolean bEmptyAllowed) {
        super(Messages.commands_tag_insert_1);
        this._nodeToEdit = nodeToEdit;
        this._attrName = attrName;
        if (this._attrName == null || this._attrName.length() == 0) {
            this._attrName = null;
        }
        this._attrValue = attrValue;
        if (!bEmptyAllowed && this._attrValue != null && this._attrValue.length() == 0) {
            this._attrValue = null;
        }
        this._attrKeyValue = null;
    }

    public EditNodeAttributesCommand(Node targetNode, Map attrKeyValue) {
        super(Messages.EditNodeAttributesCommand_edit_attribute_1);
        this._nodeToEdit = targetNode.getNodeName();
        this._targetNode = targetNode;
        if (!attrKeyValue.isEmpty()) {
            this._attrKeyValue.putAll(attrKeyValue);
        } else {
            this._attrKeyValue = null;
        }
        this._attrName = null;
        this._attrValue = null;
    }

    public EditNodeAttributesCommand(Node targetNode, String attrName, String attrValue) {
        this(targetNode, attrName, attrValue, false);
    }

    public EditNodeAttributesCommand(Node targetNode, String attrName, String attrValue, boolean bEmptyAllowed) {
        super(Messages.commands_tag_insert_1);
        this._nodeToEdit = targetNode.getNodeName();
        this._targetNode = targetNode;
        this._attrName = attrName;
        if (this._attrName == null || this._attrName.length() == 0) {
            this._attrName = null;
        }
        this._attrValue = attrValue;
        if (!bEmptyAllowed && this._attrValue != null && this._attrValue.length() == 0) {
            this._attrValue = null;
        }
        this._attrKeyValue = null;
    }

    protected void doExecute() {
        if (this._targetNode == null) {
            Range range = this.getRange();
            if (range != null) {
                this._targetNode = range.getEndContainer();
            } else {
                return;
            }
        }
        Node parentNode = this._targetNode;
        while (parentNode != null && !FindNodeUtil.isSameTagName(parentNode, parentNode.getNodeName(), this._nodeToEdit)) {
            parentNode = parentNode.getParentNode();
        }
        if (parentNode != null && FindNodeUtil.isSameTagName(parentNode, parentNode.getNodeName(), this._nodeToEdit)) {
            Element parentElement = (Element)parentNode;
            this.setAttributes(parentElement);
        } else if (parentNode == null) {
            NodeList nodeToEditNodes = this._targetNode.getOwnerDocument().getElementsByTagName(this._nodeToEdit);
            if (nodeToEditNodes != null && nodeToEditNodes.item(0) != null) {
                Element parentElement = (Element)nodeToEditNodes.item(0);
                this.setAttributes(parentElement);
            } else {
                Debug.trace("EditNodeAttributesCommand -- Did not find any " + this._nodeToEdit + " tag on the page. Could not edit the attrs as tag does not exist!!!", "edit-node-cmd");
            }
        }
    }

    private void setAttributes(Element parentElement) {
        if (this._attrName != null) {
            if (this._attrValue != null) {
                parentElement.setAttribute(this._attrName, this._attrValue);
            } else {
                parentElement.removeAttribute(this._attrName);
            }
        }
        if (this._attrKeyValue != null) {
            Set<Object> set = new HashSet();
            set = this._attrKeyValue.keySet();
            Iterator<Object> itr = set.iterator();
            while (itr.hasNext()) {
                this._attrName = itr.next().toString();
                this._attrValue = (String)this._attrKeyValue.get(this._attrName);
                if (this._attrValue != null) {
                    parentElement.setAttribute(this._attrName, this._attrValue);
                    continue;
                }
                parentElement.removeAttribute(this._attrName);
            }
        }
    }
}

