/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.actions;

import com.ibm.etools.jsf.internal.nls.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class ElementTypePickerDialog
extends Dialog {
    private String[] availableTypes = null;
    private String[] availableTypesDescr = null;
    private String selectedType = null;
    private List lst = null;
    private Label descrText = null;
    private int maxLen = 1;

    public ElementTypePickerDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 2;
        gridLayout.verticalSpacing = 7;
        dialogArea.setLayout((Layout)gridLayout);
        Label lbl = new Label(dialogArea, 0);
        lbl.setText(Messages.ElementTypePickerDialog_Select_the_required_type__1);
        lbl.setLayoutData((Object)new GridData(2));
        this.lst = new List(dialogArea, 2052);
        this.lst.setLayoutData((Object)new GridData(1808));
        if (this.availableTypes != null) {
            this.lst.setItems(this.availableTypes);
        }
        this.lst.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ElementTypePickerDialog.this.okPressed();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Label descrLabel = new Label(dialogArea, 0);
        descrLabel.setText(Messages.ElementTypePickerDialog_Description__1);
        this.descrText = new Label(dialogArea, 2112);
        int numRows = this.maxLen / 30;
        int numCols = 30;
        numRows = numRows > 0 ? numRows : 1;
        int n = numRows = this.maxLen / numRows >= 30 ? numRows + 1 : numRows;
        if (this.availableTypesDescr != null) {
            GC gc = new GC((Drawable)this.descrText);
            Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
            gc.setFont(font);
            String longestDescr = null;
            int i = 0;
            while (i < this.availableTypesDescr.length) {
                if (this.availableTypesDescr[i].length() == this.maxLen) {
                    longestDescr = this.availableTypesDescr[i];
                }
                ++i;
            }
            if (this.maxLen < 30) {
                Point point = gc.textExtent(longestDescr);
                numCols = point.x + 4;
                numRows = point.y + 3;
            } else {
                Point point = gc.textExtent(longestDescr.substring(0, 30));
                numCols = point.x + 4;
                numRows = numRows * point.y + 3;
            }
            gc.dispose();
        }
        GridData gridData = new GridData();
        gridData.heightHint = numRows;
        gridData.widthHint = numCols;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.descrText.setLayoutData((Object)gridData);
        this.descrText.setText("dummy text");
        this.lst.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ElementTypePickerDialog.this.lst.getSelectionIndex() != -1 && ElementTypePickerDialog.this.availableTypesDescr != null) {
                    ElementTypePickerDialog.this.updateDescription(ElementTypePickerDialog.this.lst.getSelectionIndex());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lst.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ElementTypePickerDialog.this.okPressed();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        if (this.availableTypes.length > 0) {
            this.lst.setSelection(0);
            this.updateDescription(this.lst.getSelectionIndex());
        }
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String titleText = Messages.ElementTypePickerDialog_Select_Component_Type_3;
        newShell.setText(titleText);
    }

    protected void okPressed() {
        String[] tmpArray = this.lst.getSelection();
        if (this.lst.getSelection().length != 0) {
            this.selectedType = tmpArray[0];
            super.okPressed();
        }
    }

    public String getSelectedType() {
        return this.selectedType;
    }

    public void setAvailableTypes(String[] types) {
        this.availableTypes = types;
    }

    public void setAvailableTypesDescr(String[] descriptions) {
        this.availableTypesDescr = descriptions;
    }

    private void updateDescription(int index) {
        if (this.availableTypesDescr != null && this.availableTypesDescr.length >= index) {
            this.descrText.setText(this.availableTypesDescr[index]);
        }
    }

    public void setMaxLen(int len) {
        this.maxLen = len;
    }
}

