/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.wizard;

import com.ibm.etools.jsf.facesconfig.util.AddOrModifyJ2EEContextParamRunnable;
import com.ibm.etools.jsf.facesconfig.util.AddOrModifyJEEContextParamRunnable;
import com.ibm.etools.jsf.internal.wizard.runnables.DefineJ2EEContextParamsRunnable;
import com.ibm.etools.jsf.internal.wizard.runnables.DefineJ2EEFilterRunnable;
import com.ibm.etools.jsf.internal.wizard.runnables.DefineJ2EEListenerRunnable;
import com.ibm.etools.jsf.internal.wizard.runnables.DefineJ2EEServletMappingRunnable;
import com.ibm.etools.jsf.internal.wizard.runnables.DefineJ2EEServletRunnable;
import com.ibm.etools.jsf.internal.wizard.runnables.DefineJEEContextParamsRunnable;
import com.ibm.etools.jsf.internal.wizard.runnables.DefineJEEFilterRunnable;
import com.ibm.etools.jsf.internal.wizard.runnables.DefineJEEListenerRunnable;
import com.ibm.etools.jsf.internal.wizard.runnables.DefineJEEServletMappingRunnable;
import com.ibm.etools.jsf.internal.wizard.runnables.DefineJEEServletRunnable;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.support.wizard.JsfWizardOperationBase;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.constants.JsfContextParams;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;

public class WizardOperationUtils {
    public static final void defineServlet(IProject project, String servletName, String servletClassName, String servletMappingUrl, String servletLoadOnStartup) {
        if (servletName == null || servletClassName == null) {
            return;
        }
        if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
            return;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        if (provider == null) {
            return;
        }
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return;
        }
        if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
            if (WizardOperationUtils.isDuplicateServlet(webApp, servletClassName, servletMappingUrl)) {
                return;
            }
            if (provider.validateEdit(null, null).isOK()) {
                provider.modify((Runnable)new DefineJ2EEServletRunnable(webApp, servletName, servletClassName, servletMappingUrl, servletLoadOnStartup), null);
            }
        } else if (webAppObj instanceof WebApp) {
            WebApp webApp = (WebApp)webAppObj;
            if (WizardOperationUtils.isDuplicateServlet(webApp, servletClassName, servletMappingUrl)) {
                return;
            }
            if (provider.validateEdit(null, null).isOK()) {
                provider.modify((Runnable)new DefineJEEServletRunnable(webApp, servletName, servletClassName, servletMappingUrl, servletLoadOnStartup), null);
            }
        }
    }

    public static final boolean isDuplicateServlet(IProject project, String servletClassName, String servletMappingUrl) {
        if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
            return false;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        if (provider == null) {
            return false;
        }
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return false;
        }
        if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            return WizardOperationUtils.isDuplicateServlet((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj, servletClassName, servletMappingUrl);
        }
        if (webAppObj instanceof WebApp) {
            return WizardOperationUtils.isDuplicateServlet((WebApp)webAppObj, servletClassName, servletMappingUrl);
        }
        return false;
    }

    protected static final boolean isDuplicateServlet(org.eclipse.jst.j2ee.webapplication.WebApp webApp, String servletClassName, String servletMappingUrl) {
        for (Servlet servlet : webApp.getServlets()) {
            ServletType type;
            String className;
            if (!(servlet.getWebType() instanceof ServletType) || !servletClassName.equals(className = (type = (ServletType)servlet.getWebType()).getClassName())) continue;
            return true;
        }
        for (org.eclipse.jst.j2ee.webapplication.ServletMapping mapping : webApp.getServletMappings()) {
            if (!servletMappingUrl.equals(mapping.getUrlPattern())) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isDuplicateServlet(WebApp webApp, String servletClassName, String servletMappingUrl) {
        for (org.eclipse.jst.javaee.web.Servlet servlet : webApp.getServlets()) {
            String className = servlet.getServletClass();
            if (!servletClassName.equals(className)) continue;
            return true;
        }
        for (ServletMapping mapping : webApp.getServletMappings()) {
            Iterator patterns = mapping.getUrlPatterns().iterator();
            while (patterns.hasNext()) {
                if (!servletMappingUrl.equals(((UrlPatternType)patterns.next()).getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public static final void defineAdditionalServletMapping(IProject project, String servletName, String servletMappingUrl) {
        if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
            return;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        if (provider == null) {
            return;
        }
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return;
        }
        if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
            if (WizardOperationUtils.isDuplicateServlet(webApp, "", servletMappingUrl)) {
                return;
            }
            if (provider.validateEdit(null, null).isOK()) {
                provider.modify((Runnable)new DefineJ2EEServletMappingRunnable(webApp, servletName, servletMappingUrl), null);
            }
        } else if (webAppObj instanceof WebApp) {
            WebApp webApp = (WebApp)webAppObj;
            if (WizardOperationUtils.isDuplicateServlet(webApp, "", servletMappingUrl)) {
                return;
            }
            if (provider.validateEdit(null, null).isOK()) {
                provider.modify((Runnable)new DefineJEEServletMappingRunnable(webApp, servletName, servletMappingUrl), null);
            }
        }
    }

    public static final void defineContextParam(IProject project, String paramName, String paramValue, String paramDescription, boolean overwriteExisting) {
        if (paramName == null || paramValue == null) {
            return;
        }
        if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
            return;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        if (provider == null) {
            return;
        }
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return;
        }
        if (provider.validateEdit(null, null).isOK()) {
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
                provider.modify((Runnable)new AddOrModifyJ2EEContextParamRunnable(webApp, paramName, paramDescription, paramValue, overwriteExisting), null);
            } else if (webAppObj instanceof WebApp) {
                WebApp webApp = (WebApp)webAppObj;
                provider.modify((Runnable)new AddOrModifyJEEContextParamRunnable(webApp, paramName, paramDescription, paramValue, overwriteExisting), null);
            }
        }
    }

    public static final boolean isDuplicateContextParam(IProject project, String paramName) {
        block9: {
            Object webAppObj;
            block8: {
                if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
                    return false;
                }
                IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
                if (provider == null) {
                    return false;
                }
                webAppObj = provider.getModelObject();
                if (webAppObj == null) {
                    return false;
                }
                if (!(webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp)) break block8;
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
                if (webApp.getJ2EEVersionID() >= 14) {
                    for (ParamValue parm : webApp.getContextParams()) {
                        if (!paramName.equals(parm.getName())) continue;
                        return true;
                    }
                } else {
                    for (ContextParam parm : webApp.getContexts()) {
                        if (!paramName.equals(parm.getParamName())) continue;
                        return true;
                    }
                }
                break block9;
            }
            if (!(webAppObj instanceof WebApp)) break block9;
            WebApp webApp = (WebApp)webAppObj;
            for (org.eclipse.jst.javaee.core.ParamValue parm : webApp.getContextParams()) {
                if (!paramName.equals(parm.getParamName())) continue;
                return true;
            }
        }
        return false;
    }

    public static final void defineListener(IProject project, String listenerClassName) {
        if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
            return;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        if (provider == null) {
            return;
        }
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return;
        }
        if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
            if (WizardOperationUtils.isDuplicateListener(webApp, listenerClassName)) {
                return;
            }
            if (provider.validateEdit(null, null).isOK()) {
                provider.modify((Runnable)new DefineJ2EEListenerRunnable(webApp, listenerClassName), null);
            }
        } else if (webAppObj instanceof WebApp) {
            WebApp webApp = (WebApp)webAppObj;
            if (WizardOperationUtils.isDuplicateListener(webApp, listenerClassName)) {
                return;
            }
            if (provider.validateEdit(null, null).isOK()) {
                provider.modify((Runnable)new DefineJEEListenerRunnable(webApp, listenerClassName), null);
            }
        }
    }

    public static final boolean isDuplicateListener(IProject project, String listenerClassName) {
        if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
            return false;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        if (provider == null) {
            return false;
        }
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return false;
        }
        if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            return WizardOperationUtils.isDuplicateListener((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj, listenerClassName);
        }
        if (webAppObj instanceof WebApp) {
            return WizardOperationUtils.isDuplicateListener((WebApp)webAppObj, listenerClassName);
        }
        return false;
    }

    protected static final boolean isDuplicateListener(org.eclipse.jst.j2ee.webapplication.WebApp webApp, String listenerClassName) {
        for (Listener listener : webApp.getListeners()) {
            if (!listenerClassName.equals(listener.getListenerClassName())) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isDuplicateListener(WebApp webApp, String listenerClassName) {
        for (org.eclipse.jst.javaee.core.Listener listener : webApp.getListeners()) {
            if (!listenerClassName.equals(listener.getListenerClass())) continue;
            return true;
        }
        return false;
    }

    public static final void defineContextParams(IProject project, JsfContextParams.ContextParam[] params, boolean overwriteExisting) {
        if (params == null) {
            return;
        }
        if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
            return;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        if (provider == null) {
            return;
        }
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return;
        }
        if (provider.validateEdit(null, null).isOK()) {
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
                provider.modify((Runnable)new DefineJ2EEContextParamsRunnable(webApp, params, overwriteExisting), null);
            } else if (webAppObj instanceof WebApp) {
                WebApp webApp = (WebApp)webAppObj;
                provider.modify((Runnable)new DefineJEEContextParamsRunnable(webApp, params, overwriteExisting), null);
            }
        }
    }

    public static final void defineFilter(IProject project, String filterName, String filterClassName, String filterDescription, JsfWizardOperationBase.InitParamDefinition[] initParams, JsfWizardOperationBase.FilterMappingDefinition[] mappings) {
        if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
            return;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        if (provider == null) {
            return;
        }
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return;
        }
        if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
            if (WizardOperationUtils.isDuplicateFilter(webApp, filterName)) {
                return;
            }
            if (provider.validateEdit(null, null).isOK()) {
                provider.modify((Runnable)new DefineJ2EEFilterRunnable(webApp, filterName, filterClassName, filterDescription, initParams, mappings), null);
            }
        } else if (webAppObj instanceof WebApp) {
            WebApp webApp = (WebApp)webAppObj;
            if (WizardOperationUtils.isDuplicateFilter(webApp, filterName)) {
                return;
            }
            if (provider.validateEdit(null, null).isOK()) {
                provider.modify((Runnable)new DefineJEEFilterRunnable(webApp, filterName, filterClassName, filterDescription, initParams, mappings), null);
            }
        }
    }

    public static final boolean isDuplicateFilter(IProject project, String filterName) {
        if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
            return false;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        if (provider == null) {
            return false;
        }
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return false;
        }
        if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            return WizardOperationUtils.isDuplicateFilter((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj, filterName);
        }
        if (webAppObj instanceof WebApp) {
            return WizardOperationUtils.isDuplicateFilter((WebApp)webAppObj, filterName);
        }
        return false;
    }

    protected static final boolean isDuplicateFilter(org.eclipse.jst.j2ee.webapplication.WebApp webApp, String filterName) {
        for (org.eclipse.jst.j2ee.webapplication.Filter filter : webApp.getFilters()) {
            if (!filterName.equals(filter.getName())) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isDuplicateFilter(WebApp webApp, String filterName) {
        for (Filter filter : webApp.getFilters()) {
            if (!filterName.equals(filter.getFilterName())) continue;
            return true;
        }
        return false;
    }

    protected static void removeRiJarsFromWAS7Project(IProject project) {
        try {
            IFile jsfImplJar;
            boolean removedApi = false;
            boolean removedImpl = false;
            IFolder folder = (IFolder)JsfProjectUtil.getWebInfLibFolder((IProject)project);
            if (folder == null) {
                return;
            }
            IWorkspace workspace = folder.getWorkspace();
            IFile jsfApiJar = folder.getFile("jsf-api.jar");
            if (jsfApiJar.exists() && workspace.validateEdit(new IFile[]{jsfApiJar}, null).isOK()) {
                jsfApiJar.delete(true, (IProgressMonitor)new NullProgressMonitor());
                Debug.trace("[wiz] removed jsf-api.jar from WAS 7.0 project", "wizard");
                removedApi = true;
            }
            if ((jsfImplJar = folder.getFile("jsf-impl.jar")).exists() && workspace.validateEdit(new IFile[]{jsfImplJar}, null).isOK()) {
                jsfImplJar.delete(true, (IProgressMonitor)new NullProgressMonitor());
                Debug.trace("[wiz] removed jsf-impl.jar from WAS 7.0 project", "wizard");
                removedImpl = true;
            }
            if (!removedApi && !removedImpl) {
                return;
            }
            IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)project);
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> newCpList = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < cp.length) {
                block11: {
                    block10: {
                        IClasspathEntry resolved = cp[i];
                        if (1 != resolved.getEntryKind()) break block10;
                        IPath jarPath = resolved.getPath().makeAbsolute();
                        if (removedApi && jarPath.toString().endsWith("WEB-INF/lib/jsf-api.jar") || removedImpl && jarPath.toString().endsWith("WEB-INF/lib/jsf-impl.jar")) break block11;
                    }
                    newCpList.add(cp[i]);
                }
                ++i;
            }
            javaProject.setRawClasspath(newCpList.toArray(new IClasspathEntry[0]), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {}
    }
}

