/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.wizard;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.support.dialogs.DialogUtil;
import com.ibm.etools.jsf.support.wizard.JsfWizardOperationBase;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ResourceUpdateDialog
extends Dialog {
    public static final int RESPONSE_YES = 10;
    public static final int RESPONSE_LATER = 11;
    public static final int RESPONSE_NEVER = 12;
    private String projectName;
    private List wizardOperations = Collections.EMPTY_LIST;
    private boolean rememberChoice = false;

    public ResourceUpdateDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite parent) {
        int pixels;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label projectLabel = new Label(composite, 64);
        String label = MessageFormat.format(Messages.MigrationDialog_Label, this.projectName);
        projectLabel.setText(label);
        GridData labelData = new GridData();
        labelData.widthHint = pixels = new Double((double)DialogUtil.getTextLenInPix(composite, label) / 2.5).intValue();
        projectLabel.setLayoutData((Object)labelData);
        Label taglibsLabel = new Label(composite, 0);
        taglibsLabel.setText(Messages.MigrationDialog_TaglibsLabel);
        this.createTaglibsComposite(composite);
        Label questionLabel = new Label(composite, 0);
        questionLabel.setText(Messages.MigrationDialog_QuestionLabel);
        new Label(composite, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.jsf.ResourceUpdateDialog");
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.WizardUtil_migrate_title);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(132));
        composite.setFont(parent.getFont());
        Button yesButton = this.createButton(composite, 10, Messages.MigrationDialog_Yes, true);
        Button laterButton = this.createButton(composite, 11, Messages.MigrationDialog_Later, false);
        Button neverButton = this.createButton(composite, 12, Messages.MigrationDialog_Never, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)yesButton, "com.ibm.etools.jsf.ResourceUpdateDialog");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)laterButton, "com.ibm.etools.jsf.ResourceUpdateDialog");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)neverButton, "com.ibm.etools.jsf.ResourceUpdateDialog");
        return composite;
    }

    protected void createTaglibsComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7) * 4;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        int i = 0;
        while (i < this.wizardOperations.size()) {
            String taglib = ExtensionRegistry.getRegistry().getTaglibUriForWizardId(((JsfWizardOperationBase)((Object)this.wizardOperations.get(i))).getWizardId());
            if (taglib == null) {
                taglib = ((JsfWizardOperationBase)((Object)this.wizardOperations.get(i))).getWizardId();
            }
            if (taglib != null) {
                Label l = new Label(composite, 0);
                l.setText(taglib);
            }
            ++i;
        }
    }

    public void setOperationsList(List list) {
        this.wizardOperations = list;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean getRememberChoice() {
        return this.rememberChoice;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (10 == buttonId || 11 == buttonId || 12 == buttonId) {
            this.setReturnCode(buttonId);
            this.close();
        }
    }
}

