/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.wizard;

import com.ibm.etools.common.migration.validation.framework.AbstractMigrationValidator;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.features.migration.util.FeaturesMigrationUtil;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JsfMigrationValidator
extends AbstractMigrationValidator {
    private static final String OLD_JSF_BASE = "jsf.base";
    private static final String OLD_JSF_RI = "jsf.ri";
    private static final String OLD_JSF_EXTENDED = "jsf.extended";
    private static final String OLD_JSF_RTE = "rte.base";
    private static final String OLD_JSF_ODC = "feature.odc.base";
    private static final String NEW_JSF_BASE = "jsf.base";
    private static final String NEW_JSF_RI = "jsf.ri";
    private static final String NEW_JSF_EXTENDED = "jsf.extended";
    private static final String NEW_JSF_RTE = "jsf.rte";
    private static final String NEW_JSF_ODC = "jsf.odc";

    protected void doValidate(IProject project, IProgressMonitor monitor) {
        try {
            IProjectFacet facet;
            IProjectFacetVersion facetVersion;
            IFacetedProject facetedProject;
            boolean isJsf;
            boolean bl = isJsf = project.hasNature("com.ibm.etools.jsf.JSFNature") || JsfProjectUtil.isJsfProject((IProject)project);
            if (!isJsf) {
                this.reportInformation(Messages.JsfMigrationValidator_not_JSF);
                return;
            }
            String[] allIds = FeaturesMigrationUtil.getProjectFeatures((IProject)project);
            String versionBase = "-1";
            String versionRi = "-1";
            String versionExtended = "-1";
            String versionRte = "-1";
            String versionOdc = "-1";
            int i = 0;
            while (i < allIds.length) {
                String versionString;
                String newVersionOdc;
                String id = allIds[i];
                if (id.startsWith("jsf.base")) {
                    String newVersionBase = this.extractVersion("jsf.base", id);
                    if (this.compareVersions(versionBase, newVersionBase) > 0) {
                        versionBase = newVersionBase;
                    }
                } else if (id.startsWith("jsf.ri")) {
                    String newVersionRi = this.extractVersion("jsf.ri", id);
                    if (this.compareVersions(versionRi, newVersionRi) > 0) {
                        versionRi = newVersionRi;
                    }
                } else if (id.startsWith("jsf.extended")) {
                    String newVersionExtended = this.extractVersion("jsf.extended", id);
                    if (this.compareVersions(versionExtended, newVersionExtended) > 0) {
                        versionExtended = newVersionExtended;
                    }
                } else if (id.startsWith(OLD_JSF_RTE)) {
                    String newVersionRte = this.extractVersion(OLD_JSF_RTE, id);
                    if (this.compareVersions(versionRte, newVersionRte) > 0) {
                        versionRte = newVersionRte;
                    }
                } else if (id.startsWith(OLD_JSF_ODC) && this.compareVersions(versionOdc, newVersionOdc = (versionString = this.extractVersion(OLD_JSF_ODC, id)).substring(0, versionString.length() / 2)) > 0) {
                    versionOdc = newVersionOdc;
                }
                ++i;
            }
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            Properties metaProps = component.getMetaProperties();
            if (!versionBase.equals("-1") && !metaProps.containsKey("jsf.base")) {
                this.reportError(MessageFormat.format(Messages.JsfMigrationValidator_missing_metadata, "jsf.base"));
            }
            if (!versionRi.equals("-1") && !metaProps.containsKey("jsf.ri")) {
                this.reportError(MessageFormat.format(Messages.JsfMigrationValidator_missing_metadata, "jsf.ri"));
            }
            if (!versionExtended.equals("-1") && !metaProps.containsKey("jsf.extended")) {
                this.reportError(MessageFormat.format(Messages.JsfMigrationValidator_missing_metadata, "jsf.extended"));
            }
            if (!versionRte.equals("-1") && !metaProps.containsKey(NEW_JSF_RTE)) {
                this.reportError(MessageFormat.format(Messages.JsfMigrationValidator_missing_metadata, NEW_JSF_RTE));
            }
            if (!versionOdc.equals("-1") && !metaProps.containsKey(NEW_JSF_ODC)) {
                this.reportError(MessageFormat.format(Messages.JsfMigrationValidator_missing_metadata, NEW_JSF_ODC));
            }
            if (!(facetedProject = ProjectFacetsManager.create((IProject)project)).hasProjectFacet(facetVersion = (facet = ProjectFacetsManager.getProjectFacet((String)"jsf.base")).getVersion("7.0"))) {
                this.reportError(MessageFormat.format(Messages.JsfMigrationValidator_facet_not_installed, "Faces (base)"));
            } else {
                this.reportSuccess(MessageFormat.format(Messages.JsfMigrationValidator_facet_installed, "Faces (base)"));
            }
            facet = ProjectFacetsManager.getProjectFacet((String)"jsf.ibm");
            facetVersion = facet.getVersion("7.0");
            if (!facetedProject.hasProjectFacet(facetVersion)) {
                this.reportInformation(MessageFormat.format(Messages.JsfMigrationValidator_facet_not_installed, "Faces (enhanced components)"));
            } else {
                this.reportSuccess(MessageFormat.format(Messages.JsfMigrationValidator_facet_installed, "Faces (enhanced components)"));
            }
        }
        catch (CoreException coreException) {}
    }

    public String getName() {
        return Messages.JsfMigrationValidator_JsfConsistency;
    }

    private String extractVersion(String oldFeatureId, String id) {
        if (id.equals(oldFeatureId)) {
            return "5.1.2";
        }
        String v6FeatureId = String.valueOf(oldFeatureId) + ".v600";
        if (id.startsWith(v6FeatureId)) {
            if (!id.equals(v6FeatureId)) {
                return id.substring(v6FeatureId.length() + 1);
            }
            return "6.0.0";
        }
        return "0.0";
    }

    private int compareVersions(String existing, String target) {
        StringTokenizer existingTokenizer = new StringTokenizer(existing, ".");
        String[] existingSegments = new String[4];
        int count = 0;
        while (existingTokenizer.hasMoreTokens()) {
            existingSegments[count++] = existingTokenizer.nextToken();
        }
        int i = count;
        while (i < 4) {
            existingSegments[i] = "0";
            ++i;
        }
        StringTokenizer targetTokenizer = new StringTokenizer(target, ".");
        String[] targetSegments = new String[4];
        count = 0;
        while (targetTokenizer.hasMoreTokens()) {
            targetSegments[count++] = targetTokenizer.nextToken();
        }
        int i2 = count;
        while (i2 < 4) {
            targetSegments[i2] = "0";
            ++i2;
        }
        try {
            int result = Integer.parseInt(targetSegments[0]) - Integer.parseInt(existingSegments[0]);
            if (result != 0) {
                return result;
            }
            result = Integer.parseInt(targetSegments[1]) - Integer.parseInt(existingSegments[1]);
            if (result != 0) {
                return result;
            }
            result = Integer.parseInt(targetSegments[2]) - Integer.parseInt(existingSegments[2]);
            if (result != 0) {
                return result;
            }
            return targetSegments[3].compareTo(existingSegments[3]);
        }
        catch (NumberFormatException numberFormatException) {
            return target.compareTo(existing);
        }
    }
}

