/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.wizard;

import com.ibm.etools.jsf.internal.wizard.WizardOperationUtils;
import com.ibm.etools.jsf.support.wizard.JsfWizardOperationBase;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IPrimaryRuntimeChangedEvent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.osgi.framework.Bundle;

public class JsfBaseFacetRuntimeChangedDelegate
implements IFacetedProjectListener {
    private static final String COMMONS_LOGGING = "/runtime/commons-logging.jar";
    private static final String RUNTIME_PLUGIN = "com.ibm.etools.jsf.util";
    private static boolean suspend = false;

    public void handleEvent(IFacetedProjectEvent facetedProjectEvent) {
        if (suspend) {
            return;
        }
        IProject project = facetedProjectEvent.getProject().getProject();
        if (!JsfProjectUtil.isJsfProject((IProject)project)) {
            return;
        }
        if (facetedProjectEvent.getType() == IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED) {
            IRuntime newRuntime;
            IFile commonsLogging;
            IFolder webInfLib;
            IPrimaryRuntimeChangedEvent event = (IPrimaryRuntimeChangedEvent)facetedProjectEvent;
            IRuntime oldRuntime = event.getOldPrimaryRuntime();
            if (this.isTomcat6Server(oldRuntime) && (webInfLib = (IFolder)JsfProjectUtil.getWebInfLibFolder((IProject)project)) != null && (commonsLogging = webInfLib.getFile("commons-logging.jar")).exists()) {
                try {
                    commonsLogging.delete(true, null);
                }
                catch (CoreException coreException) {}
            }
            if ((newRuntime = event.getNewPrimaryRuntime()) == null) {
                this.addJsfRiIfNecessary(project);
                return;
            }
            List runtimeComponents = newRuntime.getRuntimeComponents();
            Iterator componentsIter = runtimeComponents.iterator();
            boolean hasWASImpl = false;
            while (componentsIter.hasNext()) {
                IRuntimeComponent component = (IRuntimeComponent)componentsIter.next();
                if (!"com.ibm.ws.ast.st.runtime".equals(component.getRuntimeComponentType().getId()) || !"6.0".equals(component.getRuntimeComponentVersion().getVersionString()) && !"6.1".equals(component.getRuntimeComponentVersion().getVersionString()) && !"7.0".equals(component.getRuntimeComponentVersion().getVersionString())) continue;
                hasWASImpl = true;
                break;
            }
            if (!hasWASImpl) {
                this.addJsfRiIfNecessary(project);
            }
            for (IRuntimeComponent component : runtimeComponents) {
                if (!"com.ibm.ws.ast.st.runtime".equals(component.getRuntimeComponentType().getId()) || !"7.0".equals(component.getRuntimeComponentVersion().getVersionString())) continue;
                WizardOperationUtils.removeRiJarsFromWAS7Project(project);
            }
            if (!JsfProjectUtil.hasJsf12Facet((IProject)project) && this.isTomcat6Server(newRuntime)) {
                try {
                    IFile commonsLogging2;
                    String sourcePath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)RUNTIME_PLUGIN), (IPath)new Path(COMMONS_LOGGING), null)).getPath().toString();
                    IFolder webInfLib2 = (IFolder)JsfProjectUtil.getWebInfLibFolder((IProject)project);
                    if (webInfLib2 != null && !(commonsLogging2 = webInfLib2.getFile("commons-logging.jar")).exists()) {
                        File sourceFile = new File(sourcePath);
                        FileInputStream sourceStream = new FileInputStream(sourceFile);
                        commonsLogging2.create((InputStream)sourceStream, true, null);
                    }
                }
                catch (IOException iOException) {
                }
                catch (CoreException coreException) {}
            }
        }
    }

    private void addJsfRiIfNecessary(IProject project) {
        if (!JsfProjectUtil.isJsfImplInProject((IProject)project)) {
            JsfWizardOperationBase apiOp = WizardUtil.getWizardOperation("jsf.base", project);
            JsfWizardOperationBase riOp = WizardUtil.getWizardOperation("jsf.ri", project);
            try {
                apiOp.run((IProgressMonitor)new NullProgressMonitor());
                riOp.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean isTomcat6Server(IRuntime runtime) {
        boolean isTomcat6Server = false;
        if (runtime == null) {
            return false;
        }
        List runtimeComponents = runtime.getRuntimeComponents();
        for (IRuntimeComponent component : runtimeComponents) {
            String runtimeId = component.getRuntimeComponentType().getId();
            String runtimeVersion = component.getRuntimeComponentVersion().getVersionString();
            if (!"org.eclipse.jst.server.tomcat".equals(runtimeId) || !"6.0".equals(runtimeVersion)) continue;
            isTomcat6Server = true;
            break;
        }
        return isTomcat6Server;
    }

    public static void suspend() {
        suspend = true;
    }

    public static void resume() {
        suspend = false;
    }
}

