/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.wizard;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class AbstractResourceInstallOperation
extends WTPOperation {
    public static final String LIB_DIR = "/WEB-INF/lib";
    public static final String CLASSES_DIR = "/WEB-INF/classes";
    public static final String WEBCONTENT_DIR = "";
    private IProject targetProject;
    private Map<String, String> directoryCopyMap = new HashMap<String, String>();
    private IDataModel dataModel;

    public IProject getTargetProject() {
        return this.targetProject;
    }

    public void setTargetProject(IProject targetProject) {
        this.targetProject = targetProject;
    }

    protected IDataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    protected abstract String getWizardId();

    protected abstract String getRuntimeVersion();

    protected final void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Debug.trace("[wiz] executing " + ((Object)((Object)this)).getClass().getName() + " in " + this.targetProject.getName(), "wizard");
        this.doBeforeResourceCopy(monitor);
        this.doResourceCopy();
        this.doAfterResourceCopy(monitor);
        this.markProject(this.getWizardId(), this.getRuntimeVersion());
    }

    protected void addWizardDirectoryMapping(String sourcePath, String targetPath) {
        this.directoryCopyMap.put(sourcePath, targetPath);
    }

    protected void removeWizardDirectoryMapping(String sourcePath) {
        this.directoryCopyMap.remove(sourcePath);
    }

    protected void doBeforeResourceCopy(IProgressMonitor monitor) {
    }

    private final void doResourceCopy() {
        IPath webContentPath = ComponentCore.createComponent((IProject)this.targetProject).getRootFolder().getUnderlyingFolder().getFullPath();
        for (String sourcePath : this.directoryCopyMap.keySet()) {
            if (sourcePath.equals(this.directoryCopyMap.get(sourcePath))) {
                Debug.trace("[wiz] copyTree - source and target paths are identical, ignoring mapping: " + sourcePath, "wizard");
                continue;
            }
            File sourceDir = new File(sourcePath);
            IPath targetPath = webContentPath.append(this.directoryCopyMap.get(sourcePath));
            Debug.trace("[wiz] copyTree - " + sourceDir + " -> " + targetPath, "wizard");
            this.copyTree(sourceDir, targetPath);
        }
    }

    protected void doAfterResourceCopy(IProgressMonitor monitor) {
    }

    private void markProject(String wizardId, String runtimeVersion) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getTargetProject());
        component.setMetaProperty(wizardId, runtimeVersion);
    }

    protected final void copyTree(File sourceDir, IPath targetPath) {
        try {
            if (sourceDir.exists()) {
                File[] srcFiles = sourceDir.isDirectory() ? sourceDir.listFiles() : new File[]{sourceDir};
                IPath webInfLibPath = JsfProjectUtil.getWebInfFolder((IProject)this.getTargetProject()).getFullPath();
                if (webInfLibPath.segmentCount() == webInfLibPath.matchingFirstSegments(targetPath)) {
                    System.err.println("copying into WEB-INF/lib for: " + sourceDir.toString());
                }
                int i = 0;
                while (i < srcFiles.length) {
                    File srcFile = srcFiles[i];
                    if (srcFile.isFile()) {
                        IFile copyFile = this.getWorkspace().getRoot().getFile(targetPath.append(srcFile.getName()));
                        FileInputStream sourceStream = new FileInputStream(srcFile);
                        if (!copyFile.exists()) {
                            this.createFolderIfNecessary((IFolder)copyFile.getParent());
                            copyFile.create((InputStream)sourceStream, true, null);
                        } else if (srcFile.getName().endsWith(".css")) {
                            this.mergeCssFile(srcFile, copyFile);
                        } else {
                            copyFile.setContents((InputStream)sourceStream, true, false, null);
                        }
                        sourceStream.close();
                    } else if (srcFile.isDirectory()) {
                        IFolder packageDirFolder = this.getWorkspace().getRoot().getFolder(targetPath.append(srcFile.getName()));
                        this.createFolderIfNecessary(packageDirFolder);
                        this.copyTree(srcFile, targetPath.append(srcFile.getName()));
                    }
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    private void createFolderIfNecessary(IFolder folder) {
        if (!folder.exists()) {
            this.createFolderIfNecessary((IFolder)folder.getParent());
            try {
                folder.create(true, true, null);
            }
            catch (CoreException coreException) {}
        }
    }

    protected boolean checkExistingResources() {
        IPath webContentPath = ComponentCore.createComponent((IProject)this.targetProject).getRootFolder().getUnderlyingFolder().getFullPath();
        for (String sourcePath : this.directoryCopyMap.keySet()) {
            IPath targetPath;
            File sourceDir = new File(sourcePath);
            if (this.checkExistingTree(sourceDir, targetPath = webContentPath.append(this.directoryCopyMap.get(sourcePath)))) continue;
            return false;
        }
        return true;
    }

    protected boolean checkExistingTree(File sourceDir, IPath targetPath) {
        if (sourceDir.exists()) {
            File[] srcFiles = sourceDir.isDirectory() ? sourceDir.listFiles() : new File[]{sourceDir};
            int i = 0;
            while (i < srcFiles.length) {
                File srcFile = srcFiles[i];
                if (srcFile.isFile()) {
                    IFile copyFile = this.getWorkspace().getRoot().getFile(targetPath.append(srcFile.getName()));
                    if (!copyFile.exists()) {
                        return false;
                    }
                } else if (srcFile.isDirectory()) {
                    IFolder packageDirFolder = this.getWorkspace().getRoot().getFolder(targetPath.append(srcFile.getName()));
                    if (!packageDirFolder.exists()) {
                        return false;
                    }
                    if (!this.checkExistingTree(srcFile, targetPath.append(srcFile.getName()))) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public void doDelete(IProgressMonitor monitor) {
        Debug.trace("[wiz] doDelete: " + ((Object)((Object)this)).getClass().getName() + " in " + this.targetProject.getName(), "wizard");
        this.doBeforeResourceDelete(monitor);
        this.doResourceDelete(monitor);
        this.doAfterResourceDelete(monitor);
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getTargetProject());
        component.setMetaProperty(this.getWizardId(), null);
    }

    protected void doBeforeResourceDelete(IProgressMonitor monitor) {
    }

    protected final void doResourceDelete(IProgressMonitor monitor) {
        IPath webContentPath = ComponentCore.createComponent((IProject)this.targetProject).getRootFolder().getUnderlyingFolder().getFullPath();
        Set<Map.Entry<String, String>> entries = this.directoryCopyMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String sourcePath = entry.getKey();
            Path srcPath = new Path(sourcePath);
            IPath targetPath = webContentPath.append(entry.getValue());
            this.removeTree((IPath)srcPath, targetPath);
        }
    }

    protected void doAfterResourceDelete(IProgressMonitor monitor) {
    }

    protected final void removeTree(IPath sourcePath, IPath targetPath) {
        File sourceFile = sourcePath.toFile();
        File targetFile = targetPath.toFile();
        if (!sourceFile.exists() || !targetFile.exists()) {
            return;
        }
        if (sourceFile.isFile()) {
            targetFile.delete();
            return;
        }
        File[] fileList = sourceFile.listFiles();
        if (fileList == null) {
            return;
        }
        int i = 0;
        while (i < fileList.length) {
            File child = fileList[i];
            String name = child.getName();
            IPath childSource = sourcePath.append(name);
            IPath childTarget = targetPath.append(name);
            this.removeTree(childSource, childTarget);
            ++i;
        }
        String[] list = targetFile.list();
        if (list == null || list.length == 0) {
            targetFile.delete();
        }
    }

    protected void mergeCssFile(File sourceFile, IFile targetFile) {
        IModelManager manager = StructuredModelManager.getModelManager();
        try {
            ArrayList<String> existingRuleNames = new ArrayList<String>();
            IStructuredModel targetModel = manager.getModelForEdit(targetFile);
            ICSSDocument targetDoc = ((ICSSModel)targetModel).getDocument();
            ICSSNode node = targetDoc.getFirstChild();
            while (node != null) {
                if (node instanceof ICSSStyleRule) {
                    Iterator selectorsIter = ((ICSSStyleRule)node).getSelectors().getIterator();
                    while (selectorsIter.hasNext()) {
                        ICSSSelector selector = (ICSSSelector)selectorsIter.next();
                        existingRuleNames.add(selector.getString());
                    }
                }
                node = node.getNextSibling();
            }
            FileInputStream sourceStream = new FileInputStream(sourceFile);
            IStructuredModel sourceModel = manager.getModelForRead(sourceFile.getName(), (InputStream)sourceStream, null);
            ICSSDocument sourceDoc = ((ICSSModel)sourceModel).getDocument();
            node = sourceDoc.getFirstChild();
            while (node != null) {
                if (node instanceof ICSSStyleRule) {
                    Iterator selectorsIter = ((ICSSStyleRule)node).getSelectors().getIterator();
                    while (selectorsIter.hasNext()) {
                        ICSSSelector selector = (ICSSSelector)selectorsIter.next();
                        if (existingRuleNames.contains(selector.getString())) continue;
                        ICSSStyleRule newRule = targetDoc.createCSSStyleRule();
                        CSSStyleDeclaration sourceDecl = ((ICSSStyleRule)node).getStyle();
                        int i = 0;
                        while (i < sourceDecl.getLength()) {
                            String propName = sourceDecl.item(i);
                            String propValue = sourceDecl.getPropertyValue(propName);
                            String propPriority = sourceDecl.getPropertyPriority(propName);
                            newRule.getStyle().setProperty(propName, propValue, propPriority);
                            ++i;
                        }
                        newRule.setSelectorText(selector.getString());
                        ((ICSSStyleSheet)targetDoc).appendRule((CSSRule)newRule);
                    }
                }
                node = node.getNextSibling();
            }
            targetModel.save();
            targetModel.releaseFromEdit();
            sourceModel.releaseFromRead();
        }
        catch (Throwable throwable) {}
    }
}

