/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.visualizer.generic;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.visualizer.generic.GenericVisualizer;
import com.ibm.etools.jsf.internal.visualizer.generic.templates.VisualizationTemplateGenerator;
import com.ibm.etools.jsf.support.vct.VctBase;
import com.ibm.etools.jsf.support.visualization.Visualizer;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.webedit.taglib.design.DesignTimeTagAdapter;
import com.ibm.etools.webedit.taglib.vct.VTDManager;
import com.ibm.etools.webedit.vct.CustomTagVisualizer;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UserDefinedVisualizationUtil {
    private UserDefinedVisualizationUtil() {
    }

    public static String processTemplate(Node domNode, String template) {
        VisualizationTemplateGenerator generator = new VisualizationTemplateGenerator(domNode, template);
        String result = generator.resolve();
        return result;
    }

    private static Node findChildrenMarkerNode(Node topNode) {
        NodeList childrenMarkerNodes;
        if (topNode.getNodeType() == 1 && (childrenMarkerNodes = ((Element)topNode).getElementsByTagName("CHILDREN")).getLength() > 0) {
            return childrenMarkerNodes.item(0);
        }
        return null;
    }

    private static NodeList findChildMarkerNodes(Node topNode) {
        return ((Element)topNode).getElementsByTagName("CHILD");
    }

    public static void replaceChildren(Node topNode, NodeList children) {
        ArrayList<Node> childrenToCopy = new ArrayList<Node>();
        Node childrenMarker = UserDefinedVisualizationUtil.findChildrenMarkerNode(topNode);
        if (childrenMarker != null) {
            Node insertionParent = childrenMarker.getParentNode();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (!JsfComponentUtil.isFacetTag((Node)child)) {
                    childrenToCopy.add(child);
                }
                ++i;
            }
            for (Node child : childrenToCopy) {
                insertionParent.insertBefore(child, childrenMarker);
            }
            insertionParent.removeChild(childrenMarker);
        } else {
            NodeList childMarkers = UserDefinedVisualizationUtil.findChildMarkerNodes(topNode);
            HashMap<Element, Node> markerToRealNodesMap = new HashMap<Element, Node>();
            int i = 0;
            while (i < childMarkers.getLength()) {
                Element childInsertionEl = (Element)childMarkers.item(i);
                String numStr = childInsertionEl.getAttribute("num");
                int num = Integer.parseInt(numStr);
                markerToRealNodesMap.put(childInsertionEl, children.item(num));
                ++i;
            }
            i = 0;
            while (i < childMarkers.getLength()) {
                Node childMarker = childMarkers.item(i);
                Node insertionParent = childMarker.getParentNode();
                Node realNode = (Node)markerToRealNodesMap.get(childMarker);
                insertionParent.insertBefore(realNode, childMarker);
                insertionParent.removeChild(childMarker);
                ++i;
            }
        }
    }

    public static void replaceFacets(Node visualizationTopNode, Node realNode) {
        NodeList facetMarkers = ((Element)visualizationTopNode).getElementsByTagName("FACET");
        int i = 0;
        while (i < facetMarkers.getLength()) {
            Element facetMarker = (Element)facetMarkers.item(i);
            String facetName = facetMarker.getAttribute("name");
            if (facetName != null) {
                Node facetChild = UserDefinedVisualizationUtil.findFacetChild(realNode, facetName);
                if (facetChild != null) {
                    Node span = UserDefinedVisualizationUtil.createFacetSpan(facetMarker, facetName);
                    span.appendChild(facetChild);
                    facetMarker.getParentNode().insertBefore(span, facetMarker);
                } else if (UserDefinedVisualizationUtil.hasFacetNode(realNode, facetName)) {
                    UserDefinedVisualizationUtil.createFacetDropText(facetMarker, facetName);
                }
            }
            facetMarker.getParentNode().removeChild(facetMarker);
            ++i;
        }
    }

    public static boolean hasFacetNode(Node node, String facetName) {
        if (node == null || facetName == null) {
            return false;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String name;
            Node child = children.item(i);
            if (JsfComponentUtil.isFacetTag((Node)child) && facetName.equals(name = ((Element)child).getAttribute("name"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Node findFacetChild(Node node, String facetName) {
        if (node == null || facetName == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String name;
            Node child = children.item(i);
            if (JsfComponentUtil.isFacetTag((Node)child) && facetName.equals(name = ((Element)child).getAttribute("name"))) {
                NodeList facetChildren = child.getChildNodes();
                int j = 0;
                while (j < facetChildren.getLength()) {
                    Node facetChild = facetChildren.item(j);
                    if (facetChild.getNodeType() == 1) {
                        return facetChild;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static Node createFacetSpan(Node facetMarker, String facetName) {
        Element span = facetMarker.getOwnerDocument().createElement("SPAN");
        span.setAttribute("dnd.facetname", facetName);
        facetMarker.getParentNode().insertBefore(span, facetMarker);
        return span;
    }

    public static void createFacetDropText(Node facetMarker, String facetName) {
        Node span = UserDefinedVisualizationUtil.createFacetSpan(facetMarker, facetName);
        Text text = facetMarker.getOwnerDocument().createTextNode(Messages.FACET_NO_CONTENT);
        span.appendChild(text);
    }

    public static GenericVisualizer getVisualizer(Node node) {
        Visualizer visualizer;
        CustomTagVisualizer vct;
        Node realNode = UserDefinedVisualizationUtil.getRealNode(node);
        DesignTimeTagAdapter vctAdapter = (DesignTimeTagAdapter)((IDOMNode)realNode).getAdapterFor(DesignTimeTagAdapter.class);
        if (vctAdapter != null && (vct = vctAdapter.getCustomTagVisualizer()) != null && vct instanceof VctBase && (visualizer = ((VctBase)vct).getVisualizer()) instanceof GenericVisualizer) {
            return (GenericVisualizer)visualizer;
        }
        return null;
    }

    private static Node getRealNode(Node node) {
        VTDManager manager = (VTDManager)((IDOMNode)node.getOwnerDocument()).getAdapterFor(VTDManager.class);
        if (manager != null) {
            HashMap nodeMap = manager.getNodeManager(null).getNodeMap();
            Node realNode = (Node)nodeMap.get(node);
            if (realNode == null) {
                return node;
            }
            return realNode;
        }
        return null;
    }

    public static boolean isMarkerNode(Node node) {
        String nodeName = node.getNodeName();
        return "CHILDREN".equals(nodeName) || "CHILD".equals(nodeName) || "FACET".equals(nodeName);
    }
}

