/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.visualizer.generic;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.visualizer.generic.UserDefinedVisualizationUtil;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.TagLibraryType;
import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.emf.VisualizationType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.support.visualization.VisualizerBase;
import com.ibm.etools.jsf.support.visualization.VisualizerUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.JsfRenderingUtil;
import com.ibm.etools.jsf.util.RendererResults;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.commands.utils.ImportSource;
import com.ibm.etools.webedit.vct.Context;
import com.ibm.etools.webedit.vct.VisualizerReturnCode;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class GenericVisualizer
extends VisualizerBase {
    public static final short MODE_BOX = 1;
    public static final short MODE_RENDERER = 2;
    public static final short MODE_USER_PROVIDED = 3;
    private Node node;
    private int activeChildIndex = -1;
    private short mode = (short)2;
    private boolean isRendererError = false;
    private String userVisualizationTemplate = null;

    public GenericVisualizer(Node n) {
        this.node = n;
        this.checkForUserDefinedVisualization();
    }

    @Override
    public VisualizerReturnCode doStart(Context context) throws IOException {
        Node self = context.getSelf();
        RendererResults results = null;
        if (this.mode == 2 && (results = JsfRenderingUtil.calculateVisualization((Node)self, (IProject)JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)this.getNode().getOwnerDocument())))).isRenderingError()) {
            this.mode = 1;
            this.isRendererError = true;
        }
        switch (this.mode) {
            case 1: {
                Node topNode = this.getGrayBox(context);
                NodeList children = self.getChildNodes();
                try {
                    while (children.getLength() > 0) {
                        topNode.appendChild(children.item(0));
                    }
                }
                catch (Exception exception) {}
                context.putVisual(topNode);
                break;
            }
            case 2: {
                if (!this.rendersChildren()) {
                    Node topNode = this.makeNodeFromString(results.getOutputString(), context, true);
                    NodeList children = self.getChildNodes();
                    try {
                        while (children.getLength() > 0) {
                            topNode.appendChild(children.item(0));
                        }
                    }
                    catch (Exception exception) {}
                    context.putVisual(topNode);
                    break;
                }
                this.doRendersChildrenCase(results, context);
                break;
            }
            case 3: {
                if (this.userVisualizationTemplate == null) break;
                String visualization = UserDefinedVisualizationUtil.processTemplate(self, this.userVisualizationTemplate);
                Node topNode = this.makeNodeFromString(visualization, context, false);
                try {
                    if (UserDefinedVisualizationUtil.isMarkerNode(topNode) || topNode.getNodeType() == 3) {
                        Element spanNode = topNode.getOwnerDocument().createElement("SPAN");
                        spanNode.appendChild(topNode);
                        topNode = spanNode;
                    }
                    UserDefinedVisualizationUtil.replaceChildren(topNode, self.getChildNodes());
                    UserDefinedVisualizationUtil.replaceFacets(topNode, self);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                context.putVisual(topNode);
            }
        }
        return VisualizerReturnCode.OK;
    }

    protected boolean rendersChildren() {
        return JsfRenderingUtil.getRendersChildren((Node)this.getNode());
    }

    protected Node getNode() {
        return this.node;
    }

    public void setActiveChildIndex(int index) {
        this.activeChildIndex = index;
    }

    public int getActiveChildIndex() {
        return this.activeChildIndex;
    }

    protected Node makeNodeFromString(String output, Context context, boolean checkErrors) {
        Document doc = context.getDocument();
        ImportSource source = new ImportSource(doc, null);
        if (source == null) {
            return null;
        }
        source.doFixup(false);
        DocumentFragment fragment = source.getFragment(output);
        NodeList childNodes = fragment.getChildNodes();
        if (checkErrors) {
            if (childNodes.getLength() == 0) {
                return this.getGrayBox(context);
            }
            if (childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3 && childNodes.item(0).getNodeValue().trim().equals("")) {
                return this.getGrayBox(context);
            }
            if (this.checkInvalidHtml(fragment)) {
                return this.getGrayBox(context);
            }
            if (this.checkInvisibleRendering(fragment)) {
                return this.getGrayBox(context);
            }
        }
        if (childNodes.getLength() == 1) {
            return childNodes.item(0);
        }
        Element newParent = doc.createElement("span");
        while (childNodes.getLength() != 0) {
            newParent.insertBefore(childNodes.item(0), null);
        }
        return newParent;
    }

    private boolean checkInvalidHtml(Node topNode) {
        Node table = this.findTable(topNode);
        return table != null && !this.hasChildTD(table);
    }

    private boolean checkInvisibleRendering(Node topNode) {
        if (topNode.getNodeType() == 11) {
            NodeList childNodes = topNode.getChildNodes();
            boolean hasVisibleChild = false;
            int i = 0;
            while (i < childNodes.getLength()) {
                if (!this.checkInvisibleRendering(childNodes.item(i))) {
                    hasVisibleChild = true;
                }
                ++i;
            }
            return !hasVisibleChild;
        }
        if (topNode.getNodeType() == 1) {
            if ("SPAN".equalsIgnoreCase(topNode.getNodeName())) {
                boolean hasVisibleChild = false;
                NodeList childNodes = topNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node child = childNodes.item(i);
                    if (!this.checkInvisibleRendering(child)) {
                        hasVisibleChild = true;
                    }
                    ++i;
                }
                return !hasVisibleChild;
            }
            if ("TABLE".equalsIgnoreCase(topNode.getNodeName())) {
                boolean hasVisibleChild = false;
                NodeIterator iter = ((DocumentTraversal)((Object)topNode.getOwnerDocument())).createNodeIterator(topNode, 1, null, false);
                Node node = iter.nextNode();
                while (node != null) {
                    if ("TH".equalsIgnoreCase(node.getNodeName()) || "TD".equalsIgnoreCase(node.getNodeName())) {
                        NodeList childNodes = node.getChildNodes();
                        int i = 0;
                        while (i < childNodes.getLength()) {
                            Node child = childNodes.item(i);
                            if (!this.checkInvisibleRendering(child)) {
                                hasVisibleChild = true;
                            }
                            ++i;
                        }
                    }
                    node = iter.nextNode();
                }
                return !hasVisibleChild;
            }
        } else if (topNode.getNodeType() == 3 && "".equals(topNode.getNodeValue().trim())) {
            return true;
        }
        return false;
    }

    private Node findTable(Node topNode) {
        DocumentTraversal docTraversal = (DocumentTraversal)((Object)JsfCommandUtil.getDocument(topNode));
        NodeIterator iterator = docTraversal.createNodeIterator(topNode, 1, null, false);
        Node temp = iterator.nextNode();
        while (temp != null) {
            if ("TABLE".equalsIgnoreCase(temp.getNodeName())) {
                return temp;
            }
            temp = iterator.nextNode();
        }
        return null;
    }

    private boolean hasChildTD(Node table) {
        DocumentTraversal docTraversal = (DocumentTraversal)((Object)JsfCommandUtil.getDocument(table));
        NodeIterator iterator = docTraversal.createNodeIterator(table, 1, null, false);
        Node temp = iterator.nextNode();
        while (temp != null) {
            if ("TD".equalsIgnoreCase(temp.getNodeName())) {
                return true;
            }
            temp = iterator.nextNode();
        }
        return false;
    }

    protected void doRendersChildrenCase(RendererResults results, Context context) {
        String output = results.getOutputString();
        Node topNode = this.makeNodeFromString(output, context, true);
        this.restoreChildJsfNodes(topNode, results.getChildNodes());
        context.putVisual(topNode);
    }

    private void restoreChildJsfNodes(Node topNode, List childJsfNodes) {
        Node tempNode;
        NodeIterator iterator = ((DocumentTraversal)((Object)topNode.getOwnerDocument())).createNodeIterator(topNode, 1, null, false);
        while ((tempNode = iterator.nextNode()) != null) {
            String indexString;
            if (!"JSFVIS".equalsIgnoreCase(tempNode.getNodeName()) || (indexString = ((Element)tempNode).getAttribute("i")) == null) continue;
            int index = Integer.parseInt(indexString);
            tempNode.getParentNode().replaceChild((Node)childJsfNodes.get(index), tempNode);
        }
    }

    private Node getGrayBox(Context context) {
        Document doc = context.getDocument();
        Element inputEl = doc.createElement("INPUT");
        Element realNode = (Element)this.getNode();
        String styleAttr = realNode.getAttribute("style");
        String classAttr = realNode.getAttribute("class");
        String path = VisualizerUtil.getFullFilePath(JsfPlugin.getDefault().getBundle(), "icons/component.gif");
        String style = "color: gray; font-size: 11px; margin: padding:0px; padding-left: 12px; border-style: solid; border-width: 1px; border-color: #B8B8B8; 0px; background-color: #C8C8C0; background-position: left top; background-repeat: no-repeat; background-image: url(\"" + path + "\")";
        if (styleAttr != null) {
            style = styleAttr.trim().endsWith(";") ? String.valueOf(styleAttr) + style : String.valueOf(styleAttr) + ";" + style;
        }
        inputEl.setAttribute("value", realNode.getNodeName());
        inputEl.setAttribute("style", style);
        if (classAttr != null) {
            inputEl.setAttribute("class", classAttr);
        }
        if (!this.rendersChildren()) {
            return inputEl;
        }
        Element outerSpan = doc.createElement("SPAN");
        outerSpan.appendChild(inputEl);
        return outerSpan;
    }

    public void setVisualizerMode(short mode) {
        this.mode = mode;
    }

    public short getVisualizerMode() {
        return this.mode;
    }

    public boolean isRendererError() {
        return this.isRendererError;
    }

    public void setUserVisualization(String userOutput) {
        this.userVisualizationTemplate = userOutput;
    }

    protected void checkForUserDefinedVisualization() {
        LibraryDefinitionType libraryDefinition;
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)this.node.getOwnerDocument());
        String taglibUri = mapper.getUriForPrefix(this.node.getPrefix());
        if (taglibUri != null && (libraryDefinition = LibraryManager.getInstance().getLibraryDefinitionModel(taglibUri)) != null) {
            String tagName = this.node.getLocalName();
            TagLibraryType tagsType = libraryDefinition.getTagLibrary();
            if (tagsType != null) {
                for (TagType tag : tagsType.getTag()) {
                    String visTemplate;
                    VisualizationType vis;
                    if (!tagName.equals(tag.getName()) || (vis = tag.getVisualization()) == null || (visTemplate = vis.getMarkup()) == null || visTemplate.equals("")) continue;
                    this.setUserVisualization(visTemplate.trim());
                    this.setVisualizerMode((short)3);
                    return;
                }
            }
        }
    }

    @Override
    public VisualizerReturnCode handleEvent(Context context) {
        Node node;
        Range range = context.getRange();
        if (range != null && (node = range.getEndContainer()) != null) {
            String childIdStr;
            while (node.getNodeType() != 1) {
                if ((node = node.getParentNode()) != null) continue;
                return VisualizerReturnCode.IGNORE;
            }
            if (("TH".equalsIgnoreCase(node.getNodeName()) || "TD".equalsIgnoreCase(node.getNodeName())) && "STACK".equals(((Element)node).getAttribute("origin")) && (childIdStr = ((Element)node).getAttribute("childNum")) != null) {
                try {
                    int childId = Integer.parseInt(childIdStr);
                    this.setActiveChildIndex(childId);
                    context.refresh();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return super.handleEvent(context);
    }
}

