/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.vct.dnd;

import com.ibm.etools.jsf.palette.commands.EditNodeAttributesCommand;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.commands.utils.AttributeList;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.common.utils.FileTypeUtil;
import com.ibm.etools.webedit.extension.DropTargetObject;
import com.ibm.etools.webedit.extension.IDropVisualAction;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JsfFileDropAction
implements IDropVisualAction {
    private static final String FILEURLSCHEME = "file";
    private static final String URLCOLON = ":";
    private static final String FILEURLPREFIX = "file://";
    private static final String URLSEPARATOR = "/";

    public DropTargetObject getDropTargetObject(DropTargetEvent event, IEditorPart targetEditor, EditPartViewer viewer) {
        return null;
    }

    public boolean isSupportedData(Object obj) {
        return true;
    }

    public boolean run(DropTargetEvent event, IEditorPart editor) {
        ISourceEditingTextTools tools = (ISourceEditingTextTools)editor.getAdapter(ISourceEditingTextTools.class);
        if (tools != null) {
            IDOMModel model;
            int offset = tools.getSelection().getOffset();
            Node target = null;
            HTMLEditDomain domain = (HTMLEditDomain)editor.getAdapter(HTMLEditDomain.class);
            if (domain != null && (model = domain.getActiveModel()) != null) {
                IndexedRegion iNode = model.getIndexedRegion(offset);
                if (iNode == null) {
                    iNode = model.getIndexedRegion(offset - 1);
                }
                if (iNode instanceof Node) {
                    target = (Node)iNode;
                }
            }
            if (target == null) {
                return false;
            }
            if (target.getNodeType() != 1) {
                return false;
            }
            if (JsfComponentUtil.isJsfTag((Node)target)) {
                Document d = JsfCommandUtil.getDocument(target);
                String targetTaglibUri = TaglibPrefixUtil.getMapperUtil((Document)d).getUriForPrefix(target.getPrefix());
                String targetTagName = target.getLocalName();
                if ("http://java.sun.com/jsf/core".equals(targetTaglibUri) ? "view".equals(targetTagName) || "subview".equals(targetTagName) : ("http://java.sun.com/jsf/html".equals(targetTaglibUri) ? "form".equals(targetTagName) : "http://www.ibm.com/jsf/html_extended".equals(targetTaglibUri) && ("jspPanel".equals(targetTagName) || "scriptCollector".equals(targetTagName) || "viewFragment".equals(targetTagName)))) {
                    return false;
                }
                EditModelQuery editQuery = EditQueryUtil.getEditQuery((Node)target.getOwnerDocument());
                Path path = new Path(((String[])event.data)[0]);
                if (path.toFile().isDirectory()) {
                    return false;
                }
                String fileurl = this.getURL((IPath)path);
                HTMLEditDomain editDomain = ActionUtil.getActiveHTMLEditDomain();
                IDOMModel model2 = editDomain.getActiveModel();
                HTMLSubModelContext subContext = editDomain.getActiveSubModelContext();
                AttributeList list = new AttributeList();
                list.pushUrlAttribute("src", fileurl);
                list.doFixup("IMG", (IStructuredModel)model2, subContext, null);
                String value = list.getValue("src");
                int filetype = FileTypeUtil.whatKindOfFile((IPath)path);
                switch (filetype) {
                    case 2: {
                        if (editQuery.isAttributeAvailable((Element)target, "image")) {
                            EditNodeAttributesCommand cmd = new EditNodeAttributesCommand(target, "image", value);
                            if (ActionUtil.getActiveHTMLEditDomain() != null) {
                                ActionUtil.getActiveHTMLEditDomain().execCommand((Command)cmd);
                            }
                        } else if (editQuery.isAttributeAvailable((Element)target, "value")) {
                            EditNodeAttributesCommand cmd = new EditNodeAttributesCommand(target, "value", value);
                            if (ActionUtil.getActiveHTMLEditDomain() != null) {
                                ActionUtil.getActiveHTMLEditDomain().execCommand((Command)cmd);
                            }
                        }
                        return true;
                    }
                    case 20: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        if (editQuery.isAttributeAvailable((Element)target, "src")) {
                            EditNodeAttributesCommand cmd = new EditNodeAttributesCommand(target, "src", value);
                            if (ActionUtil.getActiveHTMLEditDomain() != null) {
                                ActionUtil.getActiveHTMLEditDomain().execCommand((Command)cmd);
                            }
                        }
                        return true;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private String getURL(IPath path) {
        char second;
        char first;
        if (path.isUNC()) {
            return "file:" + path.toString();
        }
        String device = path.getDevice();
        if (device != null && device.length() == 2 && path.isAbsolute() && Character.isLetter(first = device.charAt(0)) && (second = device.charAt(1)) == ':') {
            return "file:///" + path.toString();
        }
        return FILEURLPREFIX + path.toString();
    }
}

