/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.library.editor;

import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.TaglibDependencies;
import com.ibm.etools.jsf.util.TextNodeUtil;
import java.util.HashMap;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateEditHelper {
    public static final int PARENT = 0;
    public static final int CHILD = 1;

    private TemplateEditHelper() {
    }

    public static void generateId(Element el) {
        Element libElement = (Element)el.getParentNode().getParentNode();
        String uri = libElement.getAttribute("taglib-uri");
        if (uri == null) {
            uri = "custom";
        }
        String id = String.valueOf(uri) + ":" + System.currentTimeMillis();
        el.setAttribute("id", id);
    }

    public static DataTemplate fillTemplateObject(String context, Node closestAncestor) {
        Node text;
        Node text2;
        Element template = (Element)closestAncestor;
        String name = template.getAttribute("name");
        if (name == null) {
            name = "";
        }
        String id = template.getAttribute("id");
        if ("jsf_iterative".equals(context)) {
            id = String.valueOf(id) + "_iterative";
        }
        if (id == null) {
            id = "";
        }
        String type = template.getAttribute("data-type");
        if ("jsf_iterative".equals(context)) {
            type = template.getAttribute("id");
        }
        if (type == null) {
            type = "";
        }
        boolean input = "true".equals(template.getAttribute("input"));
        boolean defaultTemplate = "true".equals(template.getAttribute("default"));
        boolean enabled = "true".equals(template.getAttribute("enabled"));
        String description = null;
        NodeList descriptions = template.getElementsByTagName("description");
        if (descriptions.getLength() > 0 && (text2 = TextNodeUtil.findChildTextNode((Node)descriptions.item(0))) != null) {
            description = text2.getNodeValue();
        }
        if (description == null) {
            description = "";
        }
        String pattern = null;
        NodeList patterns = null;
        if ("jsf_property".equals(context)) {
            patterns = template.getElementsByTagName("pattern");
        } else if ("jsf_iterative".equals(context)) {
            patterns = template.getElementsByTagName("iterative-pattern");
        } else if ("jsf_wrapper".equals(context)) {
            patterns = template.getElementsByTagName("wrapper-pattern");
        }
        if (patterns.getLength() > 0 && (text = TextNodeUtil.findChildTextNode((Node)patterns.item(0))) != null) {
            pattern = text.getNodeValue();
        }
        if (pattern == null) {
            pattern = "";
        }
        String libsElementName = "required-libs";
        if ("jsf_wrapper".equals(context)) {
            libsElementName = "wrapper-required-libs";
        } else if ("jsf_iterative".equals(context)) {
            libsElementName = "iterative-required-libs";
        }
        TaglibDependencies deps = null;
        NodeList requiredLibs = template.getElementsByTagName(libsElementName);
        if (requiredLibs.getLength() > 0) {
            NodeList libs = ((Element)requiredLibs.item(0)).getElementsByTagName("lib");
            HashMap<String, String> uriMap = new HashMap<String, String>();
            int i = 0;
            while (i < libs.getLength()) {
                Element lib = (Element)libs.item(i);
                String prefix = lib.getAttribute("prefix");
                String uri = lib.getAttribute("uri");
                if (prefix != null && uri != null) {
                    uriMap.put(uri, prefix);
                }
                ++i;
            }
            deps = new TaglibDependencies(uriMap);
        }
        DataTemplate dataTemplate = new DataTemplate(name, type, description, context, pattern, input, deps, defaultTemplate, id, enabled);
        return dataTemplate;
    }

    public static String storePropertyTemplateData(DataTemplate newTemplate, Node closestAncestor) {
        Element template = (Element)closestAncestor;
        template.setAttribute("name", newTemplate.getName());
        template.setAttribute("id", newTemplate.getId());
        template.setAttribute("data-type", newTemplate.getDataType());
        if (newTemplate.isInput()) {
            template.setAttribute("input", "true");
        } else {
            template.removeAttribute("input");
        }
        if (newTemplate.isContributed()) {
            template.setAttribute("enabled", "true");
        } else {
            template.removeAttribute("enabled");
        }
        if (newTemplate.isDefault()) {
            template.setAttribute("default", "true");
        } else {
            template.removeAttribute("default");
        }
        Node descriptionNode = null;
        NodeList descriptions = template.getElementsByTagName("description");
        if (descriptions.getLength() > 0) {
            descriptionNode = descriptions.item(0);
        } else {
            descriptionNode = template.getOwnerDocument().createElement("description");
            template.appendChild(descriptionNode);
        }
        Node text = TextNodeUtil.findChildTextNode((Node)descriptionNode);
        if (text != null) {
            text.setNodeValue(newTemplate.getDescription());
        } else {
            text = template.getOwnerDocument().createTextNode(newTemplate.getDescription());
            descriptionNode.appendChild(text);
        }
        Node requiredLibsNode = null;
        NodeList requiredLibs = template.getElementsByTagName("required-libs");
        if (requiredLibs.getLength() > 0) {
            requiredLibsNode = requiredLibs.item(0);
        } else {
            requiredLibsNode = template.getOwnerDocument().createElement("required-libs");
            template.appendChild(requiredLibsNode);
        }
        int childCount = requiredLibsNode.getChildNodes().getLength();
        int i = 0;
        while (i < childCount) {
            requiredLibsNode.removeChild(requiredLibsNode.getLastChild());
            ++i;
        }
        for (String uriString : newTemplate.getRequiredTaglibs().getDependencyMap().keySet()) {
            String prefix = newTemplate.getRequiredTaglibs().getDependencyMap().get(uriString);
            Element lib = template.getOwnerDocument().createElement("lib");
            lib.setAttribute("prefix", prefix);
            lib.setAttribute("uri", uriString);
            requiredLibsNode.appendChild(lib);
        }
        return newTemplate.getPattern();
    }

    public static DataTemplate fillChildTagsTemplateObject(Node closestAncestor) {
        Node text;
        Node text2;
        Element template = (Element)closestAncestor;
        String name = template.getAttribute("name");
        if (name == null) {
            name = "";
        }
        String description = null;
        NodeList descriptions = template.getElementsByTagName("description");
        if (descriptions.getLength() > 0 && (text2 = TextNodeUtil.findChildTextNode((Node)descriptions.item(0))) != null) {
            description = text2.getNodeValue();
        }
        if (description == null) {
            description = "";
        }
        String pattern = null;
        NodeList patterns = null;
        patterns = template.getElementsByTagName("pattern");
        if (patterns.getLength() > 0 && (text = TextNodeUtil.findChildTextNode((Node)patterns.item(0))) != null) {
            pattern = text.getNodeValue();
        }
        if (pattern == null) {
            pattern = "";
        }
        TaglibDependencies deps = null;
        NodeList requiredLibs = template.getElementsByTagName("required-libs");
        if (requiredLibs.getLength() > 0) {
            NodeList libs = ((Element)requiredLibs.item(0)).getElementsByTagName("lib");
            HashMap<String, String> uriMap = new HashMap<String, String>();
            int i = 0;
            while (i < libs.getLength()) {
                Element lib = (Element)libs.item(i);
                String prefix = lib.getAttribute("prefix");
                String uri = lib.getAttribute("uri");
                if (prefix != null && uri != null) {
                    uriMap.put(uri, prefix);
                }
                ++i;
            }
            deps = new TaglibDependencies(uriMap);
        }
        DataTemplate dataTemplate = new DataTemplate(name, "dummytype", description, "jsf_iterative", pattern, false, deps, false, null, false);
        return dataTemplate;
    }

    public static String storeChildTagsTemplateData(DataTemplate newTemplate, Node closestAncestor) {
        Element template = (Element)closestAncestor;
        template.setAttribute("name", newTemplate.getName());
        Node descriptionNode = null;
        NodeList descriptions = template.getElementsByTagName("description");
        if (descriptions.getLength() > 0) {
            descriptionNode = descriptions.item(0);
        } else {
            descriptionNode = template.getOwnerDocument().createElement("description");
            template.appendChild(descriptionNode);
        }
        Node text = TextNodeUtil.findChildTextNode((Node)descriptionNode);
        if (text != null) {
            text.setNodeValue(newTemplate.getDescription());
        } else {
            text = template.getOwnerDocument().createTextNode(newTemplate.getDescription());
            descriptionNode.appendChild(text);
        }
        Node requiredLibsNode = null;
        NodeList requiredLibs = template.getElementsByTagName("required-libs");
        if (requiredLibs.getLength() > 0) {
            requiredLibsNode = requiredLibs.item(0);
        } else {
            requiredLibsNode = template.getOwnerDocument().createElement("required-libs");
            template.appendChild(requiredLibsNode);
        }
        int childCount = requiredLibsNode.getChildNodes().getLength();
        int i = 0;
        while (i < childCount) {
            requiredLibsNode.removeChild(requiredLibsNode.getLastChild());
            ++i;
        }
        for (String uriString : newTemplate.getRequiredTaglibs().getDependencyMap().keySet()) {
            String prefix = newTemplate.getRequiredTaglibs().getDependencyMap().get(uriString);
            Element lib = template.getOwnerDocument().createElement("lib");
            lib.setAttribute("prefix", prefix);
            lib.setAttribute("uri", uriString);
            requiredLibsNode.appendChild(lib);
        }
        return newTemplate.getPattern();
    }

    public static String storeIterativeTemplateData(DataTemplate newWrapperTemplate, DataTemplate newIterativeTemplate, Node closestAncestor, int patternIndex) {
        Element template = (Element)closestAncestor;
        template.setAttribute("name", newWrapperTemplate.getName());
        template.setAttribute("id", newWrapperTemplate.getId());
        template.setAttribute("data-type", newWrapperTemplate.getDataType());
        if (newWrapperTemplate.isInput()) {
            template.setAttribute("input", "true");
        } else {
            template.removeAttribute("input");
        }
        if (newWrapperTemplate.isContributed()) {
            template.setAttribute("enabled", "true");
        } else {
            template.removeAttribute("enabled");
        }
        if (newWrapperTemplate.isDefault()) {
            template.setAttribute("default", "true");
        } else {
            template.removeAttribute("default");
        }
        Node descriptionNode = null;
        NodeList descriptions = template.getElementsByTagName("description");
        if (descriptions.getLength() > 0) {
            descriptionNode = descriptions.item(0);
        } else {
            descriptionNode = template.getOwnerDocument().createElement("description");
            template.appendChild(descriptionNode);
        }
        Node text = TextNodeUtil.findChildTextNode((Node)descriptionNode);
        if (text != null) {
            text.setNodeValue(newWrapperTemplate.getDescription());
        } else {
            text = template.getOwnerDocument().createTextNode(newWrapperTemplate.getDescription());
            descriptionNode.appendChild(text);
        }
        Node wrapperRequiredLibsNode = null;
        NodeList wrapperRequiredLibs = template.getElementsByTagName("wrapper-required-libs");
        if (wrapperRequiredLibs.getLength() > 0) {
            wrapperRequiredLibsNode = wrapperRequiredLibs.item(0);
        } else {
            wrapperRequiredLibsNode = template.getOwnerDocument().createElement("wrapper-required-libs");
            template.appendChild(wrapperRequiredLibsNode);
        }
        int childCount = wrapperRequiredLibsNode.getChildNodes().getLength();
        int i = 0;
        while (i < childCount) {
            wrapperRequiredLibsNode.removeChild(wrapperRequiredLibsNode.getLastChild());
            ++i;
        }
        for (String uriString : newWrapperTemplate.getRequiredTaglibs().getDependencyMap().keySet()) {
            String prefix = newWrapperTemplate.getRequiredTaglibs().getDependencyMap().get(uriString);
            Element lib = template.getOwnerDocument().createElement("lib");
            lib.setAttribute("prefix", prefix);
            lib.setAttribute("uri", uriString);
            wrapperRequiredLibsNode.appendChild(lib);
        }
        Node iterativeRequiredLibsNode = null;
        NodeList iterativeRequiredLibs = template.getElementsByTagName("iterative-required-libs");
        if (iterativeRequiredLibs.getLength() > 0) {
            iterativeRequiredLibsNode = iterativeRequiredLibs.item(0);
        } else {
            iterativeRequiredLibsNode = template.getOwnerDocument().createElement("iterative-required-libs");
            template.appendChild(iterativeRequiredLibsNode);
        }
        childCount = iterativeRequiredLibsNode.getChildNodes().getLength();
        int i2 = 0;
        while (i2 < childCount) {
            iterativeRequiredLibsNode.removeChild(iterativeRequiredLibsNode.getLastChild());
            ++i2;
        }
        for (String uriString : newIterativeTemplate.getRequiredTaglibs().getDependencyMap().keySet()) {
            String prefix = newIterativeTemplate.getRequiredTaglibs().getDependencyMap().get(uriString);
            Element lib = template.getOwnerDocument().createElement("lib");
            lib.setAttribute("prefix", prefix);
            lib.setAttribute("uri", uriString);
            iterativeRequiredLibsNode.appendChild(lib);
        }
        String patternElementName = "iterative-pattern";
        String patternString = newIterativeTemplate.getPattern();
        if (patternIndex == 1) {
            patternElementName = "wrapper-pattern";
            patternString = newWrapperTemplate.getPattern();
        }
        Node iterativePatternNode = null;
        NodeList iterativePatterns = template.getElementsByTagName(patternElementName);
        if (iterativePatterns.getLength() > 0) {
            iterativePatternNode = iterativePatterns.item(0);
        } else {
            iterativePatternNode = template.getOwnerDocument().createElement(patternElementName);
            template.appendChild(iterativePatternNode);
        }
        Node cdata = null;
        NodeList children = iterativePatternNode.getChildNodes();
        int i3 = 0;
        while (i3 < children.getLength()) {
            Node child = children.item(i3);
            if (child.getNodeType() == 4) {
                cdata = (CDATASection)child;
            }
            ++i3;
        }
        if (cdata != null) {
            cdata.setNodeValue(patternString);
        } else {
            cdata = template.getOwnerDocument().createCDATASection(patternString);
            iterativePatternNode.appendChild(cdata);
        }
        if (patternIndex == 0) {
            return newWrapperTemplate.getPattern();
        }
        if (patternIndex == 1) {
            return newIterativeTemplate.getPattern();
        }
        return null;
    }
}

