/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.ui;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.CommandUtil;
import com.ibm.etools.jsf.internal.databind.templates.ContextTypeRegistry;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.TemplateProvider;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateContributor;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplatePersistenceData;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateReaderWriter;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateStore;
import com.ibm.etools.jsf.internal.databind.templates.ui.ColumnLayout;
import com.ibm.etools.jsf.internal.databind.templates.ui.EditTemplateDialog;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.JsfAccessibleAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class TemplatePreferencePage
extends PropertyPage
implements IWorkbenchPreferencePage {
    public static final String PREF_DEFAULT_TEMPLATES_FILTER = "data.templates.filter";
    public static final String FILTER_ALL = "filter.all";
    private CheckboxTableViewer fTableViewer;
    protected Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fRestoreButton;
    private Button fRevertButton;
    private Button fExportButton;
    private Button fImportButton;
    private Text fPatternPreview;
    private TemplateStore fTemplateStore;
    private ContextTypeRegistry fContextTypeRegistry;
    protected Combo filterCombo;
    protected Text filterText;
    private ToolBarManager filterToolBar;
    protected CLabel previewLabel;
    private JsfAccessibleAdapter accPreviewLabel = null;
    private String helpId = "com.ibm.etools.jsf.TemplatePreferencePage";
    private static int pageCounter = 0;

    protected TemplatePreferencePage() {
        if (pageCounter++ == 0) {
            TemplateProvider.reset();
        }
        this.setPreferenceStore(TemplateProvider.getDefault().getPreferenceStore());
        this.setTemplateStore(TemplateProvider.getDefault().getTemplateStore());
        this.setContextTypeRegistry(TemplateProvider.getDefault().getContextTypeRegistry());
        this.setDescription(Messages.TemplatePreferencePage_message);
    }

    public TemplateStore getTemplateStore() {
        return this.fTemplateStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        return this.fContextTypeRegistry;
    }

    public void setTemplateStore(TemplateStore store) {
        this.fTemplateStore = store;
    }

    public void setContextTypeRegistry(ContextTypeRegistry registry) {
        this.fContextTypeRegistry = registry;
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite ancestor) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.helpId);
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        Composite labelFilterParent = new Composite(innerParent, 0);
        GridLayout labelFilterLayout = new GridLayout();
        labelFilterLayout.numColumns = 4;
        labelFilterLayout.marginHeight = 0;
        labelFilterLayout.marginWidth = 0;
        labelFilterParent.setLayout((Layout)labelFilterLayout);
        gd = new GridData(768);
        labelFilterParent.setLayoutData((Object)gd);
        Label displayFilterLabel = new Label(labelFilterParent, 0);
        displayFilterLabel.setText(Messages.TemplatePreferencePage_Filter);
        this.filterText = new Text(labelFilterParent, 2048);
        GridData textData = new GridData();
        textData.widthHint = 100;
        this.filterText.setLayoutData((Object)textData);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TemplatePreferencePage.this.handleTextFilterChange();
            }
        });
        this.filterToolBar = new ToolBarManager();
        this.filterToolBar.createControl(labelFilterParent);
        Action clearTextAction = new Action("", 1){

            public void run() {
                TemplatePreferencePage.this.handleClearFilterTextButton();
            }
        };
        clearTextAction.setToolTipText(Messages.TemplatePreferencePage_ClearFilter);
        clearTextAction.setImageDescriptor(JFaceResources.getImageRegistry().getDescriptor("org.eclipse.ui.internal.dialogs.CLEAR_ICON"));
        clearTextAction.setDisabledImageDescriptor(JFaceResources.getImageRegistry().getDescriptor("org.eclipse.ui.internal.dialogs.DCLEAR_ICON"));
        this.filterToolBar.add((IAction)clearTextAction);
        this.filterToolBar.update(false);
        Composite comboComposite = new Composite(labelFilterParent, 0);
        GridLayout comboCompositeLayout = new GridLayout();
        comboCompositeLayout.numColumns = 2;
        comboCompositeLayout.marginWidth = 0;
        comboCompositeLayout.marginHeight = 0;
        comboComposite.setLayout((Layout)comboCompositeLayout);
        gd = new GridData(128);
        gd.grabExcessHorizontalSpace = true;
        comboComposite.setLayoutData((Object)gd);
        Label filterLabel = new Label(comboComposite, 0);
        filterLabel.setText(Messages.TemplatePreferencePage_Show);
        this.filterCombo = new Combo(comboComposite, 2056);
        this.setupFilter();
        GridData comboData = new GridData(128);
        comboData.grabExcessHorizontalSpace = true;
        String[] stringArray = this.filterCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            int itemWidth = this.computeMinimumTextWidth(item, 25);
            if (comboData.widthHint < itemWidth) {
                comboData.widthHint = itemWidth;
            }
            ++n2;
        }
        if (comboData.widthHint > 150) {
            comboData.widthHint = 150;
        }
        this.filterCombo.select(0);
        this.filterCombo.setLayoutData((Object)comboData);
        this.filterCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                TemplatePreferencePage.this.handleFilterChange();
            }
        });
        new Label(innerParent, 0);
        Label descriptionLabel = new Label(innerParent, 0);
        descriptionLabel.setText(this.getDescription());
        GridData descriptionData = new GridData();
        descriptionData.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)descriptionData);
        Composite tableComposite = new Composite(innerParent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        tableComposite.setLayoutData((Object)data);
        ColumnLayout columnLayout = new ColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableColumns(table, columnLayout);
        this.makeTableAccessible(table);
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider(this.getTemplateLabelProvider());
        this.fTableViewer.setContentProvider(this.getTemplateContentProvider());
        this.fTableViewer.setComparator(this.getViewerComparator());
        this.fTableViewer.addFilter(this.getViewerFilter());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                TemplatePreferencePage.this.edit();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TemplatePreferencePage.this.handleSelectionChange();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TemplatePersistenceData d = (TemplatePersistenceData)event.getElement();
                d.setEnabled(event.getChecked());
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText(Messages.TemplatePreferencePage_new);
        this.fAddButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fAddButton));
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.add();
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText(Messages.TemplatePreferencePage_edit);
        this.fEditButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fEditButton));
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.edit();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setText(Messages.TemplatePreferencePage_remove);
        this.fRemoveButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fRemoveButton));
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.remove();
            }
        });
        this.createSeparator(buttons);
        this.fRestoreButton = new Button(buttons, 8);
        this.fRestoreButton.setText(Messages.TemplatePreferencePage_restore);
        this.fRestoreButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fRestoreButton));
        this.fRestoreButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.restoreDeleted();
            }
        });
        this.fRevertButton = new Button(buttons, 8);
        this.fRevertButton.setText(Messages.TemplatePreferencePage_revert);
        this.fRevertButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fRevertButton));
        this.fRevertButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.revert();
            }
        });
        this.createSeparator(buttons);
        this.fImportButton = new Button(buttons, 8);
        this.fImportButton.setText(Messages.TemplatePreferencePage_Import);
        this.fImportButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fImportButton));
        this.fImportButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.handleImport();
            }
        });
        this.fExportButton = new Button(buttons, 8);
        this.fExportButton.setText(Messages.TemplatePreferencePage_Export);
        this.fExportButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fExportButton));
        this.fExportButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.handleExport();
            }
        });
        this.createPreview(parent);
        this.fTableViewer.setInput((Object)this.fTemplateStore);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
        this.updateButtons();
        Dialog.applyDialogFont((Control)parent);
        innerParent.layout();
        return parent;
    }

    protected abstract ViewerFilter getViewerFilter();

    protected abstract ViewerComparator getViewerComparator();

    protected abstract IContentProvider getTemplateContentProvider();

    protected abstract IBaseLabelProvider getTemplateLabelProvider();

    protected abstract void createTableColumns(Table var1, ColumnLayout var2);

    protected abstract DataTemplate createNewTemplate();

    private void makeTableAccessible(final Table table) {
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID >= 0 && e.childID < table.getItemCount()) {
                    TableItem item = table.getItem(e.childID);
                    TemplatePersistenceData data = (TemplatePersistenceData)item.getData();
                    DataTemplate template = data.getTemplate();
                    String accText = "";
                    accText = data.isEnabled() ? accText.concat(Messages.TemplatePreferencePage_enabled_template) : accText.concat(Messages.TemplatePreferencePage_disabled_template);
                    accText = accText.concat(" " + template.getName());
                    accText = accText.concat(" " + template.getDataType());
                    if (data.getTemplate().isDefault()) {
                        accText = accText.concat(" " + Messages.TemplatePreferencePage_default_template);
                    }
                    if (data.getTemplate().isInput()) {
                        accText = accText.concat(" " + Messages.TemplatePreferencePage_input_template);
                    }
                    if (data.isModified()) {
                        accText = accText.concat(" " + Messages.TemplatePreferencePage_edited_template);
                    }
                    e.result = accText = accText.concat(" " + Messages.bind((String)Messages.TemplatePreferencePage_x_of_y, (Object)(e.childID + 1), (Object)table.getItemCount()));
                }
            }
        });
    }

    private void setupFilter() {
        this.addFilter(Messages.TemplatePreferencePage_All, FILTER_ALL);
        Map<String, TemplateContributor> contributors = this.fTemplateStore.getContributors();
        Iterator<String> iterator = contributors.keySet().iterator();
        while (iterator.hasNext()) {
            String obj;
            String key = obj = iterator.next();
            TemplateContributor c = contributors.get(key);
            this.addFilter(c.getName(), c.getId());
        }
    }

    protected int computeMinimumTextWidth(String string, int padding) {
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        int width = gc.stringExtent((String)string).x + padding;
        gc.dispose();
        return width;
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    private TemplatePersistenceData[] getEnabledTemplates() {
        ArrayList<TemplatePersistenceData> enabled = new ArrayList<TemplatePersistenceData>();
        Object[] datas = ((IStructuredContentProvider)this.getTemplateContentProvider()).getElements((Object)this.fTemplateStore);
        int i = 0;
        while (i < datas.length) {
            TemplatePersistenceData data = (TemplatePersistenceData)datas[i];
            if (data.isEnabled()) {
                enabled.add(data);
            }
            ++i;
        }
        return enabled.toArray(new TemplatePersistenceData[enabled.size()]);
    }

    protected void createPreview(Composite parent) {
        this.previewLabel = new CLabel(parent, 0);
        this.previewLabel.setText(Messages.TemplatePreferencePage_preview);
        GridData layout = new GridData(768);
        layout.horizontalSpan = 2;
        layout.grabExcessHorizontalSpace = true;
        this.previewLabel.setLayoutData((Object)layout);
        this.fPatternPreview = new Text(parent, 2826);
        layout = new GridData(1808);
        layout.horizontalSpan = 2;
        layout.heightHint = this.convertHeightInCharsToPixels(5);
        this.fPatternPreview.setLayoutData((Object)layout);
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        return data;
    }

    private void handleSelectionChange() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            this.updatePreview(data);
        } else {
            this.updatePreview(null);
        }
        this.updateButtons();
    }

    protected void updatePreview(TemplatePersistenceData data) {
        if (data == null) {
            this.previewLabel.setText(Messages.TemplatePreferencePage_preview);
            this.setPreviewAccLabel(Messages.TemplatePreferencePage_preview);
            this.fPatternPreview.setText("");
        } else {
            String label = NLS.bind((String)Messages.TemplatePreferencePage_PreviewDescription, (Object)data.getTemplate().getDescription().replace("&", "&&"));
            this.previewLabel.setText(label);
            if (data.getTemplate().isInput()) {
                label = label.concat(Messages.TemplatePreferencePage_input_template);
            }
            if (data.getTemplate().isDefault()) {
                label = label.concat(Messages.TemplatePreferencePage_default_template);
            }
            if (data.isModified()) {
                label = label.concat(Messages.TemplatePreferencePage_edited_template);
            }
            this.setPreviewAccLabel(label);
            this.fPatternPreview.setText(data.getTemplate().getPattern());
        }
    }

    private void setPreviewAccLabel(String label) {
        if (this.accPreviewLabel != null) {
            this.fPatternPreview.getAccessible().removeAccessibleListener((AccessibleListener)this.accPreviewLabel);
        }
        this.accPreviewLabel = new JsfAccessibleAdapter(label);
        this.fPatternPreview.getAccessible().addAccessibleListener((AccessibleListener)this.accPreviewLabel);
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        int selectionCount = selection.size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        boolean canRestore = this.fTemplateStore.getTemplateData(true).length != this.fTemplateStore.getTemplateData(false).length;
        boolean canRevert = false;
        for (TemplatePersistenceData template : this.getSelectedTemplates()) {
            if (!template.isModified()) continue;
            canRevert = true;
            break;
        }
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fExportButton.setEnabled(selectionCount > 0);
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount);
        this.fRestoreButton.setEnabled(canRestore);
        this.fRevertButton.setEnabled(canRevert);
    }

    protected void add() {
        DataTemplate template = this.createNewTemplate();
        DataTemplate newTemplate = this.editTemplate(template, false, true);
        if (newTemplate != null) {
            TemplatePersistenceData data = new TemplatePersistenceData(newTemplate, true, template.getId(), false);
            this.fTemplateStore.addCustomizedTemplate(data);
            this.addCustomFilter();
            if (!FILTER_ALL.equals(this.getCurrentFilter())) {
                this.setCurrentFilter("com.ibm.etools.jsf.custom.template.contributor");
            }
            this.handleClearFilterTextButton();
            this.fTableViewer.refresh();
            this.fTableViewer.setChecked((Object)data, true);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)data), true);
        }
    }

    protected void addCustomFilter() {
        String contributorName;
        Map filters;
        TemplateContributor c = this.fTemplateStore.getContributors().get("com.ibm.etools.jsf.custom.template.contributor");
        if (c != null && this.filterCombo != null && (filters = (Map)this.filterCombo.getData()) != null && (contributorName = (String)filters.get(c.getId())) == null) {
            this.addFilter(c.getName(), c.getId());
        }
    }

    protected DataTemplate editTemplate(DataTemplate template, boolean edit, boolean isNameModifiable) {
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.fContextTypeRegistry);
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
        this.edit(data);
    }

    protected void edit(TemplatePersistenceData data) {
        DataTemplate oldTemplate = data.getTemplate();
        DataTemplate newTemplate = this.editTemplate(new DataTemplate(oldTemplate), true, true);
        if (newTemplate != null) {
            if (!newTemplate.getName().equals(oldTemplate.getName()) && MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.TemplatePreferencePage_question_create_new_title, (String)Messages.TemplatePreferencePage_question_create_new_question)) {
                String id = CommandUtil.generateUniqueId(this.fTemplateStore.getAllTemplates(null, true), null, null);
                data = new TemplatePersistenceData(newTemplate, true, id, false);
                this.fTemplateStore.addCustomizedTemplate(data);
                this.addCustomFilter();
                this.fTableViewer.refresh();
            } else {
                data.setTemplate(newTemplate);
                this.fTemplateStore.addCustomizedTemplate(data);
                this.addCustomFilter();
                this.fTableViewer.refresh((Object)data);
            }
            this.handleSelectionChange();
            this.fTableViewer.setChecked((Object)data, data.isEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)data), true);
        }
    }

    protected void remove() {
        for (TemplatePersistenceData template : this.getSelectedTemplates()) {
            this.fTemplateStore.delete(template);
        }
        this.fTableViewer.refresh();
    }

    private void restoreDeleted() {
        this.fTemplateStore.restoreDeleted();
        this.fTableViewer.refresh();
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
        this.updateButtons();
    }

    private void revert() {
        for (TemplatePersistenceData template : this.getSelectedTemplates()) {
            List<TemplatePersistenceData> customTemplates;
            TemplateContributor c;
            template.revert();
            if (this.fTemplateStore == null || (c = this.fTemplateStore.getContributors().get("com.ibm.etools.jsf.custom.template.contributor")) == null || (customTemplates = c.getTemplates()) == null) continue;
            customTemplates.remove(template);
        }
        this.fTableViewer.refresh();
        this.handleSelectionChange();
        this.fTableViewer.setChecked((Object)this.getEnabledTemplates(), true);
    }

    private List<TemplatePersistenceData> getSelectedTemplates() {
        List templates = null;
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection != null) {
            templates = selection.toList();
        }
        return templates;
    }

    protected void performDefaults() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.TemplatePreferencePage_RestoreDefaults_Title, (String)Messages.TemplatePreferencePage_RestoreDefaults)) {
            this.fTemplateStore.restoreDefaults();
            this.fTableViewer.refresh();
            this.fTableViewer.setAllChecked(false);
            this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
            this.filterCombo.removeAll();
            this.setupFilter();
            this.setCurrentFilter(FILTER_ALL);
        }
    }

    public boolean performOk() {
        if (--pageCounter == 0) {
            try {
                this.fTemplateStore.save();
            }
            catch (IOException iOException) {
                this.openWriteErrorDialog();
            }
            TemplateProvider.getDefault().savePluginPreferences();
        }
        return super.performOk();
    }

    public void performApply() {
        try {
            this.fTemplateStore.save();
        }
        catch (IOException iOException) {
            this.openWriteErrorDialog();
        }
        TemplateProvider.getDefault().savePluginPreferences();
    }

    public boolean performCancel() {
        pageCounter = 0;
        try {
            this.fTemplateStore.load();
        }
        catch (IOException iOException) {
            this.openReadErrorDialog();
            return false;
        }
        return super.performCancel();
    }

    private void openReadErrorDialog() {
        String title = Messages.TemplatePreferencePage_error_read_title;
        String message = Messages.TemplatePreferencePage_error_read_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void openWriteErrorDialog() {
        String title = Messages.TemplatePreferencePage_error_write_title;
        String message = Messages.TemplatePreferencePage_error_write_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    protected TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public IPreferenceStore getPreferenceStore() {
        if (super.getPreferenceStore() != null) {
            return super.getPreferenceStore();
        }
        try {
            IAdaptable element = this.getElement();
            if (element instanceof IProject) {
                ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope((IProject)this.getElement()), "com.ibm.etools.jsf");
                this.setPreferenceStore((IPreferenceStore)preferenceStore);
            }
        }
        catch (Throwable t) {
            JsfPlugin.log(t);
        }
        return super.getPreferenceStore();
    }

    protected Label createDescriptionLabel(Composite parent) {
        return null;
    }

    protected void handleFilterChange() {
        String filter = this.getCurrentFilter();
        IPreferenceStore prefs = JsfPlugin.getDefault().getPreferenceStore();
        prefs.setValue(PREF_DEFAULT_TEMPLATES_FILTER, filter);
        this.filterCombo.setToolTipText(this.getFilterDescription(filter));
        this.applyFilter();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.filterCombo != null) {
                IPreferenceStore prefs = JsfPlugin.getDefault().getPreferenceStore();
                String defaultFilterId = prefs.getString(PREF_DEFAULT_TEMPLATES_FILTER);
                this.setCurrentFilter(defaultFilterId);
            }
            this.filterToolBar.getControl().setVisible(this.filterText.getText().length() > 0);
        }
    }

    protected void applyFilter() {
        this.fTableViewer.refresh();
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
    }

    protected String getCurrentFilter() {
        if (this.filterCombo == null) {
            return null;
        }
        String filterName = this.filterCombo.getText();
        Map filters = (Map)this.filterCombo.getData();
        for (String filterId : filters.keySet()) {
            if (!((String)filters.get(filterId)).equals(filterName)) continue;
            return filterId;
        }
        return null;
    }

    protected void setCurrentFilter(String filterId) {
        if (filterId != null) {
            Map filters = (Map)this.filterCombo.getData();
            String filterName = (String)filters.get(filterId);
            int i = 0;
            while (i < this.filterCombo.getItems().length) {
                String item = this.filterCombo.getItems()[i];
                if (item.equals(filterName)) {
                    this.filterCombo.select(i);
                    this.handleFilterChange();
                    break;
                }
                ++i;
            }
        }
    }

    protected void addFilter(String name, String id) {
        if (this.filterCombo == null) {
            return;
        }
        this.filterCombo.add(name);
        HashMap<String, String> filters = (HashMap<String, String>)this.filterCombo.getData();
        if (filters == null) {
            filters = new HashMap<String, String>();
        }
        filters.put(id, name);
        this.filterCombo.setData(filters);
    }

    protected String getFilterDescription(String filter) {
        if (filter == null || filter.equals(FILTER_ALL)) {
            return Messages.TemplatePreferencePage_All;
        }
        Map<String, TemplateContributor> contributors = this.fTemplateStore.getContributors();
        for (String obj : contributors.keySet()) {
            String key = obj;
            TemplateContributor c = contributors.get(key);
            if (!c.getId().equals(filter)) continue;
            return c.getDescription();
        }
        return null;
    }

    protected void handleTextFilterChange() {
        this.applyFilter();
        this.filterToolBar.getControl().setVisible(this.filterText.getText().length() > 0);
    }

    protected void handleClearFilterTextButton() {
        this.filterText.setText("");
    }

    protected void handleImport() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.TemplatePreferencePage_import_title);
        dialog.setFilterExtensions(new String[]{Messages.TemplatePreferencePage_import_extension});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        TemplateReaderWriter reader = new TemplateReaderWriter();
        File file = new File(path);
        if (!file.exists()) {
            this.openReadErrorDialog();
            return;
        }
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            TemplatePersistenceData[] datas = reader.read(input, null);
            int i = 0;
            while (i < datas.length) {
                TemplatePersistenceData data = datas[i];
                this.fTemplateStore.addCustomizedTemplate(data);
                this.addCustomFilter();
                if (!this.getCurrentFilter().equals(FILTER_ALL)) {
                    this.setCurrentFilter("com.ibm.etools.jsf.custom.template.contributor");
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            this.openWriteErrorDialog();
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {}
        }
        this.fTableViewer.refresh();
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
    }

    protected void handleExport() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] selectedTemplates = selection.toArray();
        int templateCount = selectedTemplates.length;
        int t = 0;
        while (t < selectedTemplates.length) {
            TemplatePersistenceData iterative;
            TemplatePersistenceData current = (TemplatePersistenceData)selectedTemplates[t];
            if ("jsf_wrapper".equals(current.getTemplate().getContextTypeId()) && (iterative = this.fTemplateStore.getIterativeTemplate(null, current.getTemplate())) != null) {
                ++templateCount;
            }
            ++t;
        }
        TemplatePersistenceData[] datas = new TemplatePersistenceData[templateCount];
        int d = 0;
        int i = 0;
        while (i != selectedTemplates.length) {
            TemplatePersistenceData currentTemplate = (TemplatePersistenceData)selectedTemplates[i];
            if ("jsf_wrapper".equals(currentTemplate.getTemplate().getContextTypeId())) {
                datas[d] = currentTemplate;
                ++d;
                TemplatePersistenceData iterativeTemplate = this.fTemplateStore.getIterativeTemplate(null, currentTemplate.getTemplate());
                if (iterativeTemplate != null) {
                    datas[d] = iterativeTemplate;
                    ++d;
                }
            } else {
                datas[d] = currentTemplate;
                ++d;
            }
            ++i;
        }
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.TemplatePreferencePage_export_title);
        dialog.setFilterExtensions(new String[]{Messages.TemplatePreferencePage_export_extension});
        dialog.setFileName(Messages.TemplatePreferencePage_export_filename);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            String title = Messages.TemplatePreferencePage_export_error_title;
            String message = NLS.bind((String)Messages.TemplatePreferencePage_export_error_hidden, (Object)file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String title = Messages.TemplatePreferencePage_export_error_title;
            String message = NLS.bind((String)Messages.TemplatePreferencePage_export_error_canNotWrite, (Object)file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (file.exists() && !this.confirmOverwrite(file)) {
            return;
        }
        BufferedOutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(file));
            TemplateReaderWriter writer = new TemplateReaderWriter();
            writer.save(datas, output);
        }
        catch (IOException iOException) {
            this.openWriteErrorDialog();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.TemplatePreferencePage_export_exists_title, (String)NLS.bind((String)Messages.TemplatePreferencePage_export_exists_message, (Object)file.getAbsolutePath()));
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

