/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.ui;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.CommandUtil;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplatePersistenceData;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateStore;
import com.ibm.etools.jsf.internal.databind.templates.ui.ColumnLayout;
import com.ibm.etools.jsf.internal.databind.templates.ui.LabelProvider;
import com.ibm.etools.jsf.internal.databind.templates.ui.TemplatePreferencePage;
import com.ibm.etools.jsf.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PropertyTemplatesPreferencePage
extends TemplatePreferencePage
implements IWorkbenchPreferencePage {
    public PropertyTemplatesPreferencePage() {
        this.setDescription(Messages.JSF_PreferencePage_Property_Templates_Description);
        this.setTitle(Messages.JSF_PreferencePage_Property_Templates_Title);
    }

    @Override
    protected void createTableColumns(Table table, ColumnLayout columnLayout) {
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.TemplatePreferencePage_column_name);
        int minWidth = this.computeMinimumTextWidth(Messages.TemplatePreferencePage_column_name, 0);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, minWidth, true));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(Messages.TemplatePreferencePage_column_data_type);
        minWidth = this.computeMinimumTextWidth(Messages.TemplatePreferencePage_column_data_type, 0);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, minWidth, true));
        new TableColumn(table, 0);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(16, false));
    }

    @Override
    protected IBaseLabelProvider getTemplateLabelProvider() {
        return new LabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                DataTemplate template = data.getTemplate();
                switch (columnIndex) {
                    case 0: {
                        return template.getName();
                    }
                    case 1: {
                        return template.getDataType();
                    }
                }
                return super.getColumnText(element, columnIndex);
            }

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                TemplatePersistenceData data;
                DataTemplate template;
                if (columnIndex == 2 && (template = (data = (TemplatePersistenceData)element).getTemplate()).isInput()) {
                    return JsfPlugin.getDefault().getImage1("input");
                }
                return super.getColumnImage(element, columnIndex);
            }
        };
    }

    @Override
    protected IContentProvider getTemplateContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object obj) {
                TemplateStore fStore = (TemplateStore)obj;
                String contributor = PropertyTemplatesPreferencePage.this.getCurrentFilter();
                Map<String, TemplatePersistenceData> templates = contributor == null || contributor.equals("filter.all") ? fStore.getAllTemplates("jsf_property", false) : fStore.getAllTemplatesFromContributor(contributor, "jsf_property", false);
                ArrayList<TemplatePersistenceData> datas = new ArrayList<TemplatePersistenceData>();
                for (TemplatePersistenceData templateData : templates.values()) {
                    if (templateData.getTemplate().getDataType().equals("java.lang.reflect.Method")) continue;
                    datas.add(templateData);
                }
                return datas.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    @Override
    protected DataTemplate createNewTemplate() {
        String id = CommandUtil.generateUniqueId(this.getTemplateStore().getAllTemplates(null, true), null, null);
        return new DataTemplate("", "", "", "jsf_property", "", false, null, false, id, false);
    }

    @Override
    protected ViewerFilter getViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String filter = PropertyTemplatesPreferencePage.this.filterText.getText();
                if (filter == null || filter.length() == 0) {
                    return true;
                }
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                DataTemplate template = data.getTemplate();
                return template.getName().toLowerCase().contains(filter.toLowerCase()) || template.getDataType().toLowerCase().contains(filter.toLowerCase());
            }
        };
    }

    @Override
    protected ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof TemplatePersistenceData && object2 instanceof TemplatePersistenceData) {
                    DataTemplate left = ((TemplatePersistenceData)object1).getTemplate();
                    DataTemplate right = ((TemplatePersistenceData)object2).getTemplate();
                    int result = left.getDataType().compareToIgnoreCase(right.getDataType());
                    if (result != 0) {
                        return result;
                    }
                    return left.isInput() ? 1 : -1;
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        };
    }
}

