/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.ui;

import com.ibm.etools.jsf.internal.databind.CommandUtil;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplatePersistenceData;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateStore;
import com.ibm.etools.jsf.internal.databind.templates.ui.ColumnLayout;
import com.ibm.etools.jsf.internal.databind.templates.ui.EditTemplateDialog;
import com.ibm.etools.jsf.internal.databind.templates.ui.LabelProvider;
import com.ibm.etools.jsf.internal.databind.templates.ui.TemplatePreferencePage;
import com.ibm.etools.jsf.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MethodTemplatesPreferencePage
extends TemplatePreferencePage
implements IWorkbenchPreferencePage {
    private static String METHOD = "java.lang.reflect.Method";

    public MethodTemplatesPreferencePage() {
        this.setDescription(Messages.JSF_PreferencePage_Method_Templates_Description);
        this.setTitle(Messages.JSF_PreferencePage_Method_Templates_Title);
        this.setHelpId("com.ibm.etools.jsf.MethodTemplatePreferencePage");
    }

    @Override
    protected void createTableColumns(Table table, ColumnLayout columnLayout) {
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.TemplatePreferencePage_column_name);
        int minWidth = this.computeMinimumTextWidth(Messages.TemplatePreferencePage_column_name, 10);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
    }

    @Override
    protected IBaseLabelProvider getTemplateLabelProvider() {
        return new LabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    TemplatePersistenceData data = (TemplatePersistenceData)element;
                    DataTemplate template = data.getTemplate();
                    return template.getName();
                }
                return super.getColumnText(element, columnIndex);
            }
        };
    }

    @Override
    protected IContentProvider getTemplateContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object obj) {
                TemplateStore fStore = (TemplateStore)obj;
                String contributor = MethodTemplatesPreferencePage.this.getCurrentFilter();
                Map<String, TemplatePersistenceData> templates = contributor == null || contributor.equals("filter.all") ? fStore.getAllTemplates("jsf_property", false) : fStore.getAllTemplatesFromContributor(contributor, "jsf_property", false);
                ArrayList<TemplatePersistenceData> datas = new ArrayList<TemplatePersistenceData>();
                for (TemplatePersistenceData templateData : templates.values()) {
                    if (!templateData.getTemplate().getDataType().equals("java.lang.reflect.Method")) continue;
                    datas.add(templateData);
                }
                return datas.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    @Override
    protected DataTemplate createNewTemplate() {
        String id = CommandUtil.generateUniqueId(this.getTemplateStore().getAllTemplates(null, true), null, null);
        return new DataTemplate("", METHOD, "", "jsf_property", "", false, null, false, id, false);
    }

    @Override
    protected DataTemplate editTemplate(DataTemplate template, boolean edit, boolean isNameModifiable) {
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.getContextTypeRegistry());
        dialog.setShowClass(false);
        dialog.setShowIsInput(false);
        dialog.setShowDefault(false);
        dialog.setDefaultLabel(Messages.EditTemplateDialog_is_default_method);
        dialog.setHelpId("com.ibm.etools.jsf.EditMethodTemplateDialog");
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    @Override
    protected ViewerFilter getViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String filter = MethodTemplatesPreferencePage.this.filterText.getText();
                if (filter == null || filter.length() == 0) {
                    return true;
                }
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                DataTemplate template = data.getTemplate();
                return template.getName().toLowerCase().contains(filter.toLowerCase());
            }
        };
    }

    @Override
    protected ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof TemplatePersistenceData && object2 instanceof TemplatePersistenceData) {
                    DataTemplate left = ((TemplatePersistenceData)object1).getTemplate();
                    DataTemplate right = ((TemplatePersistenceData)object2).getTemplate();
                    int result = left.getName().compareToIgnoreCase(right.getName());
                    return result;
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        };
    }

    @Override
    protected void updateButtons() {
        super.updateButtons();
        Map<String, DataTemplate> templates = this.getTemplateStore().getActiveTemplates(null, "jsf_property");
        if (templates.get("jsf.method.commandExButton") != null && templates.get("jsf.base.method.commandButton") != null) {
            this.fAddButton.setEnabled(false);
        } else {
            this.fAddButton.setEnabled(true);
        }
    }
}

