/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.ui;

import com.ibm.etools.jsf.internal.databind.CommandUtil;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplatePersistenceData;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateStore;
import com.ibm.etools.jsf.internal.databind.templates.ui.ColumnLayout;
import com.ibm.etools.jsf.internal.databind.templates.ui.EditIterativeTemplateDialog;
import com.ibm.etools.jsf.internal.databind.templates.ui.LabelProvider;
import com.ibm.etools.jsf.internal.databind.templates.ui.TemplatePreferencePage;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.JsfAccessibleAdapter;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class IterativeTemplatesPreferencePage
extends TemplatePreferencePage
implements IWorkbenchPreferencePage {
    protected Text wrapperPreview;
    protected Text iterativePreview;
    protected CLabel wrapperPreviewLabel;
    private JsfAccessibleAdapter accWrapperPreviewLabel = null;

    public IterativeTemplatesPreferencePage() {
        this.setDescription(Messages.JSF_PreferencePage_Iterative_Templates_Description);
        this.setTitle(Messages.JSF_PreferencePage_Iterative_Templates_Title);
        this.setHelpId("com.ibm.etools.jsf.IterativeTemplatePreferencePage");
    }

    @Override
    protected void createTableColumns(Table table, ColumnLayout columnLayout) {
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.TemplatePreferencePage_column_name);
        int minWidth = this.computeMinimumTextWidth(Messages.TemplatePreferencePage_column_name, 10);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.TemplatePreferencePage_column_data_type);
        minWidth = this.computeMinimumTextWidth(Messages.TemplatePreferencePage_column_data_type, 10);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
    }

    @Override
    protected IBaseLabelProvider getTemplateLabelProvider() {
        return new LabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                DataTemplate template = data.getTemplate();
                switch (columnIndex) {
                    case 0: {
                        return template.getName();
                    }
                    case 1: {
                        return template.getDataType();
                    }
                }
                return super.getColumnText(element, columnIndex);
            }
        };
    }

    @Override
    protected IContentProvider getTemplateContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object obj) {
                TemplateStore fStore = (TemplateStore)obj;
                String contributor = IterativeTemplatesPreferencePage.this.getCurrentFilter();
                Map<String, TemplatePersistenceData> templates = contributor == null || contributor.equals("filter.all") ? fStore.getAllTemplates("jsf_wrapper", false) : fStore.getAllTemplatesFromContributor(contributor, "jsf_wrapper", false);
                return templates.values().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    @Override
    protected DataTemplate createNewTemplate() {
        String wrapperId = CommandUtil.generateUniqueId(this.getTemplateStore().getAllTemplates(null, true), "wrapper", null);
        return new DataTemplate("", "", "", "jsf_wrapper", "", false, null, false, wrapperId, false);
    }

    @Override
    protected DataTemplate editTemplate(DataTemplate wrapperTemplate, boolean edit, boolean isNameModifiable) {
        DataTemplate iterativeTemplate = this.getIterativeTemplate(wrapperTemplate);
        if (iterativeTemplate == null) {
            String iterativeId = CommandUtil.generateUniqueId(this.getTemplateStore().getAllTemplates(null, true), "iterative", null);
            iterativeTemplate = new DataTemplate("", wrapperTemplate.getId(), "", "jsf_iterative", "", false, null, false, iterativeId, false);
        }
        EditIterativeTemplateDialog dialog = new EditIterativeTemplateDialog(this.getShell(), wrapperTemplate, iterativeTemplate, edit, isNameModifiable, this.getContextTypeRegistry());
        dialog.setShowIsInput(false);
        if (dialog.open() == 0) {
            DataTemplate newIterativeTemplate = dialog.getNewIterativeTemplate();
            if (newIterativeTemplate != null) {
                TemplatePersistenceData data = new TemplatePersistenceData(newIterativeTemplate, true, iterativeTemplate.getId(), false);
                this.getTemplateStore().addCustomizedTemplate(data);
                this.addCustomFilter();
            }
            return dialog.getTemplate();
        }
        return null;
    }

    @Override
    protected ViewerFilter getViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String filter = IterativeTemplatesPreferencePage.this.filterText.getText();
                if (filter == null || filter.length() == 0) {
                    return true;
                }
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                DataTemplate template = data.getTemplate();
                return template.getName().toLowerCase().contains(filter.toLowerCase()) || template.getDataType().toLowerCase().contains(filter.toLowerCase());
            }
        };
    }

    @Override
    protected ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof TemplatePersistenceData && object2 instanceof TemplatePersistenceData) {
                    DataTemplate left = ((TemplatePersistenceData)object1).getTemplate();
                    DataTemplate right = ((TemplatePersistenceData)object2).getTemplate();
                    int result = left.getDataType().compareToIgnoreCase(right.getDataType());
                    if (result != 0) {
                        return result;
                    }
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        };
    }

    @Override
    protected void createPreview(Composite parent) {
        this.wrapperPreviewLabel = new CLabel(parent, 0);
        this.wrapperPreviewLabel.setText(Messages.IterativeTemplatesPreferencePage_PreviewWrapper);
        GridData layout = new GridData(768);
        layout.horizontalSpan = 2;
        layout.grabExcessHorizontalSpace = true;
        this.wrapperPreviewLabel.setLayoutData((Object)layout);
        this.wrapperPreview = new Text(parent, 2826);
        layout = new GridData(1808);
        layout.horizontalSpan = 2;
        layout.heightHint = this.convertHeightInCharsToPixels(5);
        this.wrapperPreview.setLayoutData((Object)layout);
        Label iterativePreviewLabel = new Label(parent, 0);
        iterativePreviewLabel.setText(Messages.IterativeTemplatesPreferencePage_PreviewIterative);
        layout = new GridData();
        layout.horizontalSpan = 2;
        iterativePreviewLabel.setLayoutData((Object)layout);
        this.iterativePreview = new Text(parent, 2826);
        layout = new GridData(1808);
        layout.horizontalSpan = 2;
        layout.heightHint = this.convertHeightInCharsToPixels(5);
        this.iterativePreview.setLayoutData((Object)layout);
    }

    @Override
    protected void updatePreview(TemplatePersistenceData data) {
        DataTemplate template = null;
        if (data != null) {
            template = data.getTemplate();
        }
        if (template == null) {
            this.wrapperPreviewLabel.setText(Messages.IterativeTemplatesPreferencePage_PreviewWrapper);
            this.setWrapperPreviewAccLabel(Messages.IterativeTemplatesPreferencePage_PreviewWrapper);
            this.wrapperPreview.setText("");
            this.iterativePreview.setText("");
        } else {
            String label = NLS.bind((String)Messages.TemplatePreferencePage_PreviewDescription, (Object)template.getDescription().replace("&", "&&"));
            this.wrapperPreviewLabel.setText(label);
            this.setWrapperPreviewAccLabel(label);
            this.wrapperPreview.setText(template.getPattern());
            DataTemplate iterativeTemplate = this.getIterativeTemplate(template);
            if (iterativeTemplate != null) {
                this.iterativePreview.setText(iterativeTemplate.getPattern());
            }
        }
    }

    protected DataTemplate getIterativeTemplate(DataTemplate wrapperTemplate) {
        TemplatePersistenceData iterativeTemplateData;
        String contributor = this.getCurrentFilter();
        if (contributor != null && contributor.equals("filter.all")) {
            contributor = null;
        }
        if ((iterativeTemplateData = this.getTemplateStore().getIterativeTemplate(contributor, wrapperTemplate)) != null) {
            return iterativeTemplateData.getTemplate();
        }
        return null;
    }

    private void setWrapperPreviewAccLabel(String label) {
        if (this.accWrapperPreviewLabel != null) {
            this.wrapperPreview.getAccessible().removeAccessibleListener((AccessibleListener)this.accWrapperPreviewLabel);
        }
        this.accWrapperPreviewLabel = new JsfAccessibleAdapter(label);
        this.wrapperPreview.getAccessible().addAccessibleListener((AccessibleListener)this.accWrapperPreviewLabel);
    }
}

