/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.ui;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.templates.ContextTypeRegistry;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplateContextType;
import com.ibm.etools.jsf.internal.databind.templates.TaglibDependencies;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.TaglibResolver;
import com.ibm.etools.jsf.internal.databind.templates.ui.EditTemplateDialog;
import com.ibm.etools.jsf.internal.databind.templates.ui.TemplateVariableProcessor;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.TemplateBuffer;
import com.ibm.etools.jsf.internal.templates.framework.TemplateException;
import com.ibm.etools.jsf.internal.templates.framework.TemplateTranslator;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class EditIterativeTemplateDialog
extends EditTemplateDialog {
    protected DataTemplate originalIterativeTemplate;
    protected DataTemplate newIterativeTemplate;
    protected SourceViewer iterativePatternEditor;
    protected TemplateVariableProcessor iterativeTemplateProcessor;
    protected Map<String, String> iterativeTaglibMap;
    private Map<String, EditTemplateDialog.TextViewerAction> iterativeActions = new HashMap<String, EditTemplateDialog.TextViewerAction>(10);

    public EditIterativeTemplateDialog(Shell parent, DataTemplate wrapperTemplate, DataTemplate iterativeTemplate, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry) {
        super(parent, wrapperTemplate, edit, isNameModifiable, registry);
        this.originalIterativeTemplate = iterativeTemplate;
        this.iterativeTemplateProcessor = new TemplateVariableProcessor();
        DataTemplateContextType context = this.contextTypeRegistry.getContextType(iterativeTemplate.getContextTypeId());
        this.iterativeTaglibMap = this.getAvailableTaglibs();
        TaglibDependencies requiredLibs = iterativeTemplate.getRequiredTaglibs();
        if (requiredLibs != null) {
            this.iterativeTaglibMap.putAll(requiredLibs.getDependencyMap());
        }
        ArrayList<TaglibResolver> taglibResolvers = new ArrayList<TaglibResolver>(this.iterativeTaglibMap.size());
        for (String uri : this.iterativeTaglibMap.keySet()) {
            taglibResolvers.add(new TaglibResolver(null, uri, this.iterativeTaglibMap.get(uri), uri));
        }
        context.replaceTaglibResolvers(taglibResolvers);
        this.iterativeTemplateProcessor.setContextType(context);
        this.setHelpId("com.ibm.etools.jsf.EditIterativeTemplateDialog");
    }

    @Override
    protected Control createDialogArea(Composite ancestor) {
        Composite parentComposite = (Composite)super.createDialogArea(ancestor);
        this.patternLabel.setText(Messages.EditIterativeTemplateDialog_WrapperPattern);
        Label iterativePatternLabel = new Label(parentComposite, 0);
        iterativePatternLabel.setText(Messages.EditIterativeTemplateDialog_IterativePattern);
        iterativePatternLabel.setLayoutData((Object)new GridData(2));
        this.iterativePatternEditor = this.createEditor(parentComposite, this.originalIterativeTemplate.getPattern(), this.iterativeTemplateProcessor);
        new Label(parentComposite, 0);
        Composite buttons = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData());
        Button insertVariableButton = new Button(buttons, 0);
        insertVariableButton.setLayoutData((Object)EditIterativeTemplateDialog.getButtonGridData(insertVariableButton));
        insertVariableButton.setText(Messages.EditIterativeTemplateDialog_insert_variable);
        insertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditIterativeTemplateDialog.this.iterativePatternEditor.getTextWidget().setFocus();
                EditIterativeTemplateDialog.this.iterativePatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return parentComposite;
    }

    @Override
    protected void okPressed() {
        DataTemplateContextType context = this.iterativeTemplateProcessor.getContextType();
        HashMap<String, String> usedTaglibMap = new HashMap<String, String>();
        String pattern = this.iterativePatternEditor.getDocument().get();
        try {
            context.validate(pattern);
            TemplateTranslator translator = new TemplateTranslator();
            TemplateBuffer buffer = translator.translate(pattern);
            TemplateVariable[] usedVariables = buffer.getVariables();
            int i = usedVariables.length - 1;
            while (i >= 0) {
                for (Map.Entry<String, String> entry : this.iterativeTaglibMap.entrySet()) {
                    if (!usedVariables[i].getName().equals(entry.getValue())) continue;
                    usedTaglibMap.put(entry.getKey(), entry.getValue());
                    break;
                }
                --i;
            }
        }
        catch (TemplateException e) {
            JsfPlugin.log(e);
        }
        TaglibDependencies libs = new TaglibDependencies(usedTaglibMap);
        String dataType = this.originalIterativeTemplate.getDataType();
        this.newIterativeTemplate = new DataTemplate("", dataType, "", this.originalIterativeTemplate.getContextTypeId(), pattern, false, libs, false, this.originalIterativeTemplate.getId(), this.originalIterativeTemplate.isContributed());
        super.okPressed();
    }

    @Override
    protected void initializeActions() {
        super.initializeActions();
        EditTemplateDialog.TextViewerAction action = new EditTemplateDialog.TextViewerAction(this, (ITextViewer)this.iterativePatternEditor, 1);
        action.setText(Messages.EditTemplateDialog_undo);
        this.iterativeActions.put(ITextEditorActionConstants.UNDO, action);
        action = new EditTemplateDialog.TextViewerAction(this, (ITextViewer)this.iterativePatternEditor, 3);
        action.setText(Messages.EditTemplateDialog_cut);
        this.iterativeActions.put(ITextEditorActionConstants.CUT, action);
        action = new EditTemplateDialog.TextViewerAction(this, (ITextViewer)this.iterativePatternEditor, 4);
        action.setText(Messages.EditTemplateDialog_copy);
        this.iterativeActions.put(ITextEditorActionConstants.COPY, action);
        action = new EditTemplateDialog.TextViewerAction(this, (ITextViewer)this.iterativePatternEditor, 5);
        action.setText(Messages.EditTemplateDialog_paste);
        this.iterativeActions.put(ITextEditorActionConstants.PASTE, action);
        action = new EditTemplateDialog.TextViewerAction(this, (ITextViewer)this.iterativePatternEditor, 7);
        action.setText(Messages.EditTemplateDialog_select_all);
        this.iterativeActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new EditTemplateDialog.TextViewerAction(this, (ITextViewer)this.iterativePatternEditor, 13);
        action.setText(Messages.EditTemplateDialog_content_assist);
        this.iterativeActions.put("ContentAssistProposal", action);
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditIterativeTemplateDialog.this.fillContextMenu(mgr, EditIterativeTemplateDialog.this.iterativeActions);
            }
        });
        StyledText text = this.iterativePatternEditor.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    @Override
    protected void updateAction(String actionId) {
        IAction action = (IAction)this.iterativeActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        super.updateAction(actionId);
    }

    public DataTemplate getNewIterativeTemplate() {
        return this.newIterativeTemplate;
    }
}

