/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.resolvers;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.TemplateProvider;
import com.ibm.etools.jsf.internal.databind.templates.contexts.IterativeContext;
import com.ibm.etools.jsf.internal.databind.templates.contexts.IterativeContextType;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.BaseVariableResolver;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.TemplateBuffer;
import com.ibm.etools.jsf.internal.templates.framework.TemplateContext;
import com.ibm.etools.jsf.internal.templates.framework.TemplateException;
import com.ibm.etools.jsf.internal.templates.framework.TemplateTranslator;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariableResolver;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import org.eclipse.jface.text.BadLocationException;

public class IterativeTemplateResolver
extends TemplateVariableResolver {
    private BaseVariableResolver baseResolver = null;

    public IterativeTemplateResolver(BaseVariableResolver resolver) {
        super("iterativeTemplate", Messages.Databind_Variable_IterativeTemplateDesc);
        this.baseResolver = resolver;
    }

    @Override
    protected String resolve(TemplateContext context) {
        StringBuffer buffer = new StringBuffer();
        try {
            DataTemplate template = TemplateProvider.getActiveIterativeTemplate(null, this.baseResolver.getWrapperTemplate());
            if (template != null) {
                int numNodes = this.baseResolver.getCodeGenModel().getCodeGenNodes().size();
                int nodeIndex = 0;
                while (nodeIndex < numNodes) {
                    ICodeGenNode childNode = (ICodeGenNode)this.baseResolver.getCodeGenModel().getCodeGenNodes().get(nodeIndex);
                    if (childNode.isSelected()) {
                        TemplateTranslator translator = new TemplateTranslator();
                        TemplateBuffer result = translator.translate(template);
                        ICodeGenNode rootNode = this.baseResolver.getCodeGenNode();
                        String parentName = this.baseResolver.getVar();
                        String var = this.baseResolver.getVar();
                        BaseVariableResolver resolver = new BaseVariableResolver(childNode, rootNode, parentName, var, null);
                        IterativeContextType iterativeType = new IterativeContextType(resolver);
                        iterativeType.addResolvers(template.getRequiredTaglibs().createTaglibResolvers(this.baseResolver));
                        this.baseResolver.addLibraryTags(template.getLibraryTags());
                        IterativeContext iterativeContext = new IterativeContext(iterativeType);
                        iterativeType.resolve(result, (TemplateContext)iterativeContext);
                        buffer.append(result.getString());
                    }
                    ++nodeIndex;
                }
            }
            return buffer.toString();
        }
        catch (TemplateException e) {
            JsfPlugin.log(e);
        }
        catch (BadLocationException e) {
            JsfPlugin.log(e);
        }
        return "";
    }
}

