/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.resolvers;

import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.internal.databind.templates.contexts.IterativeContext;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.BaseVariableResolver;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.TemplateContext;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariableResolver;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import java.util.ArrayList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;

public class IdResolver
extends TemplateVariableResolver {
    private BaseVariableResolver baseResolver = null;
    private String pattern = null;
    private int offset = -1;

    public IdResolver(BaseVariableResolver resolver) {
        super("id", Messages.Databind_Variable_IdDesc);
        this.baseResolver = resolver;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setFirstOffset(int firstOffset) {
        this.offset = firstOffset;
    }

    @Override
    protected String resolve(TemplateContext context) {
        String id = new String("");
        String pdnName = ((IBindingAttribute)this.baseResolver.getPageDataNode().getAdapter(IBindingAttribute.ADAPTER_KEY)).getName(this.baseResolver.getPageDataNode());
        String prefix = this.getIdPrefix();
        String suffix = this.getIdSuffix();
        id = this.getId(pdnName, context, prefix, suffix);
        return id;
    }

    protected String getId(String preferredId, TemplateContext context, String idPrefix, String idSuffix) {
        char c;
        String presetId = (String)this.baseResolver.getCodeGenModel().getCustomProperty((Object)"precomputed_id");
        if (!"".equals(presetId) && presetId != null) {
            this.baseResolver.getCodeGenModel().addCustomProperty((Object)"precomputed_id", null);
            return presetId;
        }
        IDOMDocument d = BindingUtil.getDocument(this.baseResolver.getCodeGenModel().getRoot().getEnclosedNode());
        ArrayList<String> newIds = null;
        newIds = (ArrayList<String>)this.baseResolver.getCodeGenModel().getCustomProperty((Object)"id_list");
        if (newIds == null) {
            newIds = new ArrayList<String>();
            this.baseResolver.getCodeGenModel().addCustomProperty((Object)"id_list", newIds);
        }
        String id = JsfComponentUtil.fixupId((String)preferredId);
        id = JsfComponentUtil.generateUniqueId((Document)d, (String)id, newIds);
        int increment = 1;
        int length = id.length();
        if (length > 0 && (increment = Character.getNumericValue(c = id.charAt(length - 1))) <= 0) {
            increment = 1;
        }
        String entireId = String.valueOf(idPrefix) + id + idSuffix;
        while (!JsfComponentUtil.isIdUnique((Document)d, (String)entireId, newIds)) {
            id = String.valueOf(id.substring(0, id.length() - 1)) + ++increment;
            entireId = String.valueOf(idPrefix) + id + idSuffix;
        }
        if (!(context instanceof IterativeContext)) {
            newIds.add(id);
        }
        return id;
    }

    private String getIdPrefix() {
        String prefix = "";
        if (this.offset == -1 || this.pattern == null) {
            return prefix;
        }
        int idQuote = 0;
        int currQuote = this.pattern.indexOf(34);
        while (currQuote < this.offset && currQuote != -1) {
            idQuote = currQuote;
            currQuote = this.pattern.indexOf(34, currQuote + 1);
        }
        int dollarSign = this.pattern.indexOf(36, idQuote);
        if (idQuote == -1 || dollarSign == -1 || idQuote >= dollarSign) {
            return prefix;
        }
        prefix = this.pattern.substring(idQuote + 1, dollarSign);
        return prefix;
    }

    private String getIdSuffix() {
        String suffix = "";
        if (this.offset == -1 || this.pattern == null) {
            return suffix;
        }
        String offsetToEnd = this.pattern.substring(this.offset);
        int endBrace = offsetToEnd.indexOf(125);
        if (endBrace == -1) {
            return suffix;
        }
        String braceToEnd = offsetToEnd.substring(endBrace);
        int endQuote = braceToEnd.indexOf(34);
        if (endQuote == -1) {
            return suffix;
        }
        suffix = braceToEnd.substring(1, endQuote);
        return suffix;
    }
}

