/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.resolvers;

import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.PathType;
import com.ibm.etools.jsf.library.emf.TagLibraryType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;

public class BaseVariableResolver {
    private ICodeGenNode codeGenNode = null;
    private ICodeGenNode rootCodeGenNode = null;
    private ICodeGenModel model = null;
    private String parentBeanName = null;
    private String varAttribute = null;
    private String actionAttribute = null;
    private DataTemplate wrapperTemplate = null;
    private String wrapperValueAttribute = null;
    private Stack<String> varStack;

    public BaseVariableResolver(ICodeGenNode node, ICodeGenNode rootNode, String parentName, String var, String action) {
        this.setCodeGenNode(node);
        this.rootCodeGenNode = rootNode;
        this.parentBeanName = parentName;
        this.varAttribute = var;
        this.actionAttribute = action;
    }

    private void setCodeGenNode(ICodeGenNode node) {
        this.codeGenNode = node;
        this.model = node.isListNode() && node != node.getCodeGenModel().getRoot() ? node.getChildCodeGenModel() : node.getCodeGenModel();
    }

    protected String getTaglibPrefix(String taglibUri, String preferredPrefix) {
        IDOMDocument d = BindingUtil.getDocument(this.getCodeGenModel().getRoot().getEnclosedNode());
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)d);
        String prefix = mapper.getPrefixForUri(taglibUri);
        if (prefix == null) {
            prefix = this.generateUniquePrefix(mapper, preferredPrefix);
            mapper.addMapping(prefix, taglibUri);
            HashMap<String, String> newTaglibs = null;
            newTaglibs = (HashMap<String, String>)this.model.getCustomProperty((Object)"new_taglibs");
            if (newTaglibs == null) {
                newTaglibs = new HashMap<String, String>();
                this.model.addCustomProperty((Object)"new_taglibs", newTaglibs);
            }
            newTaglibs.put(prefix, taglibUri);
            this.addLibraryResources(taglibUri);
        }
        return prefix;
    }

    public void addLibraryTags(Map<String, List<String>> newTags) {
        HashMap<String, List<String>> libraryTags = (HashMap<String, List<String>>)this.model.getCustomProperty((Object)"libraryTags");
        if (libraryTags == null) {
            libraryTags = new HashMap<String, List<String>>();
            this.model.addCustomProperty((Object)"libraryTags", libraryTags);
        }
        for (String libraryUri : newTags.keySet()) {
            List<String> tags = newTags.get(libraryUri);
            if (libraryTags.containsKey(libraryUri)) {
                List existingTags = (List)libraryTags.remove(libraryUri);
                for (String currentTag : tags) {
                    if (existingTags.contains(currentTag)) continue;
                    existingTags.add(currentTag);
                }
                libraryTags.put(libraryUri, existingTags);
                continue;
            }
            libraryTags.put(libraryUri, tags);
        }
    }

    private void addLibraryResources(String taglibUri) {
        TagLibraryType tagLibrary;
        LibraryDefinitionType libraryDef = LibraryManager.getInstance().getLibraryDefinitionModel(taglibUri);
        if (libraryDef != null && (tagLibrary = libraryDef.getTagLibrary()) != null) {
            PathType libStylesheetLinks;
            PathType libJsIncludes = tagLibrary.getJsIncludes();
            if (libJsIncludes != null) {
                for (String jsIncludePath : libJsIncludes.getPath()) {
                    this.addScript(jsIncludePath);
                }
            }
            if ((libStylesheetLinks = tagLibrary.getStylesheetLinks()) != null) {
                for (String stylesheetPath : libStylesheetLinks.getPath()) {
                    this.addStylesheet(stylesheetPath);
                }
            }
        }
    }

    private String generateUniquePrefix(TaglibPrefixUtil mapper, String preferredPrefix) {
        while (mapper.getUriForPrefix(preferredPrefix) != null) {
            preferredPrefix = String.valueOf(preferredPrefix) + "x";
        }
        return preferredPrefix;
    }

    protected IBindingAttribute getBindingAttribute() {
        return (IBindingAttribute)this.getPageDataNode().getAdapter(IBindingAttribute.ADAPTER_KEY);
    }

    protected String computeWrapperValueAttribute() {
        IPageDataNode object;
        String parentBeanName = this.getParentBeanName();
        IPageDataNode pdNode = this.getPageDataNode();
        IBindingAttribute attr = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        if (parentBeanName == null) {
            String beanName = attr.getReferenceString(pdNode);
            beanName = BindingUtil.removeLastIndexReference(beanName);
            return beanName;
        }
        IPageDataNode refNode = this.getRootCodeGenNode().getEnclosedNode();
        if (refNode == (object = pdNode)) {
            return parentBeanName;
        }
        String beanName = attr.getRelativeReferenceString(refNode, object);
        if ("".equals(beanName = BindingUtil.removeLastIndexReference(beanName))) {
            return parentBeanName;
        }
        return String.valueOf(parentBeanName) + "." + beanName;
    }

    public void setupVarStack() {
        this.varStack = (Stack)this.getCodeGenModel().getCustomProperty((Object)"var_stack");
        if (this.varStack == null) {
            this.varStack = new Stack();
            this.getCodeGenModel().addCustomProperty((Object)"var_stack", this.varStack);
        }
        this.wrapperValueAttribute = this.computeWrapperValueAttribute();
        String newVar = BindingUtil.computeVarAttribute(this.wrapperValueAttribute, this.varStack);
        this.varStack.push(newVar);
        this.setVar(newVar);
    }

    public void popVarStack() {
        this.varStack.pop();
    }

    private void addScript(String uri) {
        ArrayList<String> scriptRefs = (ArrayList<String>)this.model.getCustomProperty((Object)"new_script_refs");
        if (scriptRefs == null) {
            scriptRefs = new ArrayList<String>();
            this.model.addCustomProperty((Object)"new_script_refs", scriptRefs);
        }
        if (!scriptRefs.contains(uri)) {
            scriptRefs.add(uri);
        }
    }

    private void addStylesheet(String cssName) {
        ArrayList<String> stylesheets = (ArrayList<String>)this.model.getCustomProperty((Object)"new_stylesheets");
        if (stylesheets == null) {
            stylesheets = new ArrayList<String>();
            this.model.addCustomProperty((Object)"new_stylesheets", stylesheets);
        }
        if (!stylesheets.contains(cssName)) {
            stylesheets.add(cssName);
        }
    }

    protected IPageDataNode getPageDataNode() {
        return this.codeGenNode.getEnclosedNode();
    }

    public ICodeGenNode getCodeGenNode() {
        return this.codeGenNode;
    }

    public ICodeGenModel getCodeGenModel() {
        return this.model;
    }

    protected ICodeGenNode getRootCodeGenNode() {
        return this.rootCodeGenNode;
    }

    protected String getParentBeanName() {
        return this.parentBeanName;
    }

    public String getVar() {
        return this.varAttribute;
    }

    protected DataTemplate getWrapperTemplate() {
        return this.wrapperTemplate;
    }

    protected String getAction() {
        return this.actionAttribute;
    }

    protected String getWrapperValueAttribute() {
        if (this.wrapperValueAttribute == null) {
            this.wrapperValueAttribute = this.computeWrapperValueAttribute();
        }
        return this.wrapperValueAttribute;
    }

    public void setWrapperTemplate(DataTemplate wrapperTemplate) {
        this.wrapperTemplate = wrapperTemplate;
    }

    protected void setRootCodeGenNode(ICodeGenNode r) {
        this.rootCodeGenNode = r;
    }

    protected void setParentBeanName(String parent) {
        this.parentBeanName = parent;
    }

    protected void setVar(String v) {
        this.varAttribute = v;
    }
}

