/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.persistence;

import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.DatabindConstants;
import com.ibm.etools.jsf.internal.databind.templates.ContextTypeRegistry;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.TaglibDependencies;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateContributor;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplatePersistenceData;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateReaderWriter;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.TemplateException;
import com.ibm.etools.jsf.preferences.JsfTagModeUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class TemplateStore {
    private final List<TemplatePersistenceData> fTemplates = new ArrayList<TemplatePersistenceData>();
    protected final Map<String, TemplateContributor> fContributors = new HashMap<String, TemplateContributor>();
    private IPreferenceStore fPreferenceStore;
    private String fKey;
    private ContextTypeRegistry fRegistry;
    private boolean fIgnorePreferenceStoreChanges = false;
    private IPropertyChangeListener fPropertyListener;

    public TemplateStore(IPreferenceStore store, String key) {
        Assert.isNotNull((Object)store);
        Assert.isNotNull((Object)key);
        this.fPreferenceStore = store;
        this.fKey = key;
    }

    public TemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key) {
        this(store, key);
        this.fRegistry = registry;
    }

    public void load() throws IOException {
        this.fTemplates.clear();
        this.fContributors.clear();
        this.loadContributedTemplates();
        this.loadCustomTemplates();
    }

    public final void startListeningForPreferenceChanges() {
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (!TemplateStore.this.fIgnorePreferenceStoreChanges && TemplateStore.this.fKey.equals(event.getProperty())) {
                        try {
                            TemplateStore.this.load();
                        }
                        catch (IOException x) {
                            JsfPlugin.log(x);
                        }
                    }
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPropertyListener);
        }
    }

    public final void stopListeningForPreferenceChanges() {
        if (this.fPropertyListener != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    protected void loadContributedTemplates() throws IOException {
    }

    protected boolean internalAddContributedTemplate(TemplatePersistenceData data) {
        if (!data.isCustom()) {
            String id = data.getId();
            for (TemplatePersistenceData d2 : this.fTemplates) {
                if (d2.getId() == null || !d2.getId().equals(id)) continue;
                return false;
            }
            this.fTemplates.add(data);
            return true;
        }
        return false;
    }

    public void save() throws IOException {
        ArrayList<TemplatePersistenceData> custom = new ArrayList<TemplatePersistenceData>();
        for (TemplatePersistenceData data : this.fTemplates) {
            if (!data.isCustom() || data.isUserAdded() && data.isDeleted()) continue;
            custom.add(data);
        }
        StringWriter output = new StringWriter();
        TemplateReaderWriter writer = new TemplateReaderWriter();
        writer.save(custom.toArray(new TemplatePersistenceData[custom.size()]), output);
        this.fIgnorePreferenceStoreChanges = true;
        try {
            this.fPreferenceStore.setValue(this.fKey, output.toString());
            if (this.fPreferenceStore instanceof IPersistentPreferenceStore) {
                ((IPersistentPreferenceStore)this.fPreferenceStore).save();
            }
        }
        finally {
            this.fIgnorePreferenceStoreChanges = false;
        }
    }

    public void addCustomizedTemplate(TemplatePersistenceData newData) {
        TemplatePersistenceData data = this.configureCustomizedTemplate(newData);
        if (data != null) {
            TemplateContributor customContributor = this.fContributors.get("com.ibm.etools.jsf.custom.template.contributor");
            if (customContributor == null) {
                customContributor = this.addCustomTemplateContributor();
            }
            customContributor.addTemplateData(data);
        }
    }

    private TemplatePersistenceData configureCustomizedTemplate(TemplatePersistenceData newData) {
        if (!this.validateTemplate(newData.getTemplate())) {
            return null;
        }
        for (TemplatePersistenceData d : this.fTemplates) {
            if (!d.getId().equals(newData.getId())) continue;
            if (d.isContributed()) {
                newData.setContributed(true);
            }
            d.setTemplate(newData.getTemplate());
            d.setDeleted(newData.isDeleted());
            d.setEnabled(newData.isEnabled());
            return d;
        }
        newData.setContributed(false);
        this.fTemplates.add(newData);
        return newData;
    }

    public void delete(TemplatePersistenceData data) {
        if (data.isUserAdded()) {
            this.fTemplates.remove(data);
        } else {
            data.setDeleted(true);
        }
    }

    public void restoreDeleted() {
        for (TemplatePersistenceData data : this.fTemplates) {
            if (!data.isDeleted()) continue;
            data.setDeleted(false);
        }
    }

    public void restoreDefaults() {
        try {
            this.fIgnorePreferenceStoreChanges = true;
            this.fPreferenceStore.setToDefault(this.fKey);
        }
        finally {
            this.fIgnorePreferenceStoreChanges = false;
        }
        try {
            this.load();
        }
        catch (IOException x) {
            JsfPlugin.log(x);
        }
    }

    public Map<String, TemplatePersistenceData> getAllTemplatesFromContributor(String contributorId, String contextTypeId, boolean includeDeleted) {
        HashMap<String, TemplatePersistenceData> allTemplates = new HashMap<String, TemplatePersistenceData>();
        TemplateContributor contributor = this.fContributors.get(contributorId);
        if (contributor != null) {
            List<TemplatePersistenceData> templates = contributor.getTemplates();
            for (TemplatePersistenceData data : templates) {
                if (contextTypeId != null && !contextTypeId.equals(data.getTemplate().getContextTypeId()) || !includeDeleted && data.isDeleted()) continue;
                allTemplates.put(data.getId(), data);
            }
        }
        return Collections.unmodifiableMap(allTemplates);
    }

    public Map<String, TemplatePersistenceData> getAllTemplates(String contextTypeId, boolean includeDeleted) {
        HashMap<String, TemplatePersistenceData> allTemplates = new HashMap<String, TemplatePersistenceData>();
        for (TemplatePersistenceData data : this.fTemplates) {
            if (contextTypeId != null && !contextTypeId.equals(data.getTemplate().getContextTypeId()) || !includeDeleted && data.isDeleted()) continue;
            allTemplates.put(data.getId(), data);
        }
        return Collections.unmodifiableMap(allTemplates);
    }

    public TemplatePersistenceData getIterativeTemplate(String contributorId, DataTemplate wrapperTemplate) {
        List<TemplatePersistenceData> templates = null;
        if (contributorId != null) {
            TemplateContributor contributor = this.fContributors.get(contributorId);
            if (contributor != null) {
                templates = contributor.getTemplates();
            }
        } else {
            templates = this.fTemplates;
        }
        for (TemplatePersistenceData data : templates) {
            if (!"jsf_iterative".equals(data.getTemplate().getContextTypeId()) || !data.getTemplate().getDataType().equals(wrapperTemplate.getId())) continue;
            return data;
        }
        return null;
    }

    private Map<String, DataTemplate> getActiveTemplates(String contextTypeId) {
        HashMap<String, DataTemplate> templates = new HashMap<String, DataTemplate>();
        this.findActiveTemplates(templates, this.fTemplates, contextTypeId);
        this.addDefaultTemplate(templates);
        return Collections.unmodifiableMap(templates);
    }

    private void addDefaultTemplate(Map<String, DataTemplate> templates) {
        String pattern = "<${h}:outputText styleClass=\"outputText\" id=\"${id}\" value=\"#{${value}}\"></${h}:outputText>";
        String taglibs = "h:http://java.sun.com/jsf/html";
        boolean contributed = true;
        DataTemplate defaultTemplate = new DataTemplate(Messages.Default_Template_Name, "NA", Messages.Default_Template_Description, "jsf_property", pattern, false, new TaglibDependencies(taglibs), false, "jsf.default.outputText", contributed);
        templates.put(defaultTemplate.getId(), defaultTemplate);
    }

    public TemplatePersistenceData[] getTemplateData(boolean includeDeleted) {
        ArrayList<TemplatePersistenceData> datas = new ArrayList<TemplatePersistenceData>();
        for (TemplatePersistenceData data : this.fTemplates) {
            if (!includeDeleted && data.isDeleted()) continue;
            datas.add(data);
        }
        return datas.toArray(new TemplatePersistenceData[datas.size()]);
    }

    private void loadCustomTemplates() throws IOException {
        StringReader input;
        TemplateReaderWriter reader;
        TemplatePersistenceData[] datas;
        String pref = this.fPreferenceStore.getString(this.fKey);
        if (pref != null && pref.trim().length() > 0 && (datas = (reader = new TemplateReaderWriter()).read(input = new StringReader(pref))).length > 0) {
            int i = 0;
            while (i < datas.length) {
                TemplatePersistenceData data = datas[i];
                this.addCustomizedTemplate(data);
                ++i;
            }
        }
    }

    private TemplateContributor addCustomTemplateContributor() {
        String id = "com.ibm.etools.jsf.custom.template.contributor";
        String name = Messages.TemplateStore_custom_name;
        String description = Messages.TemplateStore_custom_desc;
        String type = "custom";
        TemplateContributor c = new TemplateContributor(id, name, description, type);
        this.fContributors.put(id, c);
        return c;
    }

    private boolean validateTemplate(DataTemplate template) {
        String contextTypeId = template.getContextTypeId();
        if (this.contextExists(contextTypeId)) {
            if (this.fRegistry != null) {
                try {
                    this.fRegistry.getContextType(contextTypeId).validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean contextExists(String contextTypeId) {
        return contextTypeId != null && (this.fRegistry == null || this.fRegistry.getContextType(contextTypeId) != null);
    }

    protected final ContextTypeRegistry getRegistry() {
        return this.fRegistry;
    }

    public final Map<String, TemplateContributor> getContributors() {
        return this.fContributors;
    }

    public Map<String, DataTemplate> getActiveTemplates(IProject project, String contextTypeId) {
        if (project == null) {
            return this.getActiveTemplates(contextTypeId);
        }
        return this.getActiveTemplatesForProject(project, contextTypeId);
    }

    private Map<String, DataTemplate> getActiveTemplatesForProject(IProject project, String contextTypeId) {
        HashMap<String, DataTemplate> templates = new HashMap<String, DataTemplate>();
        this.addDefaultTemplate(templates);
        TreeMap<Integer, String> extensionContributors = new TreeMap<Integer, String>();
        ArrayList<String> libraryContributors = new ArrayList<String>();
        this.sortTemplateContributors(extensionContributors, libraryContributors);
        this.getActiveExtensionPointTemplates(templates, extensionContributors, project, contextTypeId);
        this.getActiveLibraryTemplates(templates, libraryContributors, project, contextTypeId);
        this.getActiveCustomTemplates(templates, project, contextTypeId);
        return Collections.unmodifiableMap(templates);
    }

    private void sortTemplateContributors(Map<Integer, String> extensionContributors, List<String> libraryContributors) {
        for (String obj : this.fContributors.keySet()) {
            String key = obj;
            TemplateContributor t = this.fContributors.get(key);
            if ("extensionPoint".equals(t.getType())) {
                extensionContributors.put(t.getPriority(), t.getId());
                continue;
            }
            if (!"libraryDefinition".equals(t.getType())) continue;
            libraryContributors.add(t.getId());
        }
    }

    private void getActiveExtensionPointTemplates(Map<String, DataTemplate> templates, Map<Integer, String> extensionContributors, IProject project, String contextTypeId) {
        for (String id : extensionContributors.values()) {
            String facet;
            TemplateContributor extensionContributor = this.fContributors.get(id);
            if (extensionContributor == null || "jsf.base".equals(facet = extensionContributor.getFacet()) && this.hasInstalledFacet(project, "jsf.ibm") || !this.hasInstalledFacet(project, facet)) continue;
            List<TemplatePersistenceData> extensionTemplateData = extensionContributor.getTemplates();
            this.findActiveTemplates(templates, extensionTemplateData, contextTypeId);
        }
    }

    private void getActiveLibraryTemplates(Map<String, DataTemplate> templates, List<String> libraryContributors, IProject project, String contextTypeId) {
        for (String id : libraryContributors) {
            TemplateContributor libraryContributor = this.fContributors.get(id);
            List<TemplatePersistenceData> libraryTemplateData = libraryContributor.getTemplates();
            this.findActiveTemplates(templates, libraryTemplateData, contextTypeId);
        }
    }

    private void getActiveCustomTemplates(Map<String, DataTemplate> templates, IProject project, String contextTypeId) {
        TemplateContributor custom = this.fContributors.get("com.ibm.etools.jsf.custom.template.contributor");
        if (custom != null) {
            List<TemplatePersistenceData> customTemplateData = custom.getTemplates();
            boolean enhancedProject = true;
            if (!JsfTagModeUtil.isUsingIbmTags(project)) {
                enhancedProject = false;
            }
            for (TemplatePersistenceData newData : customTemplateData) {
                if (newData.isContributed()) {
                    HashMap<String, DataTemplate> currentTemplates = new HashMap<String, DataTemplate>();
                    for (String id : templates.keySet()) {
                        DataTemplate template = templates.get(id);
                        currentTemplates.put(id, template);
                    }
                    for (String d : currentTemplates.keySet()) {
                        if (!d.equals(newData.getId())) continue;
                        if (newData.isDeleted() || !newData.isEnabled()) {
                            templates.remove(d);
                            continue;
                        }
                        templates.remove(d);
                        templates.put(newData.getId(), newData.getTemplate());
                    }
                    continue;
                }
                if (!newData.isEnabled() || newData.isDeleted() || contextTypeId != null && !contextTypeId.equals(newData.getTemplate().getContextTypeId())) continue;
                boolean useTemplate = true;
                if (!enhancedProject) {
                    TaglibDependencies td = newData.getTemplate().getRequiredTaglibs();
                    Map<String, String> taglibs = td.getDependencyMap();
                    for (String uri : taglibs.keySet()) {
                        if (!StringUtil.belongsTo((String)uri, (String[])DatabindConstants.EXTENDED_TAGLIBS)) continue;
                        useTemplate = false;
                    }
                }
                if (!useTemplate) continue;
                templates.put(newData.getId(), newData.getTemplate());
            }
        }
    }

    private void findActiveTemplates(Map<String, DataTemplate> activeTemplates, List<TemplatePersistenceData> allTemplates, String contextTypeId) {
        for (TemplatePersistenceData data : allTemplates) {
            if (!data.isEnabled() || data.isDeleted() || contextTypeId != null && !contextTypeId.equals(data.getTemplate().getContextTypeId())) continue;
            activeTemplates.put(data.getId(), data.getTemplate());
        }
    }

    private boolean hasInstalledFacet(IProject project, String facet) {
        block4: {
            try {
                if (project != null) break block4;
                return false;
            }
            catch (Exception exception) {}
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)facet)) {
            IProjectFacet jsfFacet = ProjectFacetsManager.getProjectFacet((String)facet);
            return facetedProject.hasProjectFacet(jsfFacet);
        }
        return false;
    }
}

