/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.persistence;

import com.ibm.etools.jsf.internal.databind.DatabindConstants;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplatePersistenceData;
import com.ibm.etools.jsf.support.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class TemplateContributor {
    private final String fId;
    private final String fName;
    private final String fDescription;
    private final String fType;
    private Integer fPriority;
    private String fFacet;
    private final List<TemplatePersistenceData> fTemplates;

    public TemplateContributor(String id, String name, String desc, String type) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)desc);
        Assert.isNotNull((Object)type);
        Assert.isTrue((boolean)this.isValidType(type));
        this.fId = id;
        this.fName = name;
        this.fDescription = desc;
        this.fType = type;
        this.fTemplates = new ArrayList<TemplatePersistenceData>();
        this.fPriority = 0;
        this.fFacet = "";
    }

    private boolean isValidType(String type) {
        return StringUtil.belongsTo(type, DatabindConstants.CONTRIBUTION_TYPES);
    }

    public void addTemplateData(TemplatePersistenceData t) {
        this.fTemplates.add(t);
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getType() {
        return this.fType;
    }

    public Integer getPriority() {
        return this.fPriority;
    }

    public void setPriority(Integer priority) {
        this.fPriority = priority;
    }

    public String getFacet() {
        return this.fFacet;
    }

    public void setFacet(String facet) {
        this.fFacet = facet;
    }

    public List<TemplatePersistenceData> getTemplates() {
        return this.fTemplates;
    }
}

