/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.BindingCompoundCommand;
import com.ibm.etools.jsf.internal.databind.CommandUtil;
import com.ibm.etools.jsf.internal.databind.LibraryBindingUtil;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.TemplateProvider;
import com.ibm.etools.jsf.internal.databind.templates.contexts.IterativeContext;
import com.ibm.etools.jsf.internal.databind.templates.contexts.IterativeContextType;
import com.ibm.etools.jsf.internal.databind.templates.contexts.PropertyContext;
import com.ibm.etools.jsf.internal.databind.templates.contexts.PropertyContextType;
import com.ibm.etools.jsf.internal.databind.templates.contexts.WrapperContext;
import com.ibm.etools.jsf.internal.databind.templates.contexts.WrapperContextType;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.BaseVariableResolver;
import com.ibm.etools.jsf.internal.templates.framework.TemplateBuffer;
import com.ibm.etools.jsf.internal.templates.framework.TemplateContext;
import com.ibm.etools.jsf.internal.templates.framework.TemplateException;
import com.ibm.etools.jsf.internal.templates.framework.TemplateTranslator;
import com.ibm.etools.jsf.library.emf.ChildTagsTemplateType;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.PathType;
import com.ibm.etools.jsf.library.emf.TagLibraryType;
import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TemplateGenerator {
    private BaseVariableResolver baseResolver = null;

    public void setBaseResolver(BaseVariableResolver baseResolver) {
        this.baseResolver = baseResolver;
    }

    public TemplateGenerator(BaseVariableResolver resolver) {
        this.baseResolver = resolver;
    }

    public StringBuffer resolveWrapperTemplates() {
        StringBuffer result = new StringBuffer("");
        try {
            DataTemplate t;
            if (!this.baseResolver.getCodeGenNode().isListNode()) {
                String controlId = (String)this.baseResolver.getCodeGenNode().getCodeGenModel().getCustomProperty((Object)"objectFormatting");
                t = TemplateProvider.getActiveWrapperTemplates(null).get(controlId);
            } else {
                t = TemplateProvider.getActiveWrapperTemplates(null).get(this.baseResolver.getCodeGenNode().getControlId());
            }
            if (t == null) {
                return result;
            }
            this.baseResolver.setWrapperTemplate(t);
            TemplateTranslator translator = new TemplateTranslator();
            TemplateBuffer templateBuffer = translator.translate(t);
            WrapperContextType wrapperType = new WrapperContextType(this.baseResolver);
            wrapperType.addResolvers(t.getRequiredTaglibs().createTaglibResolvers(this.baseResolver));
            this.baseResolver.addLibraryTags(t.getLibraryTags());
            WrapperContext wrapperContext = new WrapperContext(wrapperType);
            CommandUtil.setupIdResolver(templateBuffer, wrapperType, t);
            wrapperType.resolve(templateBuffer, (TemplateContext)wrapperContext);
            result.append(templateBuffer.getString());
            return result;
        }
        catch (TemplateException e) {
            JsfPlugin.log(e);
        }
        catch (BadLocationException e) {
            JsfPlugin.log(e);
        }
        return result;
    }

    public String resolvePropertyTemplates() {
        DataTemplate t;
        block4: {
            t = TemplateProvider.getActivePropertyTemplates(null).get(this.baseResolver.getCodeGenNode().getControlId());
            if (t != null) break block4;
            return "";
        }
        try {
            TemplateTranslator translator = new TemplateTranslator();
            TemplateBuffer buffer = translator.translate(t);
            PropertyContextType propertyType = new PropertyContextType(this.baseResolver);
            propertyType.addResolvers(t.getRequiredTaglibs().createTaglibResolvers(this.baseResolver));
            this.baseResolver.addLibraryTags(t.getLibraryTags());
            PropertyContext propertyContext = new PropertyContext(propertyType);
            CommandUtil.setupIdResolver(buffer, propertyType, t);
            propertyType.resolve(buffer, (TemplateContext)propertyContext);
            return buffer.getString();
        }
        catch (BadLocationException e) {
            JsfPlugin.log(e);
        }
        catch (TemplateException e) {
            JsfPlugin.log(e);
        }
        return "";
    }

    public String generateChildControls(String tagName, String uri, BindingCompoundCommand compoundCommand, Node target) {
        StringBuffer buffer = new StringBuffer();
        DataTemplate iterativeTemplate = null;
        TagType tagType = LibraryManager.getInstance().getTagModel(uri, tagName);
        if (tagType == null) {
            return "";
        }
        ChildTagsTemplateType childType = tagType.getChildTags();
        if (childType != null) {
            iterativeTemplate = LibraryBindingUtil.createTemplateInstance(childType);
        }
        if (iterativeTemplate == null) {
            return "";
        }
        int numNodes = this.baseResolver.getCodeGenModel().getCodeGenNodes().size();
        try {
            int nodeIndex = 0;
            while (nodeIndex < numNodes) {
                ICodeGenNode childNode = (ICodeGenNode)this.baseResolver.getCodeGenModel().getCodeGenNodes().get(nodeIndex);
                if (childNode.isSelected()) {
                    TemplateTranslator translator = new TemplateTranslator();
                    TemplateBuffer result = translator.translate(iterativeTemplate);
                    ICodeGenNode rootNode = this.baseResolver.getCodeGenNode();
                    String parentName = this.baseResolver.getVar();
                    String var = this.baseResolver.getVar();
                    BaseVariableResolver resolver = new BaseVariableResolver(childNode, rootNode, parentName, var, null);
                    IterativeContextType iterativeType = new IterativeContextType(resolver);
                    iterativeType.addResolvers(iterativeTemplate.getRequiredTaglibs().createTaglibResolvers(this.baseResolver));
                    this.baseResolver.addLibraryTags(iterativeTemplate.getLibraryTags());
                    IterativeContext iterativeContext = new IterativeContext(iterativeType);
                    CommandUtil.setupIdResolver(result, iterativeType, iterativeTemplate);
                    iterativeType.resolve(result, (TemplateContext)iterativeContext);
                    buffer.append(result.getString());
                }
                ++nodeIndex;
            }
            this.addResources(this.baseResolver.getCodeGenModel(), compoundCommand, target);
            return buffer.toString();
        }
        catch (TemplateException e) {
            JsfPlugin.log(e);
        }
        catch (BadLocationException e) {
            JsfPlugin.log(e);
        }
        return "";
    }

    private void addResources(ICodeGenModel model, BindingCompoundCommand parentCompoundCommand, Node target) {
        IDOMModel dom;
        IDOMDocument doc = null;
        HTMLEditDomain editDomain = EditDomainUtil.getEditDomain();
        if (editDomain != null && (dom = editDomain.getActiveModel()) != null) {
            doc = dom.getDocument();
        }
        if (doc == null || model == null || parentCompoundCommand == null) {
            return;
        }
        this.addNewTaglibs((Document)doc, model);
        this.addScriptReferences((Document)doc, model);
        this.addStylesheets((Document)doc, model);
        this.addLibraryTagResources((Document)doc, model);
        if (Boolean.TRUE == model.getCustomProperty((Object)"requires_form") || model.getControlType() == 2 || model.getControlType() == 1) {
            BindingCompoundCommand c = new BindingCompoundCommand("");
            boolean formNeeded = JsfCommandUtil.insertForm(c, target);
            parentCompoundCommand.setNewForm(formNeeded);
            c.execute();
        } else {
            parentCompoundCommand.setReparentForm(false);
        }
    }

    private void addNewTaglibs(Document doc, ICodeGenModel model) {
        Map newTaglibs = (Map)model.getCustomProperty((Object)"new_taglibs");
        if (newTaglibs != null) {
            for (String prefix : newTaglibs.keySet()) {
                String uri = (String)newTaglibs.get(prefix);
                HTMLCommand cmd = JsfCommandUtil.getTaglibInsertCommand(uri, prefix);
                cmd.execute();
                IProject prj = JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)doc));
                WizardUtil.addTaglibResources(prj, uri);
            }
        }
    }

    private void addScriptReferences(Document doc, ICodeGenModel model) {
        ArrayList scriptRefs = (ArrayList)model.getCustomProperty((Object)"new_script_refs");
        if (scriptRefs == null) {
            scriptRefs = new ArrayList();
        }
        int i = 0;
        while (i < scriptRefs.size()) {
            this.checkAndAddScriptRef(doc, (String)scriptRefs.get(i));
            ++i;
        }
    }

    private void addStylesheets(Document doc, ICodeGenModel model) {
        ArrayList stylesheets = (ArrayList)model.getCustomProperty((Object)"new_stylesheets");
        if (stylesheets == null) {
            stylesheets = new ArrayList();
        }
        int i = 0;
        while (i < stylesheets.size()) {
            this.checkAndAddStylesheet(doc, (String)stylesheets.get(i));
            ++i;
        }
        BindingCompoundCommand compoundCommand = new BindingCompoundCommand("");
        JsfCommandUtil.addStandardJsfStylesheets(doc, compoundCommand);
        compoundCommand.execute();
    }

    private void addLibraryTagResources(Document d, ICodeGenModel model) {
        Map libraryTagMap = (Map)model.getCustomProperty((Object)"libraryTags");
        if (libraryTagMap == null || libraryTagMap.isEmpty()) {
            return;
        }
        for (String libraryUri : libraryTagMap.keySet()) {
            TagLibraryType tagLibrary;
            List newTags = (List)libraryTagMap.get(libraryUri);
            LibraryDefinitionType libraryDef = LibraryManager.getInstance().getLibraryDefinitionModel(libraryUri);
            if (libraryDef == null || (tagLibrary = libraryDef.getTagLibrary()) == null) continue;
            block1: for (String currentTag : newTags) {
                for (TagType tag : tagLibrary.getTag()) {
                    PathType stylesheetLinks;
                    if (!currentTag.equals(tag.getName())) continue;
                    if (tag.getDropInfo() == null) continue block1;
                    PathType jsIncludes = tag.getDropInfo().getJsIncludes();
                    if (jsIncludes != null) {
                        for (String jsIncludePath : jsIncludes.getPath()) {
                            this.checkAndAddScriptRef(d, jsIncludePath);
                        }
                    }
                    if ((stylesheetLinks = tag.getDropInfo().getStylesheetLinks()) == null) continue block1;
                    for (String stylesheetPath : stylesheetLinks.getPath()) {
                        this.checkAndAddStylesheet(d, stylesheetPath);
                    }
                    continue block1;
                }
            }
        }
    }

    private void checkAndAddScriptRef(Document d, String scriptUri) {
        BindingCompoundCommand compoundCommand = new BindingCompoundCommand("");
        JsfCommandUtil.checkAndAddScriptRef(d, compoundCommand, scriptUri);
        compoundCommand.execute();
    }

    private void checkAndAddStylesheet(Document d, String cssName) {
        BindingCompoundCommand compoundCommand = new BindingCompoundCommand("");
        JsfCommandUtil.checkAndAddStylesheet(d, compoundCommand, cssName);
        compoundCommand.execute();
    }
}

