/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.templates.ContextTypeRegistry;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplateContextType;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariableResolver;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ContributionContextTypeRegistry
extends ContextTypeRegistry {
    private static final String TEMPLATES_EXTENSION_POINT = "com.ibm.etools.jsf.templates";
    private static final String CONTEXT_TYPE = "contextType";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String RESOLVER = "resolver";
    private static final String CONTEXT_TYPE_ID = "contextTypeId";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";

    public void addContextType(String id) {
        Assert.isNotNull((Object)id);
        if (this.getContextType(id) != null) {
            return;
        }
        DataTemplateContextType type = ContributionContextTypeRegistry.createContextType(id);
        if (type != null) {
            this.addContextType(type);
        }
    }

    public static DataTemplateContextType createContextType(String id) {
        DataTemplateContextType type;
        Assert.isNotNull((Object)id);
        IConfigurationElement[] extensions = ContributionContextTypeRegistry.getTemplateExtensions();
        try {
            type = ContributionContextTypeRegistry.createContextType(extensions, id);
            if (type != null) {
                TemplateVariableResolver[] resolvers = ContributionContextTypeRegistry.createResolvers(extensions, id);
                int i = 0;
                while (i < resolvers.length) {
                    type.addResolver(resolvers[i]);
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            JsfPlugin.log(e);
            type = null;
        }
        return type;
    }

    private static DataTemplateContextType createContextType(IConfigurationElement[] extensions, String contextTypeId) throws CoreException {
        int i = 0;
        while (i < extensions.length) {
            String id;
            if (extensions[i].getName().equals(CONTEXT_TYPE) && contextTypeId.equals(id = extensions[i].getAttribute(ID))) {
                return ContributionContextTypeRegistry.createContextType(extensions[i]);
            }
            ++i;
        }
        return null;
    }

    private static TemplateVariableResolver[] createResolvers(IConfigurationElement[] extensions, String contextTypeId) {
        ArrayList<TemplateVariableResolver> resolvers = new ArrayList<TemplateVariableResolver>();
        int i = 0;
        while (i < extensions.length) {
            String declaredId;
            if (extensions[i].getName().equals(RESOLVER) && contextTypeId.equals(declaredId = extensions[i].getAttribute(CONTEXT_TYPE_ID))) {
                try {
                    TemplateVariableResolver resolver = ContributionContextTypeRegistry.createResolver(extensions[i]);
                    if (resolver != null) {
                        resolvers.add(resolver);
                    }
                }
                catch (CoreException e) {
                    JsfPlugin.log(e);
                }
            }
            ++i;
        }
        return resolvers.toArray(new TemplateVariableResolver[resolvers.size()]);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private static DataTemplateContextType createContextType(IConfigurationElement element) throws CoreException {
        String id = element.getAttribute(ID);
        try {
            DataTemplateContextType contextType = (DataTemplateContextType)element.createExecutableExtension(CLASS);
            String name = element.getAttribute(NAME);
            if (name == null) {
                name = id;
            }
            if (contextType.getId() == null) {
                contextType.setId(id);
            }
            if (contextType.getName() == null) {
                contextType.setName(name);
            }
            return contextType;
        }
        catch (ClassCastException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, "extension does not implement " + DataTemplateContextType.class.getName(), (Throwable)e));
        }
    }

    private static TemplateVariableResolver createResolver(IConfigurationElement element) throws CoreException {
        try {
            String type = element.getAttribute(TYPE);
            if (type != null) {
                TemplateVariableResolver resolver = (TemplateVariableResolver)element.createExecutableExtension(CLASS);
                resolver.setType(type);
                String desc = element.getAttribute(DESCRIPTION);
                resolver.setDescription(desc == null ? "" : desc);
                return resolver;
            }
        }
        catch (ClassCastException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, "extension does not implement " + TemplateVariableResolver.class.getName(), (Throwable)e));
        }
        return null;
    }
}

