/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.commands;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.adapters.IJsfDataAdapter;
import com.ibm.etools.jsf.databind.adapters.ITagDefinition;
import com.ibm.etools.jsf.databind.commands.AbstractDataBindCommand;
import com.ibm.etools.jsf.databind.commands.builder.BindingContext;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.databind.commands.builder.IJsfCommandPreviewer;
import com.ibm.etools.jsf.internal.databind.BindingCompoundCommand;
import com.ibm.etools.jsf.internal.databind.templates.TemplateGenerator;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.BaseVariableResolver;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.support.StringUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.jsf.util.constants.BasicTags;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedataview.javabean.ContainedTypePageDataNode;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class BindMainAttributeCommand
extends AbstractDataBindCommand
implements IJsfCommandPreviewer {
    private static final String VALUE_HOLDER_CLASSNAME = "javax.faces.component.ValueHolder";
    private boolean multiValuedReference = false;
    private Node target;
    private String varToSet;
    private boolean generateChildControls;
    private BindingCompoundCommand compoundCommand;

    public BindMainAttributeCommand(Node targetNode, boolean multiValued, String varToSet, boolean generateChildren, BindingCompoundCommand compoundCommand) {
        this.target = targetNode;
        this.multiValuedReference = multiValued;
        this.varToSet = varToSet;
        this.generateChildControls = generateChildren;
        this.compoundCommand = compoundCommand;
    }

    @Override
    protected boolean isValidTarget(Node node) {
        return JsfComponentUtil.isJsfTag((Node)node) || JsfComponentUtil.isConverterTag((Node)node) || JsfComponentUtil.isValidatorTag((Node)node);
    }

    @Override
    protected void doDataBind() {
        if (this.generateChildControls) {
            if (this.launchWizard()) {
                this.bindAttributes();
                this.addChildren();
            }
        } else {
            this.bindAttributes();
        }
    }

    private void bindAttributes() {
        String attributeName;
        BindingContext context = this.getBindingContext();
        Element tag = (Element)this.getTargetNode();
        if (!this.allowsAttribute(tag, attributeName = context.getTargetAttribute())) {
            return;
        }
        IPageDataNode bindToNode = null;
        String ref = null;
        int numProperties = context.getPropertyNames().length;
        if (context.getPropertyNames() != null && numProperties == 1) {
            if (this.multiValuedReference && context.getBeanNode().getChildren() != null && context.getBeanNode().getChildren().size() == 1 && !((ICodeGenNode)context.getModel().getCodeGenNodes().get(0)).isListNode()) {
                ref = context.getBeanName();
                bindToNode = context.getBeanNode();
            } else {
                ref = context.getFullPropertyNames()[0];
                bindToNode = context.getPropertyNodes()[0];
            }
        } else {
            IPageDataNode beanNode = context.getBeanNode();
            if (BindingUtil.hasChildren(beanNode) && numProperties > 0) {
                if (beanNode.getChildren().size() > 1) {
                    ref = context.getBeanName();
                    bindToNode = context.getBeanNode();
                } else {
                    IPageDataNode firstChild;
                    boolean containedTypeCase = false;
                    if (beanNode.getChildren().size() == 1 && (firstChild = (IPageDataNode)beanNode.getChildren().get(0)) instanceof ContainedTypePageDataNode) {
                        containedTypeCase = true;
                        if (firstChild.getChildren().size() > 1) {
                            ref = context.getBeanName();
                            bindToNode = context.getBeanNode();
                        } else {
                            ref = context.getFullPropertyNames()[0];
                            bindToNode = context.getPropertyNodes()[0];
                        }
                    }
                    if (!containedTypeCase) {
                        ref = context.getFullPropertyNames()[0];
                        bindToNode = context.getPropertyNodes()[0];
                    }
                }
            } else {
                ref = context.getBeanName();
                bindToNode = context.getBeanNode();
            }
        }
        if (ref != null) {
            if (!this.multiValuedReference) {
                tag.setAttribute(attributeName, BindingUtil.makeVbl(ref));
            } else {
                tag.setAttribute(attributeName, BindingUtil.makeVbl(BindingUtil.removeLastIndexReference(ref)));
            }
        }
        if ("value".equals(context.getTargetAttribute()) && JsfComponentUtil.checkComponentSuperclass((Node)tag, (String)VALUE_HOLDER_CLASSNAME) && !StringUtil.belongsTo(tag.getLocalName(), BasicTags.SELECT_TAGS) && !"selectBooleanCheckbox".equals(tag.getLocalName())) {
            this.setConverter(bindToNode);
        }
    }

    private void addChildren() {
        BindingContext context = this.getBindingContext();
        if (context == null) {
            return;
        }
        ICodeGenModel model = context.getModel();
        Document doc = this.target.getOwnerDocument();
        String prefix = this.target.getPrefix();
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        if (mapper == null) {
            return;
        }
        String uri = mapper.getUriForPrefix(prefix);
        BaseVariableResolver baseResolver = new BaseVariableResolver(model.getRoot(), model.getRoot(), null, this.varToSet, null);
        TemplateGenerator generator = new TemplateGenerator(baseResolver);
        String childTags = generator.generateChildControls(this.target.getLocalName(), uri, this.compoundCommand, this.target);
        Range newRange = null;
        NodeList existingChildren = this.target.getChildNodes();
        int numChildren = existingChildren.getLength();
        if (numChildren == 0) {
            newRange = this.getRange();
        } else {
            newRange = ((DocumentRange)((Object)this.target.getOwnerDocument())).createRange();
            Node appendAfterNode = existingChildren.item(numChildren - 1);
            newRange.setStartAfter(appendAfterNode);
            newRange.setEndAfter(appendAfterNode);
        }
        if (childTags == null || "".equals(childTags)) {
            return;
        }
        int start = SelectionUtil.calcFlatModelOffset((IDOMNode)((IDOMNode)newRange.getStartContainer()), (int)newRange.getStartOffset());
        Document d = JsfCommandUtil.getDocument(this.target);
        try {
            ((IDOMDocument)d).getStructuredDocument().replace(start, 0, childTags);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    private boolean launchWizard() {
        BindingContext context = this.getBindingContext();
        if (context == null) {
            return false;
        }
        ICodeGenModel model = context.getModel();
        if (model == null) {
            return false;
        }
        try {
            CodeGenModelFactory.configureInWizard((ICodeGenModel)model);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void setConverter(IPageDataNode bindToNode) {
        IJsfDataAdapter adapter = (IJsfDataAdapter)bindToNode.getAdapter(IJsfDataAdapter.ADAPTER_KEY);
        if (adapter == null) {
            return;
        }
        String converterTaglibUri = null;
        String converterTagName = null;
        ITagDefinition converterTag = adapter.getConverterTag();
        if (converterTag != null) {
            converterTaglibUri = converterTag.getTaglibUri();
            converterTagName = converterTag.getTagName();
        }
        if (converterTaglibUri != null && converterTagName != null) {
            String prefix;
            Document d = this.getTargetNode().getOwnerDocument();
            TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)d);
            Node existingConverter = this.findExistingConverter();
            if (existingConverter != null) {
                String existingUri = mapper.getUriForPrefix(existingConverter.getPrefix());
                String existingName = existingConverter.getLocalName();
                if (converterTaglibUri.equals(existingUri) && converterTagName.equals(existingName)) {
                    return;
                }
            }
            if ((prefix = mapper.getPrefixForUri(converterTaglibUri)) == null) {
                if (converterTag != null) {
                    prefix = converterTag.getPreferredPrefix();
                }
                if (prefix == null) {
                    prefix = "fx";
                }
                while (mapper.getUriForPrefix(prefix) != null) {
                    prefix = String.valueOf(prefix) + "x";
                }
                HTMLCommand cmd = JsfCommandUtil.getTaglibInsertCommand(converterTaglibUri, prefix);
                this.getDomain().execCommand((Command)cmd);
                mapper.addMapping(prefix, converterTaglibUri);
            }
            Element newConverter = d.createElement(String.valueOf(prefix) + ":" + converterTagName);
            Map converterAttributes = null;
            if (converterTag != null) {
                converterAttributes = converterTag.getAttributes();
            }
            if (converterAttributes != null) {
                for (String attribute : converterAttributes.keySet()) {
                    String value = (String)converterAttributes.get(attribute);
                    newConverter.setAttribute(attribute, value);
                }
                JsfCommandUtil.cleanupNodeAttributes(newConverter);
            }
            if (existingConverter != null) {
                existingConverter.getParentNode().replaceChild(newConverter, existingConverter);
            } else {
                this.getTargetNode().appendChild(newConverter);
            }
        } else {
            Node existingConverter = this.findExistingConverter();
            if (existingConverter != null) {
                if ("convertMask".equals(existingConverter.getLocalName())) {
                    return;
                }
                existingConverter.getParentNode().removeChild(existingConverter);
            }
        }
    }

    private Node findExistingConverter() {
        Node target = this.getTargetNode();
        Node child = target.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 3 && JsfComponentUtil.isConverterTag((Node)child)) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    @Override
    public String getCommandPreview() {
        BindingContext context;
        block14: {
            block13: {
                try {
                    if (this.isValidTarget(this.getTargetNode())) break block13;
                    return null;
                }
                catch (Exception e) {
                    JsfPlugin.log(e);
                    return null;
                }
            }
            context = this.getBindingContext();
            Element tag = (Element)this.getTargetNode();
            String attributeName = context.getTargetAttribute();
            if (this.allowsAttribute(tag, attributeName)) break block14;
            return null;
        }
        String ref = null;
        int numProperties = context.getPropertyNames().length;
        if (context.getPropertyNames() != null && numProperties == 1) {
            ref = this.multiValuedReference && context.getBeanNode().getChildren() != null && context.getBeanNode().getChildren().size() == 1 && !((ICodeGenNode)context.getModel().getCodeGenNodes().get(0)).isListNode() ? context.getBeanName() : context.getFullPropertyNames()[0];
        } else {
            IPageDataNode beanNode = context.getBeanNode();
            if (BindingUtil.hasChildren(beanNode) && numProperties > 0) {
                if (beanNode.getChildren().size() > 1) {
                    ref = context.getBeanName();
                } else {
                    IPageDataNode firstChild;
                    boolean containedTypeCase = false;
                    if (beanNode.getChildren().size() == 1 && (firstChild = (IPageDataNode)beanNode.getChildren().get(0)) instanceof ContainedTypePageDataNode) {
                        containedTypeCase = true;
                        ref = firstChild.getChildren().size() > 1 ? context.getBeanName() : context.getFullPropertyNames()[0];
                    }
                    if (!containedTypeCase) {
                        ref = context.getFullPropertyNames()[0];
                    }
                }
            } else {
                ref = context.getBeanName();
            }
        }
        if (ref != null) {
            return BindingUtil.removeLastIndexReference(ref);
        }
        return null;
    }
}

