/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind;

import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.TaglibDependencies;
import com.ibm.etools.jsf.library.emf.ChildTagsTemplateType;
import com.ibm.etools.jsf.library.emf.IterativeTemplateType;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.PropertyTemplateType;
import com.ibm.etools.jsf.library.emf.RequiredLibType;
import com.ibm.etools.jsf.library.emf.RequiredLibsType;
import com.ibm.etools.jsf.library.emf.TagType;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;

public class LibraryBindingUtil {
    public static final String ID_SUFFIX_ITERATIVE = "_iterative";

    public static String getId(PropertyTemplateType template) {
        String id = template.getId();
        if (id != null && !"".equals(id)) {
            return id;
        }
        return null;
    }

    public static String getName(PropertyTemplateType template) {
        String name = template.getName();
        if (name != null && !"".equals(name)) {
            return name;
        }
        return null;
    }

    public static String getDataType(PropertyTemplateType template) {
        String dataType = template.getDataType();
        if (dataType != null && !"".equals(dataType)) {
            return dataType;
        }
        return null;
    }

    public static String getDescription(PropertyTemplateType template) {
        String desc = template.getDescription();
        if (desc != null && !"".equals(desc)) {
            return desc;
        }
        return null;
    }

    public static String getPattern(PropertyTemplateType template) {
        String pattern = template.getPattern();
        if (pattern != null && !"".equals(pattern)) {
            return pattern;
        }
        return null;
    }

    public static boolean getIsInput(PropertyTemplateType template) {
        return template.isSetInput() && template.isInput();
    }

    public static boolean getIsDefault(PropertyTemplateType template) {
        return template.isSetDefault() && template.isDefault();
    }

    public static boolean getIsEnabled(PropertyTemplateType template) {
        return !template.isSetEnabled() || template.isEnabled();
    }

    public static TaglibDependencies getRequiredTaglibs(PropertyTemplateType template) {
        EList libsList;
        HashMap<String, String> usedTaglibMap = new HashMap<String, String>();
        RequiredLibsType libsType = template.getRequiredLibs();
        if (libsType != null && (libsList = libsType.getLib()) != null && !libsList.isEmpty()) {
            for (RequiredLibType lib : libsList) {
                String prefix = lib.getPrefix();
                String uri = lib.getUri();
                usedTaglibMap.put(uri, prefix);
            }
        }
        if (!usedTaglibMap.isEmpty()) {
            return new TaglibDependencies(usedTaglibMap);
        }
        return new TaglibDependencies("");
    }

    public static String getId(IterativeTemplateType template, String contextType) {
        String id = null;
        if ("jsf_wrapper".equals(contextType)) {
            id = template.getId();
        } else if ("jsf_iterative".equals(contextType)) {
            id = String.valueOf(template.getId()) + ID_SUFFIX_ITERATIVE;
        }
        if (id != null && !"".equals(id)) {
            return id;
        }
        return null;
    }

    public static String getName(IterativeTemplateType template) {
        String name = template.getName();
        if (name != null && !"".equals(name)) {
            return name;
        }
        return null;
    }

    public static String getDataType(IterativeTemplateType template, String contextType) {
        String dataType = null;
        if ("jsf_wrapper".equals(contextType)) {
            dataType = template.getDataType();
        } else if ("jsf_iterative".equals(contextType)) {
            dataType = LibraryBindingUtil.getId(template, "jsf_wrapper");
        }
        if (dataType != null && !"".equals(dataType)) {
            return dataType;
        }
        return null;
    }

    public static String getDescription(IterativeTemplateType template) {
        String desc = template.getDescription();
        if (desc != null && !"".equals(desc)) {
            return desc;
        }
        return null;
    }

    public static String getPattern(IterativeTemplateType template, String contextType) {
        String pattern = null;
        if ("jsf_wrapper".equals(contextType)) {
            pattern = template.getWrapperPattern();
        } else if ("jsf_iterative".equals(contextType)) {
            pattern = template.getIterativePattern();
        }
        if (pattern != null && !"".equals(pattern)) {
            return pattern;
        }
        return null;
    }

    public static boolean getIsInput(IterativeTemplateType template) {
        return template.isSetInput() && template.isInput();
    }

    public static boolean getIsDefault(IterativeTemplateType template) {
        return template.isSetDefault() && template.isDefault();
    }

    public static boolean getIsEnabled(IterativeTemplateType template) {
        return !template.isSetEnabled() || template.isEnabled();
    }

    public static TaglibDependencies getRequiredTaglibs(IterativeTemplateType template, String contextType) {
        EList libsList;
        HashMap<String, String> usedTaglibMap = new HashMap<String, String>();
        RequiredLibsType libsType = null;
        if ("jsf_wrapper".equals(contextType)) {
            libsType = template.getWrapperRequiredLibs();
        } else if ("jsf_iterative".equals(contextType)) {
            libsType = template.getIterativeRequiredLibs();
        }
        if (libsType != null && (libsList = libsType.getLib()) != null && !libsList.isEmpty()) {
            for (RequiredLibType lib : libsList) {
                String prefix = lib.getPrefix();
                String uri = lib.getUri();
                usedTaglibMap.put(uri, prefix);
            }
        }
        if (!usedTaglibMap.isEmpty()) {
            return new TaglibDependencies(usedTaglibMap);
        }
        return new TaglibDependencies("");
    }

    public static DataTemplate createTemplateInstance(ChildTagsTemplateType template) {
        if (template.getName() != null && template.getPattern() != null) {
            DataTemplate newTemplate = new DataTemplate(LibraryBindingUtil.getName(template), LibraryBindingUtil.getDataType(template), LibraryBindingUtil.getDescription(template), "jsf_iterative", LibraryBindingUtil.getPattern(template), true, LibraryBindingUtil.getRequiredTaglibs(template), true, LibraryBindingUtil.getId(template), true);
            return newTemplate;
        }
        return null;
    }

    public static String getId(ChildTagsTemplateType template) {
        TagType tagType = (TagType)template.eContainer();
        LibraryDefinitionType libType = (LibraryDefinitionType)tagType.eContainer().eContainer();
        return String.valueOf(libType.getTaglibUri()) + "::" + tagType.getName();
    }

    public static String getName(ChildTagsTemplateType template) {
        String name = template.getName();
        if (name != null && !"".equals(name)) {
            return name;
        }
        return null;
    }

    public static String getDataType(ChildTagsTemplateType template) {
        return "";
    }

    public static String getDescription(ChildTagsTemplateType template) {
        String desc = template.getDescription();
        if (desc != null && !"".equals(desc)) {
            return desc;
        }
        return null;
    }

    public static String getPattern(ChildTagsTemplateType template) {
        String pattern = template.getPattern();
        if (pattern != null && !"".equals(pattern)) {
            return pattern;
        }
        return null;
    }

    public static TaglibDependencies getRequiredTaglibs(ChildTagsTemplateType template) {
        EList libsList;
        HashMap<String, String> usedTaglibMap = new HashMap<String, String>();
        RequiredLibsType libsType = template.getRequiredLibs();
        if (libsType != null && (libsList = libsType.getLib()) != null && !libsList.isEmpty()) {
            for (RequiredLibType lib : libsList) {
                String prefix = lib.getPrefix();
                String uri = lib.getUri();
                usedTaglibMap.put(uri, prefix);
            }
        }
        if (!usedTaglibMap.isEmpty()) {
            return new TaglibDependencies(usedTaglibMap);
        }
        return new TaglibDependencies("");
    }
}

