/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.commands.AbstractDataBindCommand;
import com.ibm.etools.jsf.databind.commands.builder.BindingCommandFactory;
import com.ibm.etools.jsf.databind.commands.builder.IJsfCommandPreviewer;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webtools.model.ModelManager;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedataview.data.IBindingPreviewer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class JsfBindingPreviewer
implements IBindingPreviewer {
    Node targetNode = null;
    String attributeName = null;

    public JsfBindingPreviewer(Node targetNode, String attributeName) {
        this.targetNode = targetNode;
        this.attributeName = attributeName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getBindingPreview(IPageDataNode curNode) {
        ICodeGenModel model;
        String result;
        block5: {
            block4: {
                try {
                    result = null;
                    if (this.targetNode == null) return result;
                    if (this.attributeName == null) return result;
                    if (curNode == null) return result;
                    if ("".equals(this.attributeName)) return result;
                    if (EditDomainUtil.getEditDomain() != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    JsfPlugin.log(e);
                    return null;
                }
            }
            model = this.constructModel(new IPageDataNode[]{curNode});
            if (model != null) break block5;
            return null;
        }
        model.addCustomProperty((Object)"previewCommandOnly", (Object)Boolean.TRUE);
        HTMLCommand cmd = BindingCommandFactory.generateCommand(this.targetNode, this.attributeName, model, true);
        if (!(cmd instanceof IJsfCommandPreviewer)) return result;
        if (!(cmd instanceof AbstractDataBindCommand)) return ((IJsfCommandPreviewer)cmd).getCommandPreview();
        ((AbstractDataBindCommand)cmd).setTargetNode(this.targetNode);
        return ((IJsfCommandPreviewer)cmd).getCommandPreview();
    }

    private ICodeGenModel constructModel(IPageDataNode[] pdNodes) {
        try {
            IDOMDocument d = this.getDocument(pdNodes[0]);
            if (d != null) {
                JSP jsp;
                IFile file;
                Path jspPath = new Path(d.getModel().getBaseLocation());
                IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)d);
                if (jspPath != null && project != null && (file = (IFile)project.getWorkspace().getRoot().findMember((IPath)jspPath)) != null && (jsp = ModelManager.getModel((IResource)project).getJSP(file)) != null) {
                    ICodeGenModel model = CodeGenModelFactory.createCodeGenModel((IPageDataNode[])pdNodes, null, (JSP)jsp, (String)"JSF", (boolean)true);
                    CodeGenModelFactory.finalizeModel((ICodeGenModel)model);
                    return model;
                }
            }
            return null;
        }
        catch (Exception e) {
            JsfPlugin.log(e);
            return null;
        }
    }

    private IDOMDocument getDocument(IPageDataNode pdNode) {
        try {
            IDOMDocument d = null;
            IDOMNode node = null;
            if (pdNode instanceof ISSEPageDataNode) {
                node = ((ISSEPageDataNode)pdNode).getDOMNode();
            }
            d = node != null ? (node.getNodeType() == 9 ? (IDOMDocument)node : (IDOMDocument)node.getOwnerDocument()) : EditDomainUtil.getEditDomain().getActiveModel().getDocument();
            return d;
        }
        catch (Exception e) {
            JsfPlugin.log(e);
            return null;
        }
    }
}

