/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.DatabindConstants;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.TemplateProvider;
import com.ibm.etools.jsf.preferences.JsfTagModeUtil;
import com.ibm.etools.jsf.support.StringUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IGenControlPanel;
import com.ibm.etools.webtools.pagedatamodel.impl.GenControlPanel;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JSFGenControlPanel
extends GenControlPanel
implements IGenControlPanel {
    private IProject fProject;

    public List getControlsForRT(String rtType, short usage, IVirtualComponent vc) throws ClassNotFoundException {
        if (TemplateProvider.useJavajetTemplates()) {
            this.fProject = vc.getProject();
            List controlIds = super.getControlsForRT(rtType, usage, vc);
            return this.filterJavajetIds(controlIds, vc.getProject());
        }
        TemplateProvider.reset();
        this.fProject = vc.getProject();
        TreeMap<String, String> sortedIds = new TreeMap<String, String>();
        List<String> controlIds = this.getControlsFromString(rtType, usage, vc, sortedIds);
        if (!sortedIds.isEmpty()) {
            this.addMatchingIds(controlIds, sortedIds);
        }
        return controlIds;
    }

    public List getControlsForRT(GenControlPanel.JavaHelpers rtType, short usage, IVirtualComponent vc) {
        if (TemplateProvider.useJavajetTemplates()) {
            this.fProject = vc.getProject();
            List controls = super.getControlsForRT(rtType, usage, vc);
            return this.filterJavajetIds(controls, vc.getProject());
        }
        TemplateProvider.reset();
        this.fProject = vc.getProject();
        TreeMap<String, String> sortedIds = new TreeMap<String, String>();
        List<String> controlIds = this.getControlsFromJavaHelpers(new ArrayList<String>(), vc.getProject(), rtType, usage, sortedIds);
        if (!sortedIds.isEmpty()) {
            this.addMatchingIds(controlIds, sortedIds);
        }
        return controlIds;
    }

    private void addMatchingIds(List<String> controlIds, Map<String, String> sortedIds) {
        for (String id : sortedIds.values()) {
            controlIds.add(id);
        }
        sortedIds.clear();
    }

    private List<String> getControlsFromString(String rtType, final short usage, final IVirtualComponent vc, Map<String, String> sortedIds) throws ClassNotFoundException {
        final String rtTypeErasure = Signature.toString((String)Signature.getTypeErasure((String)Signature.createTypeSignature((String)rtType, (boolean)true)));
        Map<String, DataTemplate> templateMap = TemplateProvider.getActivePropertyAndWrapperTemplates(vc.getProject());
        ArrayList<String> controls = new ArrayList<String>();
        if (this.matchTemplateWithType(vc.getProject(), templateMap, rtType, usage, controls, sortedIds)) {
            return controls;
        }
        final List[] listHolder = new List[1];
        Exception[] exceptionHolder = new Exception[1];
        Runnable busyRunnable = new Runnable(){

            @Override
            public void run() {
                GenControlPanel.JavaHelpers jclass = null;
                if (rtTypeErasure != null && !rtTypeErasure.equals("")) {
                    jclass = new GenControlPanel.JavaHelpers((GenControlPanel)JSFGenControlPanel.this, rtTypeErasure, vc.getProject());
                    listHolder[0] = JSFGenControlPanel.this.getControlsForRT(jclass, usage, vc);
                }
            }
        };
        BusyIndicator.showWhile(null, (Runnable)busyRunnable);
        if (exceptionHolder[0] != null) {
            if (exceptionHolder[0] instanceof CoreException) {
                throw new ClassNotFoundException(NLS.bind((String)ResourceHandler._EXC_classNotFound, (Object[])new String[]{rtType}));
            }
            if (exceptionHolder[0] instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exceptionHolder[0];
            }
            ClassNotFoundException e = new ClassNotFoundException();
            e.initCause(exceptionHolder[0]);
            throw e;
        }
        return listHolder[0];
    }

    public boolean isRTExplicitlyDefined(String runtimeType) {
        if (TemplateProvider.useJavajetTemplates()) {
            return super.isRTExplicitlyDefined(runtimeType);
        }
        Map<String, DataTemplate> templateMap = TemplateProvider.getActivePropertyAndWrapperTemplates(this.fProject);
        if (runtimeType != null) {
            for (String key : templateMap.keySet()) {
                DataTemplate t = templateMap.get(key);
                if (!this.runtimeTypesMatch(this.fProject, runtimeType, t.getDataType())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean runtimeTypesMatch(IProject project, String typeToCheck, String templateRuntimeType) {
        if (typeToCheck.equals(templateRuntimeType)) {
            return true;
        }
        return templateRuntimeType.equals("primitive") && StringUtil.belongsTo(typeToCheck, DatabindConstants.PRIMITIVE_TYPES) && !StringUtil.belongsTo(typeToCheck, TemplateProvider.getActivePrimitiveTemplateTypes(project));
    }

    private List<String> getControlsFromJavaHelpers(List<String> controlIds, IProject project, GenControlPanel.JavaHelpers helper, short usage, Map<String, String> sortedIds) {
        boolean templateFound = false;
        if (controlIds == null) {
            return null;
        }
        Map<String, DataTemplate> templateMap = TemplateProvider.getActivePropertyAndWrapperTemplates(project);
        templateFound = this.findTemplateForType(project, templateMap, helper, usage, controlIds, sortedIds);
        if (!templateFound) {
            controlIds.add("jsf.default.outputText");
        }
        return controlIds;
    }

    private boolean findTemplateForType(IProject project, Map<String, DataTemplate> templateMap, GenControlPanel.JavaHelpers helper, short usage, List<String> controlIds, Map<String, String> sortedIds) {
        boolean templateMatched;
        block9: {
            templateMatched = false;
            String currentJavaType = helper.fullyQualifiedType;
            templateMatched = this.matchTemplateWithType(project, templateMap, currentJavaType, usage, controlIds, sortedIds);
            if (!templateMatched) {
                if (!helper.isPrimitive() && helper.iType != null) {
                    IType theClass = helper.iType;
                    try {
                        ITypeHierarchy typeHierarchy = theClass.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                        IType[] superTypes = typeHierarchy.getAllSupertypes(theClass);
                        int i = 0;
                        while (i < superTypes.length) {
                            currentJavaType = superTypes[i].getFullyQualifiedName();
                            if (helper.isArray() && !currentJavaType.endsWith("[]")) {
                                currentJavaType = currentJavaType.concat("[]");
                            }
                            if (templateMatched = this.matchTemplateWithType(project, templateMap, currentJavaType, usage, controlIds, sortedIds)) break;
                            ++i;
                        }
                        if (templateMatched) break block9;
                        if (helper.isArray()) {
                            templateMatched = this.matchTemplateWithType(project, templateMap, "java.lang.Object[]", usage, controlIds, sortedIds);
                            break block9;
                        }
                        templateMatched = this.matchTemplateWithType(project, templateMap, "java.lang.Object", usage, controlIds, sortedIds);
                    }
                    catch (Exception e) {
                        JsfPlugin.log(e);
                    }
                } else if (helper.isPrimitive() && helper.isArray()) {
                    templateMatched = this.matchTemplateWithType(project, templateMap, "java.lang.Object[]", usage, controlIds, sortedIds);
                }
            }
        }
        return templateMatched;
    }

    private boolean matchTemplateWithType(IProject project, Map<String, DataTemplate> templateMap, String type, short usage, List<String> controlIds, Map<String, String> sortedIds) {
        boolean templateMatched = false;
        for (String key : templateMap.keySet()) {
            DataTemplate t = templateMap.get(key);
            if (!this.runtimeTypesMatch(project, type, t.getDataType()) || !this.checkUsageAndAdd(t, key, usage, controlIds, sortedIds)) continue;
            templateMatched = true;
        }
        return templateMatched;
    }

    private boolean checkUsageAndAdd(DataTemplate t, String key, short usage, List<String> controlIds, Map<String, String> sortedIds) {
        if (1 == usage) {
            if (t.isInput()) {
                if (!controlIds.contains(key)) {
                    this.addControlId(t, key, controlIds, sortedIds);
                }
                return true;
            }
        } else if (2 == usage) {
            if (!t.isInput()) {
                if (!controlIds.contains(key)) {
                    this.addControlId(t, key, controlIds, sortedIds);
                }
                return true;
            }
        } else {
            if (!controlIds.contains(key)) {
                this.addControlId(t, key, controlIds, sortedIds);
            }
            return true;
        }
        return false;
    }

    private void addControlId(DataTemplate t, String key, List<String> controlIds, Map<String, String> sortedIds) {
        if (t.isDefault()) {
            controlIds.add(0, key);
        } else {
            sortedIds.put(t.getName(), key);
        }
    }

    public String getLabelForControl(String controlId) {
        if (TemplateProvider.useJavajetTemplates()) {
            return super.getLabelForControl(controlId);
        }
        if (controlId == null) {
            return "";
        }
        return TemplateProvider.getAllActiveTemplates(null).get(controlId).getName();
    }

    private List<String> filterJavajetIds(List<String> controls, IProject project) {
        if (JsfTagModeUtil.isUsingIbmTags(project)) {
            return controls;
        }
        ListIterator<String> iter = controls.listIterator();
        while (iter.hasNext()) {
            String entry = iter.next();
            if ("singleColumnGrid".equals(entry) || "unformattedSingleCol".equals(entry) || "tableInJspPanel".equals(entry) || "jspPanel".equals(entry) || "image".equals(entry) || "outputLink".equals(entry) || "fileupload".equals(entry)) {
                iter.remove();
                continue;
            }
            if ("dataTableEx".equals(entry)) {
                iter.remove();
                iter.add("dataTable");
                continue;
            }
            if (!"commandExButton".equals(entry)) continue;
            iter.remove();
            iter.add("commandButton");
        }
        return controls;
    }
}

