/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind;

import com.ibm.etools.jsf.internal.databind.JsfBindingPreviewer;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.IdResolver;
import com.ibm.etools.jsf.internal.templates.framework.TemplateBuffer;
import com.ibm.etools.jsf.internal.templates.framework.TemplateContextType;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariable;
import com.ibm.etools.jsf.library.emf.DataBindingType;
import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.selection.HTMLSelectionMediator;
import com.ibm.etools.webtools.pagedataview.data.IBindingPreviewer;
import java.util.Date;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorSite;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class CommandUtil {
    public static String getMainBindingAttribute(Node node) {
        String mainBindingAttr;
        DataBindingType bindingInfo;
        Document doc = JsfCommandUtil.getDocument(node);
        TaglibPrefixUtil uriMapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        String tagUri = uriMapper.getUriForPrefix(node.getPrefix());
        String tagName = node.getLocalName();
        TagType tag = LibraryManager.getInstance().getTagModel(tagUri, tagName);
        if (tag != null && (bindingInfo = tag.getDataBinding()) != null && bindingInfo.isSetMainBindingAttribute() && (mainBindingAttr = bindingInfo.getMainBindingAttribute()) != null && !"".equals(mainBindingAttr)) {
            return mainBindingAttr;
        }
        return "value";
    }

    public static String getRepeatingValueAttribute(Node node) {
        String repeatingValueAttr;
        DataBindingType bindingInfo;
        Document doc = JsfCommandUtil.getDocument(node);
        TaglibPrefixUtil uriMapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        String tagUri = uriMapper.getUriForPrefix(node.getPrefix());
        String tagName = node.getLocalName();
        TagType tag = LibraryManager.getInstance().getTagModel(tagUri, tagName);
        if (tag != null && (bindingInfo = tag.getDataBinding()) != null && bindingInfo.isSetRepeatingValueAttribute() && (repeatingValueAttr = bindingInfo.getRepeatingValueAttribute()) != null && !"".equals(repeatingValueAttr)) {
            return repeatingValueAttr;
        }
        return "var";
    }

    public static String generateUniqueId(Map<String, ?> existingIds, String prefix, String suffix) {
        String id = new Long(new Date().getTime()).toString();
        if (prefix != null) {
            id = prefix.concat(id);
        }
        if (suffix != null) {
            id = id.concat(suffix);
        }
        if (existingIds != null) {
            while (existingIds.containsKey(id)) {
                id = id.concat("x");
            }
        }
        return id;
    }

    public static IBindingPreviewer createBindingPreviewer(Node nodeToBind, String attrToBind) {
        JsfBindingPreviewer previewer = null;
        if (attrToBind != null && !"".equals(attrToBind)) {
            if (nodeToBind != null) {
                return new JsfBindingPreviewer(nodeToBind, attrToBind);
            }
            Node targetNode = null;
            HTMLEditDomain domain = EditDomainUtil.getEditDomain();
            if (domain != null) {
                targetNode = domain.getSelectionMediator().getFocusedNode();
                if (targetNode == null && (targetNode = CommandUtil.getNodeFromSelection(domain)) == null) {
                    targetNode = CommandUtil.getNodeFromRange(domain);
                }
                if (targetNode != null) {
                    targetNode = CommandUtil.ignoreTextNode(targetNode);
                    previewer = new JsfBindingPreviewer(targetNode, attrToBind);
                }
            }
        }
        return previewer;
    }

    private static Node getNodeFromSelection(HTMLEditDomain editDomain) {
        Object firstElement;
        ISelection selection;
        ISelectionProvider selectionProvider;
        IEditorSite editorSite = editDomain.getEditorSite();
        if (editorSite != null && (selectionProvider = editorSite.getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) != null && selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) != null && firstElement instanceof Node) {
            Node selectedNode = (Node)firstElement;
            return selectedNode;
        }
        return null;
    }

    private static Node getNodeFromRange(HTMLEditDomain editDomain) {
        Range range;
        HTMLSelectionMediator mediator = editDomain.getSelectionMediator();
        if (mediator != null && (range = mediator.getRange()) != null) {
            return range.getEndContainer();
        }
        return null;
    }

    private static Node ignoreTextNode(Node target) {
        if (target.getNodeType() == 3 && target.getParentNode() != null) {
            target = target.getParentNode();
        }
        return target;
    }

    public static void setupIdResolver(TemplateBuffer buffer, TemplateContextType contextType, DataTemplate template) {
        TemplateVariable[] variables = buffer.getVariables();
        if (variables != null) {
            int i = 0;
            while (i < variables.length) {
                String type;
                TemplateVariable v = variables[i];
                if (v != null && (type = v.getType()) != null && "id".equals(type)) {
                    int[] offsets = v.getOffsets();
                    int position = offsets[0];
                    IdResolver resolver = (IdResolver)contextType.getResolver("id");
                    if (resolver == null) break;
                    resolver.setPattern(template.getPattern());
                    resolver.setFirstOffset(position);
                    break;
                }
                ++i;
            }
        }
    }
}

