/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.events.internal.ui;

import com.ibm.etools.jsf.events.internal.ui.ConfiureMultiBehaviourActionDialog;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.EditNodeAttributesCommand;
import com.ibm.etools.jsf.palette.commands.InsertAsChildCommand;
import com.ibm.etools.jsf.palette.commands.InsertAsSiblingCommand;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.palette.commands.JsfCompoundCommand;
import com.ibm.etools.jsf.support.BehaviorTagUtility;
import com.ibm.etools.jsf.support.FindNodeUtil;
import com.ibm.etools.jsf.support.IBehaviorConstants;
import com.ibm.etools.jsf.support.dialogs.PartsUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.qev.EventsConstants;
import com.ibm.etools.qev.edit.StructuredTextEditorViewerQEVEditor;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.impl.HtmlTagEventImpl;
import com.ibm.etools.qev.model.impl.TagEventImpl;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.RemoveNodeCommand;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.common.utils.AttributeDataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.jsp.core.internal.domdocument.ElementImplForJSP;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class JsfTextEditorQEVEditor
extends StructuredTextEditorViewerQEVEditor {
    protected Composite fParent = null;
    private Combo fBehaviorAction = null;
    private Combo fTargetAction = null;
    private Button fUseBehavior = null;
    private Button configMultiActions = null;
    private Label actionLabel = null;
    private Label targetLabel = null;
    public static final HashMap<String, String> DescriptionToBehaviorActionTag = new HashMap();
    public static final HashMap<String, String> BehaviorActionTagToDescription = new HashMap();
    private Node behaviorNode;

    public JsfTextEditorQEVEditor() {
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Alert_Description, "alert");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Click_Description, "click");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Confirm_Description, "confirm");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Focus_Description, "focus");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Goto_Description, "goto");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Hide_Description, "hide");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_InvertHide_Description, "inverthide");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_InvertLocked_Description, "invertlocked");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_InvertVisible_Description, "invertvisible");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Invisible_Description, "invisible");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Locked_Description, "locked");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_NextTab_Description, "nexttab");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_NextTabClear_Description, "nexttabclear");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Nothing_Description, "stop");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_PrevTab_Description, "prevtab");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_PrevTabClear_Description, "prevtabclear");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Selected_Description, "selected");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Show_Description, "show");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Submit_Description, "submit");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Unlocked_Description, "unlocked");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Unselected_Description, "unselected");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Visible_Description, "visible");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Empty_Description, "_remove_attribute");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Many_Description, "_invoke_multi_action_dialog");
        DescriptionToBehaviorActionTag.put(Messages.Behavior_Action_Invoke_Ajax_Behaviour_Description, "get");
        BehaviorActionTagToDescription.put("alert", Messages.Behavior_Action_Alert_Description);
        BehaviorActionTagToDescription.put("click", Messages.Behavior_Action_Click_Description);
        BehaviorActionTagToDescription.put("confirm", Messages.Behavior_Action_Confirm_Description);
        BehaviorActionTagToDescription.put("focus", Messages.Behavior_Action_Focus_Description);
        BehaviorActionTagToDescription.put("goto", Messages.Behavior_Action_Goto_Description);
        BehaviorActionTagToDescription.put("hide", Messages.Behavior_Action_Hide_Description);
        BehaviorActionTagToDescription.put("inverthide", Messages.Behavior_Action_InvertHide_Description);
        BehaviorActionTagToDescription.put("invertlocked", Messages.Behavior_Action_InvertLocked_Description);
        BehaviorActionTagToDescription.put("invertvisible", Messages.Behavior_Action_InvertVisible_Description);
        BehaviorActionTagToDescription.put("invisible", Messages.Behavior_Action_Invisible_Description);
        BehaviorActionTagToDescription.put("locked", Messages.Behavior_Action_Locked_Description);
        BehaviorActionTagToDescription.put("nexttab", Messages.Behavior_Action_NextTab_Description);
        BehaviorActionTagToDescription.put("nexttabclear", Messages.Behavior_Action_NextTabClear_Description);
        BehaviorActionTagToDescription.put("nothing", Messages.Behavior_Action_Nothing_Description);
        BehaviorActionTagToDescription.put("stop", Messages.Behavior_Action_Nothing_Description);
        BehaviorActionTagToDescription.put("none", Messages.Behavior_Action_Nothing_Description);
        BehaviorActionTagToDescription.put("prevtab", Messages.Behavior_Action_PrevTab_Description);
        BehaviorActionTagToDescription.put("prevtabclear", Messages.Behavior_Action_PrevTabClear_Description);
        BehaviorActionTagToDescription.put("selected", Messages.Behavior_Action_Selected_Description);
        BehaviorActionTagToDescription.put("show", Messages.Behavior_Action_Show_Description);
        BehaviorActionTagToDescription.put("submit", Messages.Behavior_Action_Submit_Description);
        BehaviorActionTagToDescription.put("unlocked", Messages.Behavior_Action_Unlocked_Description);
        BehaviorActionTagToDescription.put("unselected", Messages.Behavior_Action_Unselected_Description);
        BehaviorActionTagToDescription.put("visible", Messages.Behavior_Action_Visible_Description);
        BehaviorActionTagToDescription.put("_remove_attribute", Messages.Behavior_Action_Empty_Description);
        BehaviorActionTagToDescription.put("_invoke_multi_action_dialog", Messages.Behavior_Action_Many_Description);
        BehaviorActionTagToDescription.put("get", Messages.Behavior_Action_Invoke_Ajax_Behaviour_Description);
        this.behaviorNode = null;
    }

    public void setupEditorControl(IWorkbenchPartSite site, Composite parent, int style) {
        this.fParent = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout(1, false);
        topLayout.marginBottom = 0;
        topLayout.marginHeight = 0;
        topLayout.marginTop = 0;
        topLayout.marginWidth = 0;
        topLayout.marginLeft = 0;
        topLayout.marginRight = 0;
        topLayout.horizontalSpacing = 0;
        topLayout.verticalSpacing = 0;
        this.fParent.setLayout((Layout)topLayout);
        this.fParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createMenuBar();
        Composite viewerParent = new Composite(this.fParent, 0);
        viewerParent.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 2;
        viewerParent.setLayoutData((Object)gridData);
        this.editorViewer = this.createEditorViewer(viewerParent);
        this.editorViewer.init(site, this.getVirtualInput());
    }

    private void createMenuBar() {
        Composite menuBar = new Composite(this.fParent, 0);
        menuBar.setLayout((Layout)new FormLayout());
        GridData gridData = new GridData(4, 4, true, false);
        gridData.verticalIndent = 2;
        menuBar.setLayoutData((Object)gridData);
        this.createUseBehaviorMenuItem(menuBar);
        this.createBehaviorActionMenuItem(menuBar);
        this.createActionTargetMenuItem(menuBar);
        this.createConfigureMultiActionMenuItem(menuBar);
        this.layoutMenuBar(menuBar);
    }

    private void createUseBehaviorMenuItem(Composite menuBar) {
        this.fUseBehavior = new Button(menuBar, 32);
        this.fUseBehavior.setText(Messages.Use_Behavior);
        this.fUseBehavior.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (JsfTextEditorQEVEditor.this.fUseBehavior.getSelection()) {
                    JsfTextEditorQEVEditor.this.findAndRemoveFuncCall();
                    JsfTextEditorQEVEditor.this.setupVirtualInputInEditor(EventsConstants.DEFAULT_EVENT_EDITOR_TEXT);
                    JsfTextEditorQEVEditor.this.createNewBehaviorNode();
                    JsfTextEditorQEVEditor.this.enableBehaviorUI();
                } else {
                    JsfTextEditorQEVEditor.this.removeBehaviorNode(JsfTextEditorQEVEditor.this.behaviorNode);
                    JsfTextEditorQEVEditor.this.disableBehaviorUI();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createBehaviorActionMenuItem(Composite menuBar) {
        this.actionLabel = new Label(menuBar, 0);
        this.actionLabel.setText(String.valueOf(Messages.Navigation_ActionRef_10) + ":");
        this.fBehaviorAction = new Combo(menuBar, 12);
        this.fBehaviorAction.setItems(IBehaviorConstants.behaviorActionDescriptions);
        this.fBehaviorAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String attributeValue = DescriptionToBehaviorActionTag.get(JsfTextEditorQEVEditor.this.fBehaviorAction.getText());
                if (attributeValue.equals("_invoke_multi_action_dialog")) {
                    JsfTextEditorQEVEditor.this.invokeMultiActionDialog();
                } else {
                    JsfTextEditorQEVEditor.this.editTag("behaviorAction", attributeValue);
                    if (attributeValue.equals("_remove_attribute")) {
                        JsfTextEditorQEVEditor.this.editTag("targetAction", attributeValue);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createActionTargetMenuItem(Composite menuBar) {
        this.targetLabel = new Label(menuBar, 0);
        this.targetLabel.setText(String.valueOf(Messages.Target) + ":");
        this.fTargetAction = new Combo(menuBar, 4);
        this.fTargetAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String value = JsfTextEditorQEVEditor.this.fTargetAction.getText();
                if (value.equals(Messages.Behavior_Target_Empty_Description)) {
                    value = "_remove_attribute";
                }
                JsfTextEditorQEVEditor.this.editTag("targetAction", value);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fTargetAction.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
                if (actionTarget != null) {
                    IDOMDocument d = actionTarget.getActiveModel().getDocument();
                    JsfTextEditorQEVEditor.this.fTargetAction.setItems(JsfTextEditorQEVEditor.getNodeIds((Document)d));
                }
            }
        });
        this.fTargetAction.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                String value = JsfTextEditorQEVEditor.this.fTargetAction.getText().trim();
                if (!value.equals(Messages.Behavior_Target_Empty_Description)) {
                    if (value.equals("")) {
                        JsfTextEditorQEVEditor.this.fTargetAction.setText(Messages.Behavior_Target_Empty_Description);
                        JsfTextEditorQEVEditor.this.editTag("targetAction", "_remove_attribute");
                    } else {
                        JsfTextEditorQEVEditor.this.editTag("targetAction", value);
                    }
                }
            }
        });
    }

    private void createConfigureMultiActionMenuItem(Composite menuBar) {
        this.configMultiActions = new Button(menuBar, 8);
        this.configMultiActions.setText("....");
        this.configMultiActions.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.behavior_configure_multiple_actions;
                }
            }
        });
        this.configMultiActions.setEnabled(false);
        this.configMultiActions.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JsfTextEditorQEVEditor.this.invokeMultiActionDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void layoutMenuBar(Composite menuBar) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 8);
        this.fUseBehavior.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.fUseBehavior, 5);
        formData.top = new FormAttachment((Control)this.fUseBehavior, 0, 0x1000000);
        this.actionLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.actionLabel, 5);
        formData.top = new FormAttachment((Control)this.fUseBehavior, 0, 0x1000000);
        formData.right = new FormAttachment((Control)this.targetLabel, -5);
        this.fBehaviorAction.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.fUseBehavior, 0, 0x1000000);
        formData.right = new FormAttachment((Control)this.fTargetAction, -5);
        this.targetLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.fUseBehavior, 0, 0x1000000);
        formData.right = new FormAttachment((Control)this.configMultiActions, -5);
        formData.width = PartsUtil.getTextExtent((Control)menuBar, (String)"XXXXXXXXXX").x + 25;
        this.fTargetAction.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.fUseBehavior, 0, 0x1000000);
        formData.right = new FormAttachment(100, -5);
        this.configMultiActions.setLayoutData((Object)formData);
    }

    private void invokeMultiActionDialog() {
        ConfiureMultiBehaviourActionDialog dialog = new ConfiureMultiBehaviourActionDialog(JsfTextEditorQEVEditor.getShell());
        dialog.dataList = this.preDialog(dialog);
        if (dialog.open() == 0) {
            this.postDialog((Dialog)dialog);
        }
    }

    private List<ConfiureMultiBehaviourActionDialog.DataObject> preDialog(ConfiureMultiBehaviourActionDialog dialog) {
        String targetAttr;
        String actionAttr = AttributeDataUtil.getAttributeValue((Node)this.behaviorNode, (String)"behaviorAction");
        if (actionAttr == null) {
            actionAttr = "_remove_attribute";
        }
        if ((targetAttr = AttributeDataUtil.getAttributeValue((Node)this.behaviorNode, (String)"targetAction")) == null) {
            targetAttr = Messages.Behavior_Target_Empty_Description;
        }
        String[] actions = actionAttr.split(";");
        String[] targets = targetAttr.split(";");
        ArrayList<ConfiureMultiBehaviourActionDialog.DataObject> data = new ArrayList<ConfiureMultiBehaviourActionDialog.DataObject>();
        int i = 0;
        while (i < actions.length) {
            String action = actions[i];
            String target = Messages.Behavior_Target_Empty_Description;
            if (i < targets.length && !targets[i].equals("")) {
                target = targets[i];
            }
            ConfiureMultiBehaviourActionDialog confiureMultiBehaviourActionDialog = dialog;
            ((Object)((Object)confiureMultiBehaviourActionDialog)).getClass();
            data.add(confiureMultiBehaviourActionDialog.new ConfiureMultiBehaviourActionDialog.DataObject(action, target));
            ++i;
        }
        return data;
    }

    private void postDialog(Dialog dialog) {
        List<ConfiureMultiBehaviourActionDialog.DataObject> list = ((ConfiureMultiBehaviourActionDialog)dialog).dataList;
        String actionString = "";
        String targetString = "";
        for (ConfiureMultiBehaviourActionDialog.DataObject dataObject : list) {
            if (dataObject.getAction().equals("_remove_attribute")) continue;
            if (targetString.equals("")) {
                if (dataObject.getTarget().equals(Messages.Behavior_Target_Empty_Description)) {
                    if (!actionString.equals("")) {
                        targetString = ";";
                    } else if (targetString.endsWith(";")) {
                        targetString = String.valueOf(targetString) + ";";
                    }
                } else {
                    targetString = dataObject.getTarget();
                }
            } else {
                targetString = dataObject.getTarget().equals(Messages.Behavior_Target_Empty_Description) ? String.valueOf(targetString) + ";" : String.valueOf(targetString) + ";" + dataObject.getTarget();
            }
            actionString = actionString.equals("") ? dataObject.getAction() : String.valueOf(actionString) + ";" + dataObject.getAction();
        }
        if (!actionString.equals("")) {
            this.editTag("behaviorAction", actionString);
        }
        if (!targetString.equals("")) {
            this.editTag("targetAction", targetString);
        }
    }

    public static final Shell getShell() {
        IWorkbenchWindow workbenchWindow;
        Shell shell = null;
        Display display = JsfTextEditorQEVEditor.getDisplay();
        if (display != null) {
            shell = display.getActiveShell();
        }
        if (shell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = workbenchWindow.getShell();
        }
        return shell;
    }

    public static final Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String[] getNodeIds(Document d) {
        ArrayList<String> idsList = new ArrayList<String>();
        idsList.add(Messages.Behavior_Target_Empty_Description);
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(d);
        while (!nodes.isEmpty()) {
            Node idAttr;
            NamedNodeMap attrs;
            Node currentNode = (Node)nodes.remove(0);
            Node child = currentNode.getFirstChild();
            while (child != null) {
                nodes.add(child);
                child = child.getNextSibling();
            }
            if (!JsfComponentUtil.isJsfTag((Node)currentNode) || (attrs = currentNode.getAttributes()) == null || (idAttr = attrs.getNamedItem("id")) == null) continue;
            idsList.add(idAttr.getNodeValue());
        }
        return idsList.toArray(new String[idsList.size()]);
    }

    public Control getControl() {
        return this.fParent;
    }

    private void createNewBehaviorNode() {
        Object node = null;
        if (this.currentEvent instanceof TagEventImpl) {
            node = ((TagEventImpl)this.currentEvent).getNode();
        } else if (ActionUtil.getActiveHTMLEditDomain() != null) {
            node = ActionUtil.getActiveHTMLEditDomain().getSelectionMediator().getRange().getEndContainer();
        }
        if (node == null) {
            return;
        }
        this.behaviorNode = JsfComponentUtil.checkComponentSuperclass((Node)node, (String)"javax.faces.component.UISelectOne") || JsfComponentUtil.checkComponentSuperclass((Node)node, (String)"javax.faces.component.UISelectMany") || JsfComponentUtil.checkComponentSuperclass((Node)node, (String)"javax.faces.component.UIData") ? this.createSiblingBehaviorNode((Node)node) : this.createChildBehaviorNode((Node)node);
        if (this.behaviorNode != null) {
            ((HtmlTagEventImpl)this.currentEvent).setNode((IDOMNode)this.behaviorNode);
        }
        Range newRange = ((DocumentRange)((Object)node.getOwnerDocument())).createRange();
        newRange.setStart((Node)node, 0);
        newRange.setEnd((Node)node, 0);
        if (EditDomainUtil.getEditDomain() != null) {
            EditDomainUtil.getEditDomain().getSelectionMediator().setRange(newRange);
        }
    }

    private Node createChildBehaviorNode(Node node) {
        JsfCompoundCommand cmd = new JsfCompoundCommand(Messages.QEV_AddBehavior);
        CustomTagFactory factory = new CustomTagFactory(String.valueOf(this.getTagPrefix(node, "hx", cmd)) + ":" + "behavior");
        factory.pushAttribute("event", this.currentEvent.getDisplayName());
        String idPrefix = JsfComponentUtil.getIdPrefix((String)"http://www.ibm.com/jsf/html_extended", (String)"behavior", (IProject)JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)node.getOwnerDocument())));
        String id = JsfComponentUtil.generateUniqueId((Document)node.getOwnerDocument(), (String)idPrefix, cmd.getIds());
        cmd.addId(id);
        factory.pushAttribute("id", id);
        cmd.append((HTMLCommand)new InsertAsChildCommand((NodeFactory)factory, node));
        cmd.execute();
        return this.findTarget(node, this.currentEvent.getDisplayName(), false);
    }

    private Node createSiblingBehaviorNode(Node node) {
        JsfCompoundCommand cmd;
        CustomTagFactory factory;
        Node id;
        Node result = null;
        String idvalue = null;
        NamedNodeMap nodeMap = node.getAttributes();
        if (nodeMap != null && (id = nodeMap.getNamedItem("id")) != null) {
            idvalue = id.getNodeValue();
        }
        if (idvalue != null && !idvalue.equals("") && (factory = new CustomTagFactory(String.valueOf(this.getTagPrefix(node, "hx", cmd = new JsfCompoundCommand(Messages.QEV_AddBehavior))) + ":" + "behavior")) != null) {
            factory.pushAttribute("event", this.currentEvent.getDisplayName());
            factory.pushAttribute("target", idvalue);
            cmd.append((HTMLCommand)new InsertAsSiblingCommand((NodeFactory)factory, node, 2));
            cmd.execute();
            result = this.findTarget(node, this.currentEvent.getDisplayName(), false);
        }
        return result;
    }

    private String getTagPrefix(Node node, String preferredPrefix, JsfCompoundCommand command) {
        String result = "";
        Document document = node.getOwnerDocument();
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)document);
        String uriForPrefix = mapper.getUriForPrefix(node.getPrefix());
        if (uriForPrefix.equals("http://www.ibm.com/jsf/BrowserFramework")) {
            result = node.getPrefix();
        } else {
            result = mapper.getPrefixForUri("http://www.ibm.com/jsf/html_extended");
            if (result == null) {
                result = this.generateUniquePrefix(mapper, preferredPrefix);
                JsfCommandUtil.appendTaglibCommand(document, command, "http://www.ibm.com/jsf/html_extended", result);
            }
        }
        return result;
    }

    private String generateUniquePrefix(TaglibPrefixUtil mapper, String preferredPrefix) {
        while (mapper.getUriForPrefix(preferredPrefix) != null) {
            preferredPrefix = String.valueOf(preferredPrefix) + "x";
        }
        return preferredPrefix;
    }

    private void findAndRemoveFuncCall() {
        Object node = null;
        if (this.currentEvent instanceof TagEventImpl) {
            node = ((TagEventImpl)this.currentEvent).getNode();
        } else if (ActionUtil.getActiveHTMLEditDomain() != null) {
            node = ActionUtil.getActiveHTMLEditDomain().getSelectionMediator().getRange().getEndContainer();
        }
        if (node == null) {
            return;
        }
        String attributeName = this.currentEvent.getDisplayName();
        String eventAttr = AttributeDataUtil.getAttributeValue((Node)node, (String)attributeName);
        if (eventAttr != null && !eventAttr.equals("")) {
            JsfCompoundCommand cmd = new JsfCompoundCommand(Messages.QEV_UpdateTag);
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put(attributeName, null);
            EditNodeAttributesCommand edit = new EditNodeAttributesCommand((Node)node, attrs);
            cmd.append((HTMLCommand)edit);
            cmd.execute();
        }
    }

    private void removeBehaviorNode(Node node) {
        if (node != null) {
            JsfCompoundCommand cmd = new JsfCompoundCommand(Messages.QEV_RemoveChild);
            RemoveNodeCommand remove = new RemoveNodeCommand(Messages.QEV_RemoveChild, node);
            cmd.append((HTMLCommand)remove);
            cmd.execute();
            this.behaviorNode = null;
        }
    }

    public void setupEditorForEvent(IEvent event, String language) {
        if (event instanceof TagEventImpl && ((TagEventImpl)event).getNode() instanceof ElementImplForJSP) {
            TagEventImpl tagEvent = (TagEventImpl)event;
            if (this.currentEvent != null && !this.currentEvent.equals(event) && this.initialScript != null && this.currentEvent != null && this.currentEvent.getScript() != null && this.initialScript.trim().equals(this.currentEvent.getScript().trim())) {
                JsfCompoundCommand cmd = new JsfCompoundCommand(Messages.QEV_UpdateTag);
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("onActionFunction", null);
                EditNodeAttributesCommand edit = new EditNodeAttributesCommand((Node)((TagEventImpl)this.currentEvent).getNode(), attrs);
                cmd.append((HTMLCommand)edit);
                cmd.execute();
            }
            Object targetNode = tagEvent.getNode();
            Object focusNode = targetNode;
            if (targetNode != null) {
                String eventAttr;
                if (!targetNode.getLocalName().equals("behavior")) {
                    targetNode = this.findTarget((Node)targetNode, event.getDisplayName(), true);
                } else {
                    focusNode = targetNode.getParentNode();
                    eventAttr = AttributeDataUtil.getAttributeValue((Node)targetNode, (String)"event");
                    if (eventAttr != null && !eventAttr.equals(event.getDisplayName())) {
                        targetNode = this.findTarget((Node)focusNode, event.getDisplayName(), true);
                    }
                }
                if (targetNode == null) {
                    this.behaviorNode = null;
                    this.fUseBehavior.setSelection(false);
                    this.disableBehaviorUI();
                    HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
                    if (actionTarget != null) {
                        TaglibPrefixUtil tlUtil = TaglibPrefixUtil.getMapperUtil((Document)actionTarget.getActiveModel().getDocument());
                        String odcPrefix = tlUtil.getPrefixForUri("http://www.ibm.com/jsf/BrowserFramework");
                        if (FindNodeUtil.isSameTagName((Node)focusNode, focusNode.getNodeName(), String.valueOf(odcPrefix) + ":" + "tabbedPanel") || FindNodeUtil.isSameTagName((Node)focusNode, focusNode.getNodeName(), String.valueOf(odcPrefix) + ":" + "bfPanel")) {
                            this.fUseBehavior.setEnabled(false);
                        } else {
                            this.fUseBehavior.setEnabled(true);
                        }
                    }
                } else {
                    this.behaviorNode = targetNode;
                    this.fUseBehavior.setSelection(true);
                    eventAttr = AttributeDataUtil.getAttributeValue((Node)this.behaviorNode, (String)"behaviorAction");
                    String actionDescription = null;
                    if (eventAttr != null && eventAttr.indexOf(";") != -1) {
                        actionDescription = Messages.Behavior_Action_Many_Description;
                    } else if (BehaviorActionTagToDescription.get(eventAttr) != null) {
                        actionDescription = BehaviorActionTagToDescription.get(eventAttr);
                    }
                    if (actionDescription == null || actionDescription.equals("")) {
                        actionDescription = Messages.Behavior_Action_Empty_Description;
                    }
                    this.fBehaviorAction.setText(actionDescription);
                    eventAttr = AttributeDataUtil.getAttributeValue((Node)this.behaviorNode, (String)"targetAction");
                    if (eventAttr != null && eventAttr.indexOf(";") != -1) {
                        eventAttr = Messages.Behavior_Target_Many_Description;
                    }
                    if (eventAttr == null || eventAttr.equals("")) {
                        eventAttr = Messages.Behavior_Target_Empty_Description;
                    }
                    this.fTargetAction.setText(eventAttr);
                    this.enableBehaviorUI();
                    if (Messages.Behavior_Action_Many_Description.equals(this.fBehaviorAction.getText())) {
                        this.fTargetAction.setEnabled(false);
                    }
                    if (!tagEvent.getNode().equals(this.behaviorNode)) {
                        tagEvent.setNode((IDOMNode)this.behaviorNode);
                    }
                }
            }
        }
        super.setupEditorForEvent(event, language);
    }

    protected void setupEditorForScriptedEvent(IEvent event, String language) {
        super.setupEditorForScriptedEvent(event, language);
    }

    private void enableBehaviorUI() {
        this.fBehaviorAction.setEnabled(true);
        this.fTargetAction.setEnabled(true);
        this.configMultiActions.setEnabled(true);
    }

    private void disableBehaviorUI() {
        this.fBehaviorAction.setEnabled(false);
        this.fTargetAction.setEnabled(false);
        this.configMultiActions.setEnabled(false);
        this.fBehaviorAction.setText(Messages.Behavior_Action_Empty_Description);
        this.fTargetAction.setText(Messages.Behavior_Target_Empty_Description);
    }

    private void editTag(String attrName, String attrValue) {
        String eventAttr;
        Object targetNode = ((TagEventImpl)this.currentEvent).getNode();
        if (targetNode == null) {
            return;
        }
        if (!targetNode.getLocalName().equals("behavior")) {
            targetNode = this.findTarget((Node)targetNode, this.currentEvent.getDisplayName(), true);
        }
        if (attrValue.equals("_remove_attribute")) {
            attrValue = null;
        }
        if (!((eventAttr = AttributeDataUtil.getAttributeValue((Node)targetNode, (String)attrName)) == null && attrValue == null || eventAttr != null && eventAttr.equals(attrValue))) {
            JsfCompoundCommand cmd = new JsfCompoundCommand(Messages.QEV_UpdateTag);
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(attrName, attrValue);
            EditNodeAttributesCommand edit = new EditNodeAttributesCommand((Node)targetNode, attrs);
            cmd.append((HTMLCommand)edit);
            cmd.execute();
        }
    }

    private Node findTarget(Node parent, String jsEventName, boolean deepSearch) {
        Node result = null;
        NodeList nl = FindNodeUtil.findChildren(parent, "behavior");
        if (nl != null && nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength() && result == null) {
                String eventAttr = AttributeDataUtil.getAttributeValue((Node)nl.item(i), (String)"event");
                if (eventAttr != null && eventAttr.equals(jsEventName)) {
                    result = nl.item(i);
                }
                ++i;
            }
        }
        if (result == null) {
            result = deepSearch ? BehaviorTagUtility.findbehaviorNodesBoundToMeDocSearch(parent, jsEventName) : BehaviorTagUtility.findbehaviorNodesBoundToMeSiblingSearch(parent, jsEventName);
        }
        return result;
    }
}

