/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.events.internal.ui;

import com.ibm.etools.jsf.events.internal.ui.JsfTextEditorQEVEditor;
import com.ibm.etools.jsf.events.internal.ui.StringComboBoxCellEditor;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.IBehaviorConstants;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;

public class ConfiureMultiBehaviourActionDialog
extends TrayDialog {
    private Composite buttonBarComposite;
    private TableViewer actionsTableViewer = null;
    private Button deleteActionTargetPair;
    private Button insertBeforeButton;
    private Button insertAfterButton;
    public List<DataObject> dataList = new ArrayList<DataObject>();
    private String[] columnNames = new String[]{Messages.Navigation_ActionRef_10, Messages.Target};

    public ConfiureMultiBehaviourActionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        this.createActionTableArea(composite);
        this.createButtonBarArea(composite);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment((Control)this.buttonBarComposite, -5);
        formData.bottom = new FormAttachment(100, -5);
        this.actionsTableViewer.getTable().setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, 0);
        this.buttonBarComposite.setLayoutData((Object)formData);
        this.getShell().setText(Messages.Behavior_Action_Multi_Actions_Title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.jsf.MultiBehaviorAction");
        return composite;
    }

    private void createButtonBarArea(Composite composite) {
        this.buttonBarComposite = new Composite(composite, 0);
        FormLayout layout = new FormLayout();
        this.buttonBarComposite.setLayout((Layout)layout);
        this.deleteActionTargetPair = new Button(this.buttonBarComposite, 8);
        this.deleteActionTargetPair.setText(Messages.Delete_Button);
        this.deleteActionTargetPair.setEnabled(false);
        this.deleteActionTargetPair.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfiureMultiBehaviourActionDialog.this.handleDeleteButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.insertBeforeButton = new Button(this.buttonBarComposite, 8);
        this.insertBeforeButton.setText(Messages.Insert_Before_Button);
        this.insertBeforeButton.setEnabled(false);
        this.insertBeforeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfiureMultiBehaviourActionDialog.this.handleInsertButtonSelected(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.insertAfterButton = new Button(this.buttonBarComposite, 8);
        this.insertAfterButton.setText(Messages.Insert_After_Button);
        this.insertAfterButton.setEnabled(false);
        this.insertAfterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfiureMultiBehaviourActionDialog.this.handleInsertButtonSelected(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.insertBeforeButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.insertBeforeButton, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.insertAfterButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.insertAfterButton, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.deleteActionTargetPair.setLayoutData((Object)formData);
    }

    private void handleDeleteButtonSelected() {
        if (this.actionsTableViewer.getSelection() instanceof StructuredSelection) {
            for (DataObject dataObject : (StructuredSelection)this.actionsTableViewer.getSelection()) {
                this.dataList.remove(dataObject);
                this.actionsTableViewer.remove((Object)dataObject);
            }
            if (this.dataList.size() == 0) {
                String action = "_remove_attribute";
                String target = Messages.Behavior_Target_Empty_Description;
                this.dataList.add(new DataObject(action, target));
                this.actionsTableViewer.setInput(this.dataList);
            }
        }
    }

    private void handleInsertButtonSelected(int type) {
        DataObject selectedDataObject;
        int index;
        StructuredSelection selection;
        DataObject dataObject = new DataObject("_remove_attribute", Messages.Behavior_Target_Empty_Description);
        if (this.actionsTableViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.actionsTableViewer.getSelection()).size() == 1 && (index = this.dataList.indexOf(selectedDataObject = (DataObject)selection.getFirstElement())) != -1) {
            if (type == 0) {
                this.dataList.add(index, dataObject);
            } else if (index != this.dataList.size()) {
                this.dataList.add(index + 1, dataObject);
            } else {
                this.dataList.add(dataObject);
            }
            this.actionsTableViewer.setInput(this.dataList);
        }
    }

    private void createActionTableArea(Composite composite) {
        Table table = new Table(composite, 68354);
        TableColumn actionColumn = new TableColumn(table, 2048);
        actionColumn.setText(Messages.Navigation_ActionRef_10);
        actionColumn.setWidth(100);
        TableColumn targetColumn = new TableColumn(table, 2048);
        targetColumn.setText(Messages.Target);
        targetColumn.setWidth(300);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(45, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(55, false));
        table.setLayout((Layout)tlayout);
        this.actionsTableViewer = new TableViewer(table);
        this.actionsTableViewer.setUseHashlookup(true);
        this.actionsTableViewer.setColumnProperties(this.columnNames);
        this.configureSelectionChangeListener();
        this.configureCellEditors(table);
        this.configureCellModifier();
        this.configureContentProvider();
        this.configureLabelProvider();
        this.actionsTableViewer.setInput(this.dataList);
    }

    private void configureCellModifier() {
        this.actionsTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                int columnIndex = ConfiureMultiBehaviourActionDialog.this.getColumnNames().indexOf(property);
                String result = null;
                DataObject dataObject = (DataObject)element;
                switch (columnIndex) {
                    case 0: {
                        result = dataObject.getActionDescription();
                        break;
                    }
                    case 1: {
                        result = dataObject.getTarget();
                        break;
                    }
                    default: {
                        result = "";
                    }
                }
                return result;
            }

            public void modify(Object element, String property, Object value) {
                int columnIndex = ConfiureMultiBehaviourActionDialog.this.getColumnNames().indexOf(property);
                TableItem item = (TableItem)element;
                DataObject dataObject = (DataObject)item.getData();
                String valueString = ((String)value).trim();
                switch (columnIndex) {
                    case 0: {
                        dataObject.setActionDescription(valueString);
                        dataObject.setAction(JsfTextEditorQEVEditor.DescriptionToBehaviorActionTag.get(valueString));
                        break;
                    }
                    case 1: {
                        dataObject.setTarget(valueString);
                    }
                }
                ConfiureMultiBehaviourActionDialog.this.actionsTableViewer.update((Object)dataObject, null);
            }
        });
    }

    private void configureCellEditors(Table table) {
        CellEditor[] editors = new CellEditor[2];
        ArrayList<String> validActions = new ArrayList<String>();
        int i = 0;
        while (i < IBehaviorConstants.behaviorActionDescriptions.length) {
            String action = IBehaviorConstants.behaviorActionDescriptions[i];
            if (!action.equals(Messages.Behavior_Action_Empty_Description) && !action.equals(Messages.Behavior_Action_Many_Description)) {
                validActions.add(action);
            }
            ++i;
        }
        editors[0] = new StringComboBoxCellEditor((Composite)table, validActions.toArray(new String[validActions.size()]), 8);
        HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
        if (actionTarget != null) {
            IDOMDocument d = actionTarget.getActiveModel().getDocument();
            editors[1] = new StringComboBoxCellEditor((Composite)table, JsfTextEditorQEVEditor.getNodeIds((Document)d), 4);
        }
        this.actionsTableViewer.setCellEditors(editors);
    }

    private void configureSelectionChangeListener() {
        this.actionsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection ss = (StructuredSelection)event.getSelection();
                    if (!ss.isEmpty()) {
                        if (ConfiureMultiBehaviourActionDialog.this.actionsTableViewer.getTable().getItems().length == 1) {
                            DataObject dataObject = (DataObject)ss.getFirstElement();
                            if (!dataObject.getAction().equals("_remove_attribute")) {
                                ConfiureMultiBehaviourActionDialog.this.deleteActionTargetPair.setEnabled(true);
                            }
                        } else {
                            ConfiureMultiBehaviourActionDialog.this.deleteActionTargetPair.setEnabled(true);
                        }
                    } else {
                        ConfiureMultiBehaviourActionDialog.this.deleteActionTargetPair.setEnabled(false);
                    }
                    if (ss.size() == 1) {
                        ConfiureMultiBehaviourActionDialog.this.insertAfterButton.setEnabled(true);
                        ConfiureMultiBehaviourActionDialog.this.insertBeforeButton.setEnabled(true);
                    } else {
                        ConfiureMultiBehaviourActionDialog.this.insertAfterButton.setEnabled(false);
                        ConfiureMultiBehaviourActionDialog.this.insertBeforeButton.setEnabled(false);
                    }
                }
            }
        });
    }

    private void configureLabelProvider() {
        this.actionsTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof DataObject) {
                    if (columnIndex == 0) {
                        return ((DataObject)element).getActionDescription();
                    }
                    if (columnIndex == 1) {
                        return ((DataObject)element).getTarget();
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void configureContentProvider() {
        this.actionsTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public class DataObject {
        private String action;
        private String actionDescription;
        private String target;

        public DataObject(String action, String target) {
            this.action = action;
            this.target = target;
            String description = action;
            if (JsfTextEditorQEVEditor.BehaviorActionTagToDescription.containsKey(action)) {
                description = JsfTextEditorQEVEditor.BehaviorActionTagToDescription.get(action);
            }
            this.actionDescription = description;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getActionDescription() {
            return this.actionDescription;
        }

        public void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }
    }
}

