/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.generator;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.adapters.IJsfDataAdapter;
import com.ibm.etools.jsf.databind.adapters.ITagDefinition;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.databind.generator.JsfGeneratorBase;
import com.ibm.etools.jsf.internal.databind.templates.TemplateGenerator;
import com.ibm.etools.jsf.internal.databind.templates.TemplateProvider;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.BaseVariableResolver;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IGenerationTemplate;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.Interface;
import com.ibm.etools.webtools.wizards.cgen.FilesPreferenceUtil;
import java.util.Map;
import java.util.Set;

public class SingleControlGenerator
extends JsfGeneratorBase {
    private ICodeGenNode rootCodeGenNode;
    private String parentBeanName;
    private String taglibUri;
    private String tagName;

    @Override
    protected void clear() {
        super.clear();
        this.rootCodeGenNode = null;
        this.parentBeanName = null;
        this.taglibUri = null;
        this.tagName = null;
    }

    public String perform(ICodeGenNode node) {
        try {
            this.setCodeGenNode(node);
            String generatedCode = "";
            if (!TemplateProvider.useJavajetTemplates()) {
                BaseVariableResolver baseResolver = new BaseVariableResolver(node, this.getRootCodeGenNode(), this.getParentBeanName(), null, null);
                TemplateGenerator t = new TemplateGenerator(baseResolver);
                generatedCode = t.resolvePropertyTemplates();
                if (this.getModel().getControlType() == 2 || this.getModel().getControlType() == 1) {
                    this.getModel().addCustomProperty((Object)"requires_form", (Object)Boolean.TRUE);
                }
            }
            if (generatedCode.equals("")) {
                IGenerationTemplate template = this.getTemplate();
                if (template != null) {
                    generatedCode = template.generate((Interface)this);
                }
                if (this.isFormRequired()) {
                    this.getModel().addCustomProperty((Object)"requires_form", (Object)Boolean.TRUE);
                }
            }
            String string = generatedCode;
            return string;
        }
        catch (Exception e) {
            JsfPlugin.log(e);
            return "";
        }
        finally {
            this.clear();
        }
    }

    protected boolean isFormRequired() {
        String controlId = this.getCodeGenNode().getControlId();
        if (controlId != null && !"".equals(controlId) && controlId.equals("outputLink")) {
            return false;
        }
        return JsfCommandUtil.requiresForm(this.getTaglibUri(), this.getTagName());
    }

    protected void setParentBeanName(String name) {
        this.parentBeanName = name;
    }

    protected String getParentBeanName() {
        return this.parentBeanName;
    }

    public String getValue() {
        String ref = null;
        IBindingAttribute attr = (IBindingAttribute)this.getPageDataNode().getAdapter(IBindingAttribute.ADAPTER_KEY);
        String relativeRef = attr.getRelativeReferenceString(this.getRootCodeGenNode().getEnclosedNode(), this.getPageDataNode());
        String controlId = this.getControlId();
        ref = this.parentBeanName == null || this.parentBeanName.equals("") ? attr.getReferenceString(this.getPageDataNode()) : (relativeRef == null || relativeRef.equals("") ? this.parentBeanName : String.valueOf(this.parentBeanName) + "." + relativeRef);
        if (controlId != null && !"".equals(controlId) && (controlId.equals("image") || controlId.equals("outputLink") || controlId.equals("fileupload"))) {
            ref = BindingUtil.removeLastIndexReference(ref);
        }
        if (ref == null || ref.equals("")) {
            return "";
        }
        return ref;
    }

    public String getId() {
        return this.internalGetId(this.getCodeGenNode());
    }

    protected String internalGetId(ICodeGenNode node) {
        String id = new String("");
        String pdnName = ((IBindingAttribute)node.getEnclosedNode().getAdapter(IBindingAttribute.ADAPTER_KEY)).getName(node.getEnclosedNode());
        id = !"".equals(pdnName) && pdnName != null ? this.getId(this.getTaglibUri(), this.getTagName(), pdnName) : this.getId(this.getTaglibUri(), this.getTagName(), node.getControlId());
        return id;
    }

    public String getValueAttribute() {
        StringBuffer buffer = new StringBuffer();
        String value = this.getValue();
        if (!"".equals(value) && value != null) {
            buffer.append(" value=\"#{");
            buffer.append(value);
            buffer.append("}\"");
        }
        return buffer.toString();
    }

    public String getRequiredAttribute() {
        StringBuffer buffer = new StringBuffer();
        IJsfDataAdapter adapter = (IJsfDataAdapter)this.getCodeGenNode().getEnclosedNode().getAdapter(IJsfDataAdapter.ADAPTER_KEY);
        if (adapter != null && adapter.isRequired()) {
            buffer.append(" required=\"true\"");
        }
        return buffer.toString();
    }

    public String getConverterTag() {
        ITagDefinition converterTag;
        StringBuffer buffer = new StringBuffer();
        IJsfDataAdapter adapter = (IJsfDataAdapter)this.getCodeGenNode().getEnclosedNode().getAdapter(IJsfDataAdapter.ADAPTER_KEY);
        if (adapter != null && (converterTag = adapter.getConverterTag()) != null) {
            this.readTagDefinition(converterTag, buffer);
        }
        return buffer.toString();
    }

    public String getValidatorTags() {
        StringBuffer buffer = new StringBuffer();
        IJsfDataAdapter adapter = (IJsfDataAdapter)this.getCodeGenNode().getEnclosedNode().getAdapter(IJsfDataAdapter.ADAPTER_KEY);
        ICodeGenModel dataModel = this.getCodeGenNode().getCodeGenModel();
        if (adapter != null && dataModel.isGenValidation()) {
            ITagDefinition[] tags = adapter.getValidatorTags();
            int i = 0;
            while (i < tags.length) {
                ITagDefinition validatorTag = tags[i];
                if (validatorTag != null) {
                    this.readTagDefinition(validatorTag, buffer);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    protected String readTagDefinition(ITagDefinition tag, StringBuffer buffer) {
        String taglib = tag.getTaglibUri();
        String preferredPrefix = tag.getPreferredPrefix();
        String tagName = tag.getTagName();
        if (!("".equals(taglib) || taglib == null || "".equals(preferredPrefix) || preferredPrefix == null || "".equals(tagName) || tagName == null)) {
            String prefix = this.getTaglibPrefix(taglib, preferredPrefix);
            this.addTag(prefix, tagName, tag.getAttributes(), buffer);
        }
        return buffer.toString();
    }

    protected void addAttributes(Map<String, String> map, StringBuffer buffer) {
        if (map != null) {
            Set<Map.Entry<String, String>> mapSet = map.entrySet();
            for (Map.Entry<String, String> entry : mapSet) {
                buffer.append(" ");
                buffer.append(entry.getKey());
                buffer.append("=\"");
                buffer.append(entry.getValue());
                buffer.append("\"");
            }
        }
    }

    protected void addTag(String prefix, String name, Map<String, String> map, StringBuffer buffer) {
        buffer.append("<");
        buffer.append(prefix);
        buffer.append(":");
        buffer.append(name);
        this.addAttributes(map, buffer);
        buffer.append("/>");
        buffer.append(FilesPreferenceUtil.getEndOfLineCodeForJSP());
    }

    public String getOutputLinkLabel() {
        String result = this.getCodeGenNode().getLabel();
        return result;
    }

    public String getTaglibUri() {
        return this.taglibUri;
    }

    public void setTaglibUri(String taglibUri) {
        this.taglibUri = taglibUri;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    protected void setRootCodeGenNode(ICodeGenNode parentNode) {
        this.rootCodeGenNode = parentNode;
    }

    protected ICodeGenNode getRootCodeGenNode() {
        return this.rootCodeGenNode;
    }
}

