/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.generator;

import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.databind.generator.JsfInterface;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.CodeGenerationManager;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.Generator;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IGenerationTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;

public abstract class JsfGeneratorBase
implements Generator,
JsfInterface {
    private ICodeGenNode codeGenNode;
    private ICodeGenModel model;

    protected void clear() {
        this.codeGenNode = null;
        this.model = null;
    }

    public String getControlId() {
        if (this.codeGenNode != null) {
            return this.codeGenNode.getControlId();
        }
        return null;
    }

    protected IPageDataNode getPageDataNode() {
        return this.codeGenNode.getEnclosedNode();
    }

    protected String getType() {
        return this.getBindingAttribute().getRuntimeType(this.getPageDataNode());
    }

    public void setCodeGenNode(ICodeGenNode node) {
        this.codeGenNode = node;
        this.model = node.isListNode() && node != node.getCodeGenModel().getRoot() ? node.getChildCodeGenModel() : node.getCodeGenModel();
    }

    @Override
    public ICodeGenNode getCodeGenNode() {
        return this.codeGenNode;
    }

    protected IBindingAttribute getBindingAttribute() {
        return (IBindingAttribute)this.getPageDataNode().getAdapter(IBindingAttribute.ADAPTER_KEY);
    }

    protected IBindingAttribute getBindingAttribute(IPageDataNode node) {
        return (IBindingAttribute)node.getAdapter(IBindingAttribute.ADAPTER_KEY);
    }

    protected String getType(ICodeGenNode node) {
        IPageDataNode pdNode = node.getEnclosedNode();
        return this.getBindingAttribute(pdNode).getRuntimeType(pdNode);
    }

    protected IGenerationTemplate getTemplate() {
        return CodeGenerationManager.getTemplateForControl((String)this.model.getPageType(), (String)this.codeGenNode.getControlId());
    }

    protected IGenerationTemplate getTemplate(ICodeGenNode node) {
        return CodeGenerationManager.getTemplateForControl((String)this.model.getPageType(), (String)node.getControlId());
    }

    protected ICodeGenModel getModel() {
        return this.model;
    }

    @Override
    public String getId(String taglibUri, String tagName) {
        return this.getId(taglibUri, tagName, "");
    }

    public String getId(String taglibUri, String tagName, String preferredId) {
        String id;
        String presetId = (String)this.getModel().getCustomProperty((Object)"precomputed_id");
        if (!"".equals(presetId) && presetId != null) {
            this.getModel().addCustomProperty((Object)"precomputed_id", null);
            return presetId;
        }
        IDOMDocument d = BindingUtil.getDocument(this.getModel().getRoot().getEnclosedNode());
        ArrayList<String> newIds = null;
        newIds = (ArrayList<String>)this.model.getCustomProperty((Object)"id_list");
        if (newIds == null) {
            newIds = new ArrayList<String>();
            this.model.addCustomProperty((Object)"id_list", newIds);
        }
        IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)d);
        if ("".equals(preferredId) || preferredId == null) {
            id = JsfComponentUtil.getIdPrefix((String)taglibUri, (String)tagName, (IProject)project);
        } else {
            id = JsfComponentUtil.fixupId((String)preferredId);
            String rendererName = JsfComponentUtil.fixupId((String)JsfComponentUtil.getRendererName((String)taglibUri, (String)tagName, (IProject)project));
            if (rendererName != null && !"".equals(rendererName)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(rendererName);
                buffer.append(Character.toUpperCase(id.charAt(0)));
                buffer.append(id.substring(1));
                id = buffer.toString();
            }
        }
        id = JsfComponentUtil.generateUniqueId((Document)d, (String)id, newIds);
        newIds.add(id);
        return id;
    }

    @Override
    public String getTaglibPrefix(String taglibUri, String preferredPrefix) {
        IDOMDocument d = BindingUtil.getDocument(this.getModel().getRoot().getEnclosedNode());
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)d);
        String prefix = mapper.getPrefixForUri(taglibUri);
        if (prefix == null) {
            prefix = this.generateUniquePrefix(mapper, preferredPrefix);
            mapper.addMapping(prefix, taglibUri);
            HashMap<String, String> newTaglibs = null;
            newTaglibs = (HashMap<String, String>)this.model.getCustomProperty((Object)"new_taglibs");
            if (newTaglibs == null) {
                newTaglibs = new HashMap<String, String>();
                this.model.addCustomProperty((Object)"new_taglibs", newTaglibs);
            }
            newTaglibs.put(prefix, taglibUri);
        }
        return prefix;
    }

    private String generateUniquePrefix(TaglibPrefixUtil mapper, String preferredPrefix) {
        while (mapper.getUriForPrefix(preferredPrefix) != null) {
            preferredPrefix = String.valueOf(preferredPrefix) + "x";
        }
        return preferredPrefix;
    }

    protected void addScript(String uri) {
        ArrayList<String> scriptRefs = (ArrayList<String>)this.model.getCustomProperty((Object)"new_script_refs");
        if (scriptRefs == null) {
            scriptRefs = new ArrayList<String>();
            this.model.addCustomProperty((Object)"new_script_refs", scriptRefs);
        }
        if (!scriptRefs.contains(uri)) {
            scriptRefs.add(uri);
        }
    }

    protected void addStylesheet(String cssName) {
        ArrayList<String> stylesheets = (ArrayList<String>)this.model.getCustomProperty((Object)"new_stylesheets");
        if (stylesheets == null) {
            stylesheets = new ArrayList<String>();
            this.model.addCustomProperty((Object)"new_stylesheets", stylesheets);
        }
        if (!stylesheets.contains(cssName)) {
            stylesheets.add(cssName);
        }
    }

    protected ICodeGenModel getCodeGenModel() {
        return this.model;
    }
}

