/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.generator;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.commands.DataTableBindingHelper;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.databind.dnd.TableInspectorUtil;
import com.ibm.etools.jsf.databind.generator.IGenerationConstants;
import com.ibm.etools.jsf.databind.generator.SingleControlGenerator;
import com.ibm.etools.jsf.databind.generator.TableGenerator;
import com.ibm.etools.jsf.internal.databind.templates.TemplateGenerator;
import com.ibm.etools.jsf.internal.databind.templates.TemplateProvider;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.BaseVariableResolver;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.preferences.JsfTagModeUtil;
import com.ibm.etools.jsf.support.StringUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.CodeGenerationManager;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IGenerationTemplate;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.Interface;
import com.ibm.etools.webtools.wizards.cgen.FilesPreferenceUtil;
import java.util.Stack;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTableGenerator
extends SingleControlGenerator {
    private String varAttribute = null;
    private String columnLabel = null;
    private Stack<String> varStack;
    private int currentColumn;

    @Override
    protected void clear() {
        super.clear();
        this.varAttribute = null;
        this.columnLabel = null;
        this.varStack = null;
        this.currentColumn = 0;
    }

    @Override
    public String perform(ICodeGenNode node) {
        try {
            this.setCodeGenNode(node);
            String controlId = node.getControlId();
            ICodeGenModel model = this.getModel();
            boolean useExistingGrid = false;
            StringBuffer generatedCode = new StringBuffer("");
            if (controlId == null || model == null) {
                return "";
            }
            if (!TemplateProvider.useJavajetTemplates()) {
                BaseVariableResolver baseResolver = new BaseVariableResolver(node, this.getRootCodeGenNode(), this.getParentBeanName(), this.getVar(), null);
                baseResolver.setupVarStack();
                TemplateGenerator t = new TemplateGenerator(baseResolver);
                generatedCode = t.resolveWrapperTemplates();
                if (this.getModel().getControlType() == 2 || this.getModel().getControlType() == 1) {
                    this.getModel().addCustomProperty((Object)"requires_form", (Object)Boolean.TRUE);
                }
                baseResolver.popVarStack();
            }
            if (generatedCode.length() == 0) {
                this.setupVarStack();
                useExistingGrid = this.useExistingGrid(generatedCode, node);
                if (!useExistingGrid) {
                    IGenerationTemplate template = StringUtil.belongsTo(controlId, IGenerationConstants.DATA_TABLE_TAGS) ? (JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProjectForPage((IDOMDocument)EditDomainUtil.getEditDomain().getModel().getDocument())) ? CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"dataTableEx") : CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"dataTable")) : this.getTemplate();
                    if (template != null) {
                        generatedCode.append(template.generate((Interface)this));
                    }
                }
                this.popVarStack();
            }
            String string = generatedCode.toString();
            return string;
        }
        catch (Exception e) {
            JsfPlugin.log(e);
            return "";
        }
        finally {
            this.clear();
        }
    }

    protected boolean useExistingGrid(StringBuffer result, ICodeGenNode currentNode) {
        if (!JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProject())) {
            return false;
        }
        boolean compatibleGrid = false;
        Node targetNode = JsfCommandUtil.getTargetNode(EditDomainUtil.getEditDomain().getSelectionMediator().getRange());
        Node outerDataTable = TableInspectorUtil.getParentDataTable(targetNode);
        Node outerColumn = TableInspectorUtil.getParentColumn(targetNode);
        if (outerDataTable != null && !outerDataTable.equals("") && outerColumn != null) {
            Element tableElement = (Element)outerDataTable;
            String outerDataTableValue = BindingUtil.removeVbl(tableElement.getAttribute("value"));
            if (outerDataTableValue != null && !outerDataTableValue.equals("")) {
                String currentDataTableValue = this.getValue();
                if (DataTableBindingHelper.sameBean(currentDataTableValue, outerDataTableValue)) {
                    compatibleGrid = true;
                    result.append(this.generateSingleColumnGrid());
                } else if (this.getModel().getControlId().equals("unformattedControls")) {
                    currentNode.setControlId("unformattedSingleCol");
                } else if (this.getModel().getControlId().equals("formattedControls")) {
                    currentNode.setControlId("singleColumnGrid");
                }
            } else {
                compatibleGrid = true;
                Element el = (Element)outerDataTable;
                el.setAttribute("value", BindingUtil.makeVbl(this.getValue()));
                el.setAttribute("var", this.getVar());
                result.append(this.generateSingleColumnGrid());
            }
        }
        return compatibleGrid;
    }

    public String generateColumns() {
        StringBuffer result = new StringBuffer();
        String controlId = this.getCodeGenNode().getControlId();
        if (controlId != null && !"".equals(controlId)) {
            if (controlId.equals("singleColumnGrid") || controlId.equals("unformattedSingleCol")) {
                this.addColumnsSingleFormat(result);
            } else {
                this.addColumnsMultiFormat(result);
            }
        }
        return result.toString();
    }

    protected void addColumnsSingleFormat(StringBuffer result) {
        IGenerationTemplate template = CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"jspPanelInColumnEx");
        this.setColumnLabel(this.removeFinalColon(this.getCodeGenNode().getLabel()));
        if (template != null) {
            result.append(template.generate((Interface)this));
        }
    }

    protected void addColumnsMultiFormat(StringBuffer result) {
        int numNodes = this.getCodeGenModel().getCodeGenNodes().size();
        int i = 0;
        while (i < numNodes) {
            ICodeGenNode currentNode = (ICodeGenNode)this.getModel().getCodeGenNodes().get(i);
            this.setColumnLabel(currentNode.getLabel());
            if (currentNode.isSelected()) {
                IGenerationTemplate template = JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProjectForPage((IDOMDocument)EditDomainUtil.getEditDomain().getModel().getDocument())) ? CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"columnEx") : CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"column");
                if (template != null) {
                    result.append(template.generate((Interface)this));
                }
                this.addColumnComponent(result, currentNode);
                this.addCloseColumnTag(result);
            }
            ++i;
        }
    }

    public String generateSingleColumnGrid() {
        String controlId = this.getCodeGenNode().getControlId();
        if (controlId != null && !"".equals(controlId)) {
            if (controlId.equals("unformattedSingleCol") || Boolean.TRUE.equals(this.getModel().getCustomProperty((Object)"unformattedControls"))) {
                return this.addControlsNoFormatting();
            }
            TableGenerator generator = new TableGenerator();
            generator.setParentBeanName(this.getVar());
            generator.setCodeGenNode(this.getCodeGenNode());
            generator.setTemplateName("table");
            generator.setAddMessages(false);
            generator.setAddSubmitButton(false);
            generator.setAddDeleteButton(false);
            IGenerationTemplate template = CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"table");
            if (template != null) {
                return template.generate((Interface)generator);
            }
            return "";
        }
        return "";
    }

    protected String addControlsNoFormatting() {
        StringBuffer buffer = new StringBuffer();
        ICodeGenModel currentModel = this.getModel();
        if (currentModel != null) {
            int numControls = currentModel.getCodeGenNodes().size();
            int i = 0;
            while (i < numControls) {
                ICodeGenNode currentNode = (ICodeGenNode)this.getModel().getCodeGenNodes().get(i);
                if (currentNode.isSelected()) {
                    this.addColumnComponent(buffer, currentNode);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    protected String generateControlTag(int currentRow) {
        StringBuffer result = new StringBuffer();
        ICodeGenNode currentNode = (ICodeGenNode)this.getModel().getCodeGenNodes().get(currentRow);
        this.addColumnComponent(result, currentNode);
        return result.toString();
    }

    protected void addColumnComponent(StringBuffer result, ICodeGenNode currentNode) {
        if (currentNode.isListNode()) {
            DataTableGenerator generator = new DataTableGenerator();
            generator.setParentBeanName(this.getVar());
            generator.setRootCodeGenNode(this.getCodeGenNode());
            result.append(generator.perform(currentNode));
        } else {
            SingleControlGenerator generator = new SingleControlGenerator();
            generator.setParentBeanName(this.getVar());
            generator.setRootCodeGenNode(this.getCodeGenNode());
            result.append(generator.perform(currentNode));
        }
    }

    protected void addCloseColumnTag(StringBuffer result) {
        IGenerationTemplate template = JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProjectForPage((IDOMDocument)EditDomainUtil.getEditDomain().getModel().getDocument())) ? CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"closeColumnEx") : CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"closeColumn");
        if (template != null) {
            result.append(template.generate((Interface)this));
        }
        result.append(FilesPreferenceUtil.getEndOfLineCodeForJSP());
    }

    @Override
    public String getValue() {
        IPageDataNode object;
        String parentBeanName = this.getParentBeanName();
        IBindingAttribute attr = (IBindingAttribute)this.getPageDataNode().getAdapter(IBindingAttribute.ADAPTER_KEY);
        if (parentBeanName == null) {
            String beanName = attr.getReferenceString(this.getPageDataNode());
            beanName = BindingUtil.removeLastIndexReference(beanName);
            return beanName;
        }
        IPageDataNode refNode = this.getRootCodeGenNode().getEnclosedNode();
        if (refNode == (object = this.getPageDataNode())) {
            return parentBeanName;
        }
        String beanName = attr.getRelativeReferenceString(refNode, object);
        if ("".equals(beanName = BindingUtil.removeLastIndexReference(beanName))) {
            return parentBeanName;
        }
        return String.valueOf(parentBeanName) + "." + beanName;
    }

    protected String removeFinalColon(String label) {
        if (label == null) {
            return null;
        }
        if ((label = label.trim()).lastIndexOf(":") == label.length() - 1) {
            label = label.substring(0, label.length() - 1);
        }
        return label;
    }

    protected void setupVarStack() {
        this.varStack = (Stack)this.getModel().getCustomProperty((Object)"var_stack");
        if (this.varStack == null) {
            this.varStack = new Stack();
            this.getModel().addCustomProperty((Object)"var_stack", this.varStack);
        }
        String newVar = BindingUtil.computeVarAttribute(this.getValue(), this.varStack);
        this.varStack.push(newVar);
        this.setVar(newVar);
    }

    public String getVar() {
        return this.varAttribute;
    }

    public void setVar(String string) {
        this.varAttribute = string;
    }

    protected String getConverter() {
        return null;
    }

    protected String getBeanName() {
        return null;
    }

    protected void popVarStack() {
        this.varStack.pop();
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    protected void setColumnLabel(String string) {
        this.columnLabel = string;
    }

    protected String getLabel() {
        return this.getBindingAttribute().getName(this.getPageDataNode());
    }

    protected int getCurrentColumn() {
        return this.currentColumn;
    }

    protected void setCurrentColumn(int i) {
        this.currentColumn = i;
    }
}

